/*  XFC: Xfce Foundation Classes (User Interface Library)
 *  Copyright (C) 2004-2005 The XFC Development Team.
 *
 *  itemsignals.cc - Gtk::Item virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "item.hh"
#include "itemsignals.hh"
#include "private/itemclass.hh"

using namespace Xfc;

/*  Gtk::ItemSignals
 */

Gtk::ItemSignals::ItemSignals(Item *item)
: ContainerSignals(item)
{
}

Gtk::ItemSignals::~ItemSignals()
{
}

void
Gtk::ItemSignals::on_select()
{
	GtkItemClass *g_class = ItemClass::get_parent_class(instance_);
	if (g_class && g_class->select)
		g_class->select((GtkItem*)instance_);
}

void
Gtk::ItemSignals::on_deselect()
{
	GtkItemClass *g_class = ItemClass::get_parent_class(instance_);
	if (g_class && g_class->deselect)
		g_class->deselect((GtkItem*)instance_);
}

void
Gtk::ItemSignals::on_toggle()
{
	GtkItemClass *g_class = ItemClass::get_parent_class(instance_);
	if (g_class && g_class->toggle)
		g_class->toggle((GtkItem*)instance_);
}

