/*  XFC: Xfce Foundation Classes (Core Library)
 *  Copyright (C) 2004 The XFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/// @file xfc/glib/g.hh
/// @brief Main G header file
///
/// This header file includes all the G header files. You can safely include
/// this header file only, with minimal extra overhead, because each header file
/// uses include guards to prevent multiple inclusions.

#ifndef XFC_G_HH
#define XFC_G_HH

#include <xfc/glib/asyncqueue.hh>
#include <xfc/glib/completion.hh>
#include <xfc/glib/date.hh>
#include <xfc/glib/error.hh>
#include <xfc/glib/fileutils.hh>
#include <xfc/glib/main.hh>
#include <xfc/glib/markup.hh>
#include <xfc/glib/module.hh>
#include <xfc/glib/pattern.hh>
#include <xfc/glib/object.hh>
#include <xfc/glib/rand.hh>
#include <xfc/glib/scanner.hh>
#include <xfc/glib/shell.hh>
#include <xfc/glib/spawn.hh>
#include <xfc/glib/timer.hh>
#include <xfc/glib/thread.hh>
#include <xfc/glib/threadpool.hh>

#endif // XFC_G_HH

