config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/gtk-2.0/gtkrc.new
config etc/gtk-2.0/im-multipress.conf.new
rm -f etc/gtk-2.0/gtkrc.new

chroot . rm -f /usr/share/icons/*/icon-theme.cache 1> /dev/null 2> /dev/null

# Run this if we are on an installed system.  Otherwise it will be
# handled on first boot.
if [ -x /usr/bin/update-gtk-immodules-2.0 ]; then
  /usr/bin/update-gtk-immodules
fi

# In case this is the first run installing the standalone gdk-pixbuf,
# we will run this a second time to fix machines that will not reboot.
chroot . /usr/bin/update-gdk-pixbuf-loaders 1> /dev/null 2> /dev/null

( cd usr/bin ; rm -rf gtk-query-immodules-2.0 )
( cd usr/bin ; ln -sf gtk-query-immodules-2.0-32 gtk-query-immodules-2.0 )
( cd usr/doc/gtk+-2.24.10 ; rm -rf gdk )
( cd usr/doc/gtk+-2.24.10 ; ln -sf ../../share/gtk-doc/html/gdk gdk )
( cd usr/doc/gtk+-2.24.10 ; rm -rf gtk )
( cd usr/doc/gtk+-2.24.10 ; ln -sf ../../share/gtk-doc/html/gtk gtk )
( cd usr/doc/gtk+-2.24.10 ; rm -rf gail-libgail-util )
( cd usr/doc/gtk+-2.24.10 ; ln -sf ../../share/gtk-doc/html/gail-libgail-util gail-libgail-util )
( cd usr/lib ; rm -rf libgailutil.so )
( cd usr/lib ; ln -sf libgailutil.so.18.0.1 libgailutil.so )
( cd usr/lib ; rm -rf libgdk-x11-2.0.so.0 )
( cd usr/lib ; ln -sf libgdk-x11-2.0.so.0.2400.10 libgdk-x11-2.0.so.0 )
( cd usr/lib ; rm -rf libgdk-x11-2.0.so )
( cd usr/lib ; ln -sf libgdk-x11-2.0.so.0.2400.10 libgdk-x11-2.0.so )
( cd usr/lib ; rm -rf libgailutil.so.18 )
( cd usr/lib ; ln -sf libgailutil.so.18.0.1 libgailutil.so.18 )
( cd usr/lib ; rm -rf libgtk-x11-2.0.so.0 )
( cd usr/lib ; ln -sf libgtk-x11-2.0.so.0.2400.10 libgtk-x11-2.0.so.0 )
( cd usr/lib ; rm -rf libgtk-x11-2.0.so )
( cd usr/lib ; ln -sf libgtk-x11-2.0.so.0.2400.10 libgtk-x11-2.0.so )
