# Grantlee CMake configuration file - http://www.grantlee.org/

# Any changes in this file will be overwritten by CMake.

get_filename_component(myDir ${CMAKE_CURRENT_LIST_FILE} PATH) # get the directory where I myself am
get_filename_component(rootDir ${myDir}/../../../ ABSOLUTE) # get the chosen install prefix

if (Grantlee_FIND_COMPONENTS)
  foreach( component ${Grantlee_FIND_COMPONENTS})
    if (component STREQUAL "Textdocument")
      set(RequiredQtComponents ${RequiredQtComponents} QtCore QtGui)
    endif()
    if (component STREQUAL "Templates")
      set(RequiredQtComponents ${RequiredQtComponents} QtCore)
    endif()
  endforeach()
  find_package(Qt4 REQUIRED ${RequiredQtComponents})
else()
  find_package(Qt4 REQUIRED)
endif()

set(Grantlee_VERSION_MAJOR "0")
set(Grantlee_VERSION_MINOR "2")
set(Grantlee_VERSION_PATCH "0")

set(Grantlee_MIN_PLUGIN_VERSION "0.1")

set(Grantlee_INSTALL_PREFIX "${rootDir}")
set(Grantlee_INCLUDE_DIRS   "${rootDir}/include")

set(Grantlee_LIBRARY_DIR    "${rootDir}/lib")
set(Grantlee_MODULE_DIR     "${Grantlee_LIBRARY_DIR}/cmake/grantlee")

set(Grantlee_PLUGIN_DIR     "${Grantlee_LIBRARY_DIR}")

set(Grantlee_TEMPLATES_LIBRARY grantlee_core)
set(Grantlee_TEXTDOCUMENT_LIBRARY grantlee_gui)

set(Grantlee_TEMPLATES_LIBRARIES ${Grantlee_TEMPLATES_LIBRARY} )
set(Grantlee_TEXTDOCUMENT_LIBRARIES ${Grantlee_TEXTDOCUMENT_LIBRARY} )

# For backwards compatibility
set(Grantlee_CORE_LIBRARY ${Grantlee_TEMPLATES_LIBRARY})
set(Grantlee_CORE_LIBRARIES ${Grantlee_TEMPLATES_LIBRARIES})
set(Grantlee_GUI_LIBRARY ${Grantlee_TEXTDOCUMENT_LIBRARY})
set(Grantlee_GUI_LIBRARIES ${Grantlee_TEXTDOCUMENT_LIBRARIES})
set(Grantlee_PLUGIN_PATH ${Grantlee_PLUGIN_DIR})

# Now for the use file, which contains useful functions, sets up the project
set(Grantlee_USE_FILE "${myDir}/GrantleeUse.cmake")

include(${myDir}/GrantleeTargets.cmake)
