var NAVTREE =
[
  [ "Doxygen Manual", "index.html", [
    [ "Installation", "install.html", [
      [ "Compiling from source on UNIX", "install.html#install_src_unix", null ],
      [ "Installing the binaries on UNIX", "install.html#install_bin_unix", null ],
      [ "Known compilation problems for UNIX", "install.html#unix_problems", null ],
      [ "Compiling from source on Windows", "install.html#install_src_windows", null ],
      [ "Installing the binaries on Windows", "install.html#install_bin_windows", null ],
      [ "Tools used to develop doxygen", "install.html#build_tools", null ]
    ] ],
    [ "Getting started", "starting.html", [
      [ "Step 0: Check if doxygen supports your programming language", "starting.html#step0", null ],
      [ "Step 1: Creating a configuration file", "starting.html#step1", null ],
      [ "Step 2: Running doxygen", "starting.html#step2", [
        [ "HTML output", "starting.html#html_out", null ],
        [ "LaTeX output", "starting.html#latex_out", null ],
        [ "RTF output", "starting.html#rtf_out", null ],
        [ "XML output", "starting.html#xml_out", null ],
        [ "Man page output", "starting.html#man_out", null ]
      ] ],
      [ "Step 3: Documenting the sources", "starting.html#step3", null ]
    ] ],
    [ "Documenting the code", "docblocks.html", [
      [ "Special comment blocks", "docblocks.html#specialblock", [
        [ "Comment blocks for C-like languages (C/C++/C#/Objective-C/PHP/Java)", "docblocks.html#cppblock", [
          [ "Putting documentation after members", "docblocks.html#memberdoc", null ],
          [ "Examples", "docblocks.html#docexamples", null ],
          [ "Documentation at other places", "docblocks.html#structuralcommands", null ]
        ] ],
        [ "Comment blocks in Python", "docblocks.html#pythonblocks", null ],
        [ "Comment blocks in VHDL", "docblocks.html#vhdlblocks", null ],
        [ "Comment blocks in Fortran", "docblocks.html#fortranblocks", null ],
        [ "Comment blocks in Tcl", "docblocks.html#tclblocks", null ]
      ] ],
      [ "Anatomy of a comment block", "docblocks.html#docstructure", null ]
    ] ],
    [ "Markdown support", "markdown.html", [
      [ "Standard Markdown", "markdown.html#markdown_std", [
        [ "Paragraphs", "markdown.html#md_para", null ],
        [ "Headers", "markdown.html#md_headers", null ],
        [ "Block quotes", "markdown.html#md_blockquotes", null ],
        [ "Lists", "markdown.html#md_lists", null ],
        [ "Code Blocks", "markdown.html#md_codeblock", null ],
        [ "Horizontal Rulers", "markdown.html#md_rulers", null ],
        [ "Emphasis", "markdown.html#md_emphasis", null ],
        [ "code spans", "markdown.html#md_codespan", null ],
        [ "Links", "markdown.html#md_links", [
          [ "Inline Links", "markdown.html#md_inlinelinks", null ],
          [ "Reference Links", "markdown.html#md_reflinks", null ]
        ] ],
        [ "Images", "markdown.html#md_images", null ],
        [ "Automatic Linking", "markdown.html#md_autolink", null ]
      ] ],
      [ "Markdown Extensions", "markdown.html#markdown_extra", [
        [ "Table of Contents", "markdown.html#md_toc", null ],
        [ "Tables", "markdown.html#md_tables", null ],
        [ "Fenced Code Blocks", "markdown.html#md_fenced", null ],
        [ "Header Id Attributes", "markdown.html#md_header_id", null ]
      ] ],
      [ "Doxygen specifics", "markdown.html#markdown_dox", [
        [ "Including Markdown files as pages", "markdown.html#md_page_header", null ],
        [ "Treatment of HTML blocks", "markdown.html#md_html_blocks", null ],
        [ "Code Block Indentation", "markdown.html#mddox_code_blocks", null ],
        [ "Emphasis limits", "markdown.html#mddox_emph_spans", null ],
        [ "Code Spans Limits", "markdown.html#mddox_code_spans", null ],
        [ "Lists Extensions", "markdown.html#mddox_lists", null ],
        [ "Use of asterisks", "markdown.html#mddox_stars", null ],
        [ "Limits on markup scope", "markdown.html#mddox_limits", null ]
      ] ],
      [ "Debugging of problems", "markdown.html#markdown_debug", null ]
    ] ],
    [ "Grouping", "grouping.html", [
      [ "Modules", "grouping.html#modules", null ],
      [ "Member Groups", "grouping.html#memgroup", null ],
      [ "Subpaging", "grouping.html#subpaging", null ]
    ] ],
    [ "Including formulas", "formulas.html", null ],
    [ "Graphs and diagrams", "diagrams.html", null ],
    [ "Preprocessing", "preprocessing.html", null ],
    [ "Automatic link generation", "autolink.html", [
      [ "Links to web pages and mail addresses", "autolink.html#linkurl", null ],
      [ "Links to classes", "autolink.html#linkclass", null ],
      [ "Links to files", "autolink.html#linkfile", null ],
      [ "Links to functions", "autolink.html#linkfunc", null ],
      [ "Links to other members", "autolink.html#linkother", null ],
      [ "typedefs", "autolink.html#resolving", null ]
    ] ],
    [ "Output Formats", "output.html", null ],
    [ "Searching", "searching.html", null ],
    [ "Customizing the output", "customize.html", [
      [ "Minor Tweaks", "customize.html#minor_tweaks", [
        [ "Overall Color", "customize.html#minor_tweaks_colors", null ],
        [ "Navigation", "customize.html#minor_tweaks_treeview", null ],
        [ "Dynamic Content", "customize.html#minor_tweaks_dynsection", null ],
        [ "Header, Footer, and Stylesheet changes", "customize.html#minor_tweaks_header_css", null ]
      ] ],
      [ "Changing the layout of pages", "customize.html#layout", null ],
      [ "Using the XML output", "customize.html#xmlgenerator", null ]
    ] ],
    [ "Custom Commands", "custcmd.html", [
      [ "Simple aliases", "custcmd.html#custcmd_simple", null ],
      [ "Aliases with arguments", "custcmd.html#custcmd_complex", null ],
      [ "Nesting custom command", "custcmd.html#custcmd_nesting", null ]
    ] ],
    [ "Linking to external documentation", "external.html", null ],
    [ "Frequently Asked Questions", "faq.html", null ],
    [ "Troubleshooting", "trouble.html", null ],
    [ "Features", "features.html", null ],
    [ "Doxygen usage", "doxygen_usage.html", [
      [ "Fine-tuning the output", "doxygen_usage.html#doxygen_finetune", null ]
    ] ],
    [ "Doxywizard usage", "doxywizard_usage.html", null ],
    [ "Configuration", "config.html", [
      [ "Format", "config.html#config_format", null ],
      [ "Project related options", "config.html#config_project", null ],
      [ "Build related options", "config.html#config_build", null ],
      [ "Options related to warning and progress messages", "config.html#messages_input", null ],
      [ "Input related options", "config.html#config_input", null ],
      [ "Source browsing related options", "config.html#sourcebrowser_index", null ],
      [ "Alphabetical index options", "config.html#alphabetical_index", null ],
      [ "HTML related options", "config.html#html_output", null ],
      [ "LaTeX related options", "config.html#latex_output", null ],
      [ "RTF related options", "config.html#rtf_output", null ],
      [ "Man page related options", "config.html#man_output", null ],
      [ "XML related options", "config.html#xml_output", null ],
      [ "AUTOGEN_DEF related options", "config.html#autogen_output", null ],
      [ "PERLMOD related options", "config.html#perlmod_output", null ],
      [ "Preprocessor related options", "config.html#config_prepro", null ],
      [ "External reference options", "config.html#config_extref", null ],
      [ "Dot options", "config.html#config_dot", null ]
    ] ],
    [ "Special Commands", "commands.html", [
      [ "Introduction", "commands.html#cmd_intro", null ],
      [ "\\addtogroup <name> [(title)]", "commands.html#cmdaddtogroup", null ],
      [ "\\callgraph", "commands.html#cmdcallgraph", null ],
      [ "\\callergraph", "commands.html#cmdcallergraph", null ],
      [ "\\category <name> [<header-file>] [<header-name>]", "commands.html#cmdcategory", null ],
      [ "\\class <name> [<header-file>] [<header-name>]", "commands.html#cmdclass", null ],
      [ "\\def <name>", "commands.html#cmddef", null ],
      [ "\\defgroup <name> (group title)", "commands.html#cmddefgroup", null ],
      [ "\\dir [<path fragment>]", "commands.html#cmddir", null ],
      [ "\\enum <name>", "commands.html#cmdenum", null ],
      [ "\\example <file-name>", "commands.html#cmdexample", null ],
      [ "\\endinternal", "commands.html#cmdendinternal", null ],
      [ "\\extends <name>", "commands.html#cmdextends", null ],
      [ "\\file [<name>]", "commands.html#cmdfile", null ],
      [ "\\fn (function declaration)", "commands.html#cmdfn", null ],
      [ "\\headerfile <header-file> [<header-name>]", "commands.html#cmdheaderfile", null ],
      [ "\\hideinitializer", "commands.html#cmdhideinitializer", null ],
      [ "\\implements <name>", "commands.html#cmdimplements", null ],
      [ "\\ingroup (<groupname> [<groupname> <groupname>])", "commands.html#cmdingroup", null ],
      [ "\\interface <name> [<header-file>] [<header-name>]", "commands.html#cmdinterface", null ],
      [ "\\internal", "commands.html#cmdinternal", null ],
      [ "\\mainpage [(title)]", "commands.html#cmdmainpage", null ],
      [ "\\memberof <name>", "commands.html#cmdmemberof", null ],
      [ "\\name [(header)]", "commands.html#cmdname", null ],
      [ "\\namespace <name>", "commands.html#cmdnamespace", null ],
      [ "\\nosubgrouping", "commands.html#cmdnosubgrouping", null ],
      [ "\\overload [(function declaration)]", "commands.html#cmdoverload", null ],
      [ "\\package <name>", "commands.html#cmdpackage", null ],
      [ "\\page <name> (title)", "commands.html#cmdpage", null ],
      [ "\\private", "commands.html#cmdprivate", null ],
      [ "\\privatesection", "commands.html#cmdprivatesection", null ],
      [ "\\property (qualified property name)", "commands.html#cmdproperty", null ],
      [ "\\protected", "commands.html#cmdprotected", null ],
      [ "\\protectedsection", "commands.html#cmdprotectedsection", null ],
      [ "\\protocol <name> [<header-file>] [<header-name>]", "commands.html#cmdprotocol", null ],
      [ "\\public", "commands.html#cmdpublic", null ],
      [ "\\publicsection", "commands.html#cmdpublicsection", null ],
      [ "\\relates <name>", "commands.html#cmdrelates", null ],
      [ "\\related <name>", "commands.html#cmdrelated", null ],
      [ "\\relatesalso <name>", "commands.html#cmdrelatesalso", null ],
      [ "\\relatedalso <name>", "commands.html#cmdrelatedalso", null ],
      [ "\\showinitializer", "commands.html#cmdshowinitializer", null ],
      [ "\\struct <name> [<header-file>] [<header-name>]", "commands.html#cmdstruct", null ],
      [ "\\typedef (typedef declaration)", "commands.html#cmdtypedef", null ],
      [ "\\union <name> [<header-file>] [<header-name>]", "commands.html#cmdunion", null ],
      [ "\\var (variable declaration)", "commands.html#cmdvar", null ],
      [ "\\weakgroup <name> [(title)]", "commands.html#cmdweakgroup", null ],
      [ "\\attention { attention text }", "commands.html#cmdattention", null ],
      [ "\\author { list of authors }", "commands.html#cmdauthor", null ],
      [ "\\authors { list of authors }", "commands.html#cmdauthors", null ],
      [ "\\brief { brief description }", "commands.html#cmdbrief", null ],
      [ "\\bug { bug description }", "commands.html#cmdbug", null ],
      [ "\\cond [<section-label>]", "commands.html#cmdcond", null ],
      [ "\\copyright { copyright description }", "commands.html#cmdcopyright", null ],
      [ "\\date { date description }", "commands.html#cmddate", null ],
      [ "\\deprecated { description }", "commands.html#cmddeprecated", null ],
      [ "\\details { detailed description }", "commands.html#cmddetails", null ],
      [ "\\else", "commands.html#cmdelse", null ],
      [ "\\elseif <section-label>", "commands.html#cmdelseif", null ],
      [ "\\endcond", "commands.html#cmdendcond", null ],
      [ "\\endif", "commands.html#cmdendif", null ],
      [ "\\exception <exception-object> { exception description }", "commands.html#cmdexception", null ],
      [ "\\if <section-label>", "commands.html#cmdif", null ],
      [ "\\ifnot <section-label>", "commands.html#cmdifnot", null ],
      [ "\\invariant { description of invariant }", "commands.html#cmdinvariant", null ],
      [ "\\note { text }", "commands.html#cmdnote", null ],
      [ "\\par [(paragraph title)] { paragraph }", "commands.html#cmdpar", null ],
      [ "\\param [(dir)] <parameter-name> { parameter description }", "commands.html#cmdparam", null ],
      [ "\\tparam <template-parameter-name> { description }", "commands.html#cmdtparam", null ],
      [ "\\post { description of the postcondition }", "commands.html#cmdpost", null ],
      [ "\\pre { description of the precondition }", "commands.html#cmdpre", null ],
      [ "\\remark { remark text }", "commands.html#cmdremark", null ],
      [ "\\remarks { remark text }", "commands.html#cmdremarks", null ],
      [ "\\result { description of the result value }", "commands.html#cmdresult", null ],
      [ "\\return { description of the return value }", "commands.html#cmdreturn", null ],
      [ "\\returns { description of the return value }", "commands.html#cmdreturns", null ],
      [ "\\retval <return value> { description }", "commands.html#cmdretval", null ],
      [ "\\sa { references }", "commands.html#cmdsa", null ],
      [ "\\see { references }", "commands.html#cmdsee", null ],
      [ "\\short { short description }", "commands.html#cmdshort", null ],
      [ "\\since { text }", "commands.html#cmdsince", null ],
      [ "\\test { paragraph describing a test case }", "commands.html#cmdtest", null ],
      [ "\\throw <exception-object> { exception description }", "commands.html#cmdthrow", null ],
      [ "\\throws <exception-object> { exception description }", "commands.html#cmdthrows", null ],
      [ "\\todo { paragraph describing what is to be done }", "commands.html#cmdtodo", null ],
      [ "\\version { version number }", "commands.html#cmdversion", null ],
      [ "\\warning { warning message }", "commands.html#cmdwarning", null ],
      [ "\\xrefitem <key> \"(heading)\" \"(list title)\" { text }", "commands.html#cmdxrefitem", null ],
      [ "\\addindex (text)", "commands.html#cmdaddindex", null ],
      [ "\\anchor <word>", "commands.html#cmdanchor", null ],
      [ "\\cite <label>", "commands.html#cmdcite", null ],
      [ "\\endlink", "commands.html#cmdendlink", null ],
      [ "\\link <link-object>", "commands.html#cmdlink", null ],
      [ "\\ref <name> [\"(text)\"]", "commands.html#cmdref", null ],
      [ "\\subpage <name> [\"(text)\"]", "commands.html#cmdsubpage", null ],
      [ "\\tableofcontents", "commands.html#cmdtableofcontents", null ],
      [ "\\section <section-name> (section title)", "commands.html#cmdsection", null ],
      [ "\\subsection <subsection-name> (subsection title)", "commands.html#cmdsubsection", null ],
      [ "\\subsubsection <subsubsection-name> (subsubsection title)", "commands.html#cmdsubsubsection", null ],
      [ "\\paragraph <paragraph-name> (paragraph title)", "commands.html#cmdparagraph", null ],
      [ "\\dontinclude <file-name>", "commands.html#cmddontinclude", null ],
      [ "\\include <file-name>", "commands.html#cmdinclude", null ],
      [ "\\includelineno <file-name>", "commands.html#cmdincludelineno", null ],
      [ "\\line ( pattern )", "commands.html#cmdline", null ],
      [ "\\skip ( pattern )", "commands.html#cmdskip", null ],
      [ "\\skipline ( pattern )", "commands.html#cmdskipline", null ],
      [ "\\snippet <file-name> ( block_id )", "commands.html#cmdsnippet", null ],
      [ "\\until ( pattern )", "commands.html#cmduntil", null ],
      [ "\\verbinclude <file-name>", "commands.html#cmdverbinclude", null ],
      [ "\\htmlinclude <file-name>", "commands.html#cmdhtmlinclude", null ],
      [ "\\a <word>", "commands.html#cmda", null ],
      [ "\\arg { item-description }", "commands.html#cmdarg", null ],
      [ "\\b <word>", "commands.html#cmdb", null ],
      [ "\\c <word>", "commands.html#cmdc", null ],
      [ "\\code [ '{'<word>'}']", "commands.html#cmdcode", null ],
      [ "\\copydoc <link-object>", "commands.html#cmdcopydoc", null ],
      [ "\\copybrief <link-object>", "commands.html#cmdcopybrief", null ],
      [ "\\copydetails <link-object>", "commands.html#cmdcopydetails", null ],
      [ "\\dot", "commands.html#cmddot", null ],
      [ "\\msc", "commands.html#cmdmsc", null ],
      [ "\\dotfile <file> [\"caption\"]", "commands.html#cmddotfile", null ],
      [ "\\mscfile <file> [\"caption\"]", "commands.html#cmdmscfile", null ],
      [ "\\e <word>", "commands.html#cmde", null ],
      [ "\\em <word>", "commands.html#cmdem", null ],
      [ "\\endcode", "commands.html#cmdendcode", null ],
      [ "\\enddot", "commands.html#cmdenddot", null ],
      [ "\\endmsc", "commands.html#cmdendmsc", null ],
      [ "\\endhtmlonly", "commands.html#cmdendhtmlonly", null ],
      [ "\\endlatexonly", "commands.html#cmdendlatexonly", null ],
      [ "\\endmanonly", "commands.html#cmdendmanonly", null ],
      [ "\\endrtfonly", "commands.html#cmdendrtfonly", null ],
      [ "\\endverbatim", "commands.html#cmdendverbatim", null ],
      [ "\\endxmlonly", "commands.html#cmdendxmlonly", null ],
      [ "\\f$", "commands.html#cmdfdollar", null ],
      [ "\\f[", "commands.html#cmdfbropen", null ],
      [ "\\f]", "commands.html#cmdfbrclose", null ],
      [ "\\f{environment}{", "commands.html#cmdfcurlyopen", null ],
      [ "\\f}", "commands.html#cmdfcurlyclose", null ],
      [ "\\htmlonly", "commands.html#cmdhtmlonly", null ],
      [ "\\image <format> <file> [\"caption\"] [<sizeindication>=<size>]", "commands.html#cmdimage", null ],
      [ "\\latexonly", "commands.html#cmdlatexonly", null ],
      [ "\\manonly", "commands.html#cmdmanonly", null ],
      [ "\\li { item-description }", "commands.html#cmdli", null ],
      [ "\\n", "commands.html#cmdn", null ],
      [ "\\p <word>", "commands.html#cmdp", null ],
      [ "\\rtfonly", "commands.html#cmdrtfonly", null ],
      [ "\\verbatim", "commands.html#cmdverbatim", null ],
      [ "\\xmlonly", "commands.html#cmdxmlonly", null ],
      [ "\\\\", "commands.html#cmdbackslash", null ],
      [ "\\@", "commands.html#cmdat", null ],
      [ "\\~[LanguageId]", "commands.html#cmdtilde", null ],
      [ "\\&", "commands.html#cmdamp", null ],
      [ "\\$", "commands.html#cmddollar", null ],
      [ "\\#", "commands.html#cmdhash", null ],
      [ "\\<", "commands.html#cmdlt", null ],
      [ "\\>", "commands.html#cmdgt", null ],
      [ "\\%", "commands.html#cmdperc", null ],
      [ "\\\"", "commands.html#cmdquot", null ],
      [ "\\.", "commands.html#cmdchardot", null ],
      [ "\\::", "commands.html#cmddcolon", null ]
    ] ],
    [ "HTML Commands", "htmlcmds.html", null ],
    [ "XML Commands", "xmlcmds.html", null ],
    [ "Internationalization", "langhowto.html", null ],
    [ "Perl Module Output", "perlmod.html", [
      [ "Usage", "perlmod.html#using_perlmod_fmt", null ],
      [ "Using the LaTeX generator.", "perlmod.html#perlmod_latex", [
        [ "Creation of PDF and DVI output", "perlmod.html#pm_pdf_gen", null ]
      ] ],
      [ "Documentation format.", "perlmod.html#doxydocs_format", null ],
      [ "Data structure", "perlmod.html#doxymodel_format", null ]
    ] ],
    [ "Perl Module Tree Nodes", "perlmod_tree.html", null ],
    [ "Doxygen's Internals", "arch.html", null ]
  ] ]
];

var NAVTREEINDEX =
[
"arch.html",
"markdown.html#md_page_header",
];

var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode) {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  imgNode.width = 16;
  imgNode.height = 22;
  if (level==0 && node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast) {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        } else {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  } else {
    domNode.appendChild(imgNode);
  }
  if (level==0) {
    if (node.isLast) {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    } else {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2pnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  } else {
    if (node.isLast) {
      imgNode.src = node.relpath+"ftv2blank.png";
    } else {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : '#';
      a.onclick = function(){
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var pos, anchor = $(aname), docContent = $('#doc-content');
        if (anchor.parent().attr('class')=='memItemLeft') {
          pos = anchor.parent().position().top;
        } else if (anchor.position()) {
          pos = anchor.position().top;
        }
        if (pos) {
          var dist = Math.abs(Math.min(
                     pos-docContent.offset().top,
                     docContent[0].scrollHeight-
                     docContent.height()-docContent.scrollTop()));
          docContent.animate({
            scrollTop: pos + docContent.scrollTop() - docContent.offset().top
          },Math.max(50,Math.min(500,dist)),function(){
            window.location.replace(aname);
          });
        }
      };
    } else {
      a.href = url;
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var anchor = $($(location).attr('hash'));
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
}

function selectAndHighlight(n)
{
  var a;
  if ($(location).attr('hash')) {
    var link=stripPath($(location).attr('pathname'))+':'+
      $(location).attr('hash').substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  showRoot();
}

function showNode(o, node, index)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index); // retry with child node expanded
          },true);
        } else {
          var rootBase = o.toroot.replace(/\..+$/, '');
          if (rootBase=="index" || rootBase=="pages") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(n);
        }
      }
    }
  } else {
    selectAndHighlight();
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = nti ? nti : navTreeSubIndices[subIndex][root];
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0);
  }
}

function navTo(o,root,hash,relpath)
{
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     }
  })

  $(window).load(showRoot);
}

