.TH Xvnc 1 "28 February 2003" "RealVNC Ltd" "Virtual Network Computing"
.SH NAME
Xvnc \- the X VNC server 
.SH SYNOPSIS
.B Xvnc
.RI [ options ] 
.RI : display#
.SH DESCRIPTION
.B Xvnc
is the X VNC (Virtual Network Computing) server.  It is based on a standard X
server, but it has a "virtual" screen rather than a physical one.  X
applications display themselves on it as if it were a normal X display, but
they can only be accessed via a VNC viewer - see \fBvncviewer\fP(1).

So Xvnc is really two servers in one. To the applications it is an X server,
and to the remote VNC users it is a VNC server. By convention we have arranged
that the VNC server display number will be the same as the X server display
number, which means you can use eg. snoopy:2 to refer to display 2 on machine
"snoopy" in both the X world and the VNC world.

The best way of starting \fBXvnc\fP is via the \fBvncserver\fP script.  This
sets up the environment appropriately and runs some X applications to get you
going.  See the manual page for \fBvncserver\fP(1) for more information.

.SH OPTIONS
.B Xvnc
takes lots of options - running \fBXvnc -help\fP gives a list.  Many of these
are standard X server options, which are described in the \fBXserver\fP(1)
manual page.

.TP
.B \-geometry \fIwidth\fPx\fIheight\fP
Specify the size of the desktop to be created. Default is 640x480.

.TP
.B \-depth \fIdepth\fP
Specify the pixel depth in bits of the desktop to be created. Default is 8,
other possible values are 15, 16 and 24 - anything else is likely to cause
strange behaviour by applications.

.TP
.B \-pixelformat \fIformat\fP
Specify pixel format for server to use (BGRnnn or RGBnnn).  The default for
depth 8 is BGR233 (meaning the most significant two bits represent blue, the
next three green, and the least significant three represent red), the default
for depth 16 is RGB565 and for depth 24 is RGB888.

.TP
.B \-cc 3
As an alternative to the default TrueColor visual, this allows you to run an
Xvnc server with a PseudoColor visual (i.e. one which uses a colour map or
palette), which can be useful for running some old X applications which only
work on such a display.  Note that viewing such a desktop can be painful
because it usually results in a full-screen redraw every time an entry in the
colour map changes.  Values other than 3 (PseudoColor) and 4 (TrueColor) for
the \-cc option may result in strange behaviour, and PseudoColor desktops must
be 8 bits deep.

.TP
.B \-rfbport \fIport\fP
Specifies the TCP port on which Xvnc listens for connections from viewers (the
protocol used in VNC is called RFB - "remote framebuffer").  The default is
5900 plus the display number.

.TP
.B \-rfbwait \fItime\fP
Time in milliseconds to wait for a viewer which is blocking Xvnc.  This is
necessary because Xvnc is single-threaded and sometimes blocks until the viewer
has finished sending or receiving a message - note that this does not mean an
update will be aborted after this time.  Default is 20000 (20 seconds).

.TP
.B \-nocursor
Don't draw a cursor.  This can be useful when debugging a viewer to make the
updates drawn more predictable.

.TP
.B \-rfbauth \fIpasswd-file\fP
Specifies the file containing the password used to authenticate viewers.  The
file is accessed each time a connection comes in, so it can be changed on the
fly via \fBvncpasswd\fP(1).

.TP
.B \-httpd \fIdirectory\fP
Run a mini-HTTP server which serves files from the given directory.  Normally
the directory will contain the classes for the Java viewer.  In addition, files
with a .vnc extension will have certain substitutions made so that a single
installation of the Java VNC viewer can be served by separate instances of
Xvnc.

.TP
.B \-httpport \fIport\fP
Specifies the port on which the mini-HTTP server runs.  Default is 5800 plus
the display number.

.TP
.B \-deferupdate \fItime\fP
Xvnc uses a "deferred update" mechanism which enhances performance in many
cases. After any change to the framebuffer, Xvnc waits for this number of
milliseconds (default 40) before sending an update to any waiting clients. This
means that more changes tend to get coalesced together in a single
update. Setting it to 0 results in the same behaviour as earlier versions of
Xvnc, where the first change to the framebuffer causes an immediate update to
any waiting clients.

.TP
.B \-economictranslate
The server normally uses a lookup table for translating pixel values when the
viewer requests a different format from the native one used by the server.
This can use up to 256Kbytes per connected viewer, so if you have many viewers
you may wish to specify this option which will save memory at the expense of a
little bit of speed. Only relevant for 16-bit-deep desktops.

.TP
.B \-maxrects \fInum\fP
Sets the maximum number of rectangles Xvnc will send in one update.  If an
update would consist of more than this many rectangles, then an update of a
single bounding rectangle is sent instead.  This makes sense because sending a
large number of small rectangles is less efficient than sending one large
rectangle, even when this means updating pixels which haven't actually changed.
The default is 50.

.TP
.B \-desktop \fIdesktop-name\fP
Each desktop has a name which may be displayed by the viewer. It defaults to
"x11".

.TP
.B \-alwaysshared
Always treat new clients as shared (i.e. ignore client's shared flag). 

.TP
.B \-nevershared
Never treat new clients as shared (i.e. ignore client's shared flag). 

.TP
.B \-dontdisconnect
Don't disconnect existing clients when a new "non-shared" connection comes
in. Instead the new connection is refused. New "shared" connections are still
allowed in the normal way.

.TP
.B \-localhost
Only allow connections from the same machine. Useful if you use SSH and want to
stop non-SSH connections from any other hosts. See the guide to using VNC with
SSH on the web site.

.TP
.B \-inetd 
This significantly changes Xvnc's behaviour so that it can be launched from
inetd. Instead of listening for TCP connections it uses its standard input and
standard output as a connection to the VNC viewer. See the information on the
extras page on the web site for details.

.SH SEE ALSO
.BR vncconnect (1),
.BR vncpasswd (1),
.BR vncserver (1),
.BR vncviewer (1),
.BR Xserver (1)
.br
http://www.realvnc.com

.SH AUTHOR
Tristan Richardson, RealVNC Ltd.

VNC was originally developed by the RealVNC team while at Olivetti Research Ltd
/ AT&T Laboratories Cambridge.  It is now being maintained by RealVNC Ltd.  See
http://www.realvnc.com for details.
