/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SecureKey;
import com.sun.net.ssl.internal.ssl.SessionId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.CertificateException;

public class SSLSessionImpl
implements SSLSession {
    public static final SSLSessionImpl a = new SSLSessionImpl();
    public static final byte b = 0;
    public SessionId c;
    public X509Certificate[] d;
    public byte e;
    public CipherSpec f;
    public byte[] g;
    public final long h = System.currentTimeMillis();
    public long i = 0L;
    public String j;
    public int k;
    public SSLSessionContextImpl l;
    public int m;
    public boolean n;
    public boolean o;
    public static int p = 0;
    public static boolean q = true;
    public static final Debug r = Debug.getInstance("ssl");
    public Hashtable s = new Hashtable();

    public SSLSessionImpl() {
        this(new CipherSpec(), new SessionId(false), null, -1);
    }

    public SSLSessionImpl(CipherSpec cipherSpec, SessionId sessionId, String string, int n2) {
        this.c = sessionId;
        this.d = null;
        this.e = 0;
        this.f = cipherSpec;
        this.g = null;
        this.j = string;
        this.k = n2;
        this.m = ++p;
        if (r != null && Debug.isOn("session")) {
            System.out.println("%% Created:  " + this);
        }
    }

    public SSLSessionImpl(CipherSpec cipherSpec, String string, int n2) {
        this(cipherSpec, new SessionId(q), string, n2);
    }

    public boolean a(SessionId sessionId) {
        return this.c != null && this.c.equals(sessionId);
    }

    public void finalize() {
        String[] stringArray = this.getValueNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.removeValue(stringArray[n2]);
            ++n2;
        }
    }

    public X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.d != null) {
            return (X509Certificate[])this.d.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    public CipherSpec a() {
        return this.f;
    }

    public String getCipherSuite() {
        return this.f.toString();
    }

    public byte b() {
        return this.e;
    }

    public long getCreationTime() {
        return this.h;
    }

    public byte[] getId() {
        return this.c.a();
    }

    public long getLastAccessedTime() {
        return this.i != 0L ? this.i : this.h;
    }

    public byte[] c() {
        return this.g;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.j);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.d == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        javax.security.cert.X509Certificate[] x509CertificateArray = new javax.security.cert.X509Certificate[this.d.length];
        int n2 = 0;
        while (n2 < this.d.length) {
            byte[] byArray = null;
            try {
                byArray = this.d[n2].getEncoded();
                x509CertificateArray[n2] = javax.security.cert.X509Certificate.getInstance(byArray);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
            ++n2;
        }
        return x509CertificateArray;
    }

    public String getPeerHost() {
        return this.j;
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return this.l;
    }

    public SessionId d() {
        return this.c;
    }

    public Object getValue(String string) {
        SecureKey secureKey = new SecureKey(string);
        return this.s.get(secureKey);
    }

    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = SecureKey.c();
        Enumeration enumeration = this.s.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = (SecureKey)enumeration.nextElement();
            if (!object.equals(secureKey.b())) continue;
            vector.addElement(secureKey.a());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void invalidate() {
        if (this == a) {
            return;
        }
        this.o = true;
        if (r != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.l != null) {
            this.l.a(this.c);
            this.l = null;
        }
    }

    public boolean e() {
        return this.c != null && this.c.b() != 0 && !this.o;
    }

    public boolean f() {
        return this.n;
    }

    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.s.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public void removeValue(String string) {
        SecureKey secureKey = new SecureKey(string);
        Object v2 = this.s.remove(secureKey);
        if (v2 instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)v2).valueUnbound(sSLSessionBindingEvent);
        }
    }

    public void a(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.l == null) {
            this.l = sSLSessionContextImpl;
        }
    }

    public void a(long l2) {
        this.i = l2;
    }

    public void a(byte[] byArray) {
        if (this.g == null) {
            this.g = byArray;
        }
    }

    public void a(X509Certificate[] x509CertificateArray) {
        if (this.d == null) {
            this.d = x509CertificateArray;
        }
    }

    public void a(boolean bl2) {
        this.n = bl2;
    }

    public String toString() {
        return "[Session-" + this.m + ", " + this.getCipherSuite() + "]";
    }
}

