/* Copyright (c) 2023 The Khronos Group Inc.
 * SPDX-FileCopyrightText: Copyright (c) 2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Vikram Kushwaha <vkushwaha@nvidia.com>
 */

#define COMPRESSED_SIZE1 3812
#define COMPRESSED_SIZE2 3832
#define DECOMPRESSED_SIZE 12182
#define DECOMPRESSED_SIZE_ALIGNED 12192

static uint8_t compressedData1[COMPRESSED_SIZE1] = {
    0xB5, 0x9A, 0x7B, 0x3F, 0xDD, 0xAD, 0xDA, 0xA6, 0xC5, 0x7D, 0x71, 0xAF, 0x03, 0xA9, 0x9C, 0xEB, 0x5B, 0xAB, 0x97, 0xDA, 0x7C,
    0x07, 0x79, 0x68, 0x54, 0xA7, 0xEC, 0xF6, 0x7B, 0x00, 0xCE, 0x7D, 0x94, 0x71, 0xA4, 0xFF, 0x83, 0xB7, 0xDD, 0xDA, 0xB3, 0xEF,
    0x96, 0x72, 0x7C, 0x01, 0x7A, 0xB8, 0x48, 0x70, 0x2B, 0x5B, 0xBE, 0x02, 0xB6, 0x63, 0x88, 0x66, 0x9E, 0x86, 0xC6, 0x01, 0x5B,
    0xA9, 0xDB, 0xD8, 0xD7, 0x3C, 0x19, 0x0F, 0xAF, 0xCB, 0x51, 0x1F, 0xC3, 0xBD, 0xD1, 0x94, 0x2C, 0x5F, 0x60, 0xD7, 0xF9, 0x65,
    0xA0, 0x86, 0x52, 0x1E, 0x69, 0xA5, 0xBA, 0x96, 0x80, 0x96, 0xA7, 0xB2, 0x30, 0xF3, 0xF0, 0x9C, 0x79, 0x7C, 0xD6, 0x7F, 0x9B,
    0x1A, 0xDB, 0xB2, 0xA9, 0xC3, 0x30, 0xA7, 0x87, 0xFA, 0xA7, 0xF9, 0xA8, 0xDA, 0xD2, 0x5A, 0xAB, 0x7F, 0x5D, 0xD2, 0xF8, 0xEA,
    0x18, 0x86, 0xFE, 0xFF, 0x91, 0xE7, 0xD6, 0x6E, 0xBA, 0xEB, 0xD3, 0xDE, 0x06, 0xD9, 0xB1, 0xDE, 0xCD, 0x86, 0xE4, 0x3F, 0x9B,
    0xF8, 0x47, 0xA9, 0x7B, 0x6E, 0xDD, 0x50, 0xF7, 0x2C, 0x18, 0x6E, 0x6B, 0x4A, 0x3E, 0x95, 0xA1, 0x3E, 0x70, 0x64, 0x4C, 0x95,
    0xFC, 0x3A, 0xB7, 0xA1, 0xD7, 0x34, 0x94, 0x52, 0x7B, 0x1C, 0x6B, 0xBA, 0xDC, 0xF3, 0x22, 0x4B, 0x32, 0x6F, 0x47, 0x9E, 0xC7,
    0x70, 0xAB, 0xBE, 0xA4, 0x41, 0x96, 0x99, 0x5D, 0x56, 0x9D, 0x77, 0x6D, 0x6F, 0xAD, 0xE4, 0xED, 0x79, 0x11, 0x0F, 0xD6, 0x5B,
    0xB9, 0x72, 0x79, 0xFD, 0x7B, 0x5C, 0xE9, 0xB6, 0xBE, 0xA4, 0xE6, 0xDD, 0xDD, 0xDD, 0xD6, 0x6C, 0xDF, 0x94, 0xCA, 0xDF, 0xB4,
    0x0F, 0x1F, 0x6A, 0xD4, 0x21, 0x61, 0xF8, 0xEB, 0x4D, 0xB5, 0xDE, 0xAA, 0x3C, 0x52, 0x79, 0x2A, 0x12, 0x7A, 0x4F, 0xC3, 0xA8,
    0xC9, 0x16, 0xFB, 0x8F, 0xA9, 0xAC, 0x8B, 0xAC, 0xC3, 0x6A, 0x8F, 0x49, 0x23, 0x8E, 0x7A, 0xE1, 0xE2, 0x73, 0x6A, 0x12, 0xF7,
    0x9C, 0x37, 0xD9, 0x64, 0x59, 0xF7, 0x63, 0xB2, 0xA6, 0x92, 0xDE, 0x75, 0x1D, 0xA6, 0xF1, 0xB6, 0x45, 0x2C, 0x99, 0x58, 0x34,
    0x4A, 0x11, 0xE7, 0x77, 0x79, 0xBA, 0x3F, 0x8B, 0x25, 0x7B, 0xFC, 0xE7, 0xE5, 0x25, 0x9C, 0x9F, 0x07, 0x7F, 0xEB, 0xD6, 0x41,
    0xD6, 0x6D, 0xEA, 0xBD, 0x88, 0xA7, 0x43, 0x2E, 0x4A, 0xCB, 0x19, 0x7F, 0xD0, 0xF7, 0x22, 0xC1, 0x3B, 0xED, 0xD2, 0xEB, 0xF6,
    0xB9, 0x9A, 0x25, 0x00, 0x8D, 0x0F, 0xF3, 0x5F, 0x9E, 0x96, 0x34, 0x6F, 0xAE, 0x99, 0x8E, 0x22, 0xFB, 0x67, 0xCA, 0x64, 0xB7,
    0xE3, 0xA5, 0x60, 0x8B, 0xA5, 0xEE, 0x91, 0x4D, 0x7E, 0xBE, 0xA5, 0xD8, 0x34, 0xDD, 0x9E, 0xAB, 0x0D, 0xAD, 0xFC, 0xB8, 0x2F,
    0x01, 0x92, 0x1C, 0x66, 0x4F, 0x1E, 0x7F, 0x67, 0x31, 0xDB, 0x7F, 0xFC, 0xA9, 0xAD, 0x21, 0x25, 0x9A, 0xA6, 0x0D, 0x31, 0x12,
    0xF8, 0x06, 0x5B, 0x92, 0x9B, 0x92, 0xBA, 0x7F, 0xBA, 0x67, 0x9F, 0xE5, 0x0A, 0x5C, 0xA1, 0xFC, 0x7E, 0xE6, 0xE7, 0x63, 0xE2,
    0x3D, 0xB9, 0xDF, 0xD2, 0x2A, 0x19, 0x14, 0x48, 0xDB, 0xFC, 0x8B, 0xE5, 0xEB, 0x3F, 0x6D, 0x39, 0xAD, 0x3F, 0x4B, 0x16, 0xE6,
    0xF7, 0xD7, 0x92, 0x7B, 0x39, 0xAE, 0xD6, 0xD0, 0x22, 0xB3, 0xA4, 0x22, 0x26, 0x49, 0x44, 0xD6, 0x96, 0xF6, 0xB3, 0x24, 0xD0,
    0x3A, 0xD3, 0x43, 0x7A, 0x6D, 0xFE, 0xA5, 0x08, 0x6A, 0x4F, 0x16, 0xD6, 0xA4, 0x5E, 0xF9, 0xAC, 0x35, 0xB5, 0xAE, 0x0A, 0xF0,
    0xB2, 0x79, 0x14, 0xB9, 0xDA, 0xF7, 0x82, 0x5F, 0xDB, 0x04, 0x6E, 0xBB, 0xF9, 0x50, 0x52, 0x3C, 0x2B, 0x88, 0x06, 0x44, 0x12,
    0x25, 0x8D, 0xE5, 0x6A, 0x24, 0x28, 0xF7, 0x17, 0xBC, 0xC7, 0xF7, 0xF6, 0xF7, 0xA1, 0x8F, 0x89, 0xB7, 0xE5, 0x82, 0xC0, 0x52,
    0x0C, 0xE3, 0x4D, 0x80, 0xFE, 0x63, 0xBD, 0xB8, 0x22, 0xAB, 0xA6, 0xEC, 0x30, 0x39, 0xEA, 0x8C, 0x91, 0x79, 0x59, 0x4F, 0x04,
    0xB4, 0x41, 0x22, 0xB4, 0x2C, 0x0E, 0x5A, 0x5F, 0x71, 0x34, 0xE4, 0xB6, 0x53, 0x08, 0x25, 0xBF, 0x11, 0xF8, 0xEF, 0x9E, 0x2B,
    0x0A, 0x87, 0x33, 0x91, 0x33, 0x4B, 0xCC, 0xA6, 0x06, 0x1B, 0xD3, 0xEA, 0x1C, 0xC8, 0x4C, 0x35, 0xEF, 0x92, 0xA5, 0xA2, 0xBC,
    0x5B, 0xF3, 0xCE, 0xB5, 0xA8, 0x1A, 0x6D, 0x00, 0x2E, 0x3E, 0xCE, 0x5A, 0x35, 0x95, 0x6D, 0x3C, 0x83, 0xD7, 0x6D, 0xBB, 0xCC,
    0x1A, 0x07, 0x21, 0x79, 0xD3, 0x12, 0x2C, 0x67, 0xD5, 0x2A, 0xDA, 0x57, 0x62, 0x22, 0x30, 0x0B, 0x3B, 0x3F, 0xAF, 0x1C, 0x37,
    0xC9, 0x79, 0xA3, 0xED, 0xF8, 0xB0, 0x06, 0x5D, 0x91, 0x08, 0x47, 0xFA, 0x86, 0x3C, 0xD9, 0xCE, 0xCE, 0x9A, 0x8D, 0xFC, 0x2A,
    0xD2, 0xCE, 0xD2, 0x1A, 0xC0, 0xB7, 0x5C, 0xC5, 0x2B, 0x2F, 0xC7, 0x2F, 0xF2, 0x53, 0x13, 0x78, 0x6C, 0xC7, 0x1D, 0xFC, 0xDE,
    0x60, 0x20, 0x8F, 0x4A, 0x65, 0x1C, 0xE5, 0x15, 0x5F, 0xFD, 0xDB, 0x1A, 0xB4, 0xC4, 0xC9, 0x73, 0x73, 0xD0, 0xC5, 0xFA, 0xBC,
    0x36, 0x2B, 0x80, 0x32, 0xA6, 0x14, 0x54, 0xDD, 0xBC, 0x0D, 0xC3, 0x71, 0xD9, 0xEF, 0x04, 0x5E, 0x76, 0x63, 0x95, 0x39, 0x43,
    0x99, 0x3B, 0x69, 0xD5, 0x49, 0xCB, 0x07, 0x62, 0x4F, 0xCD, 0xB1, 0xF6, 0x78, 0xDB, 0x49, 0x5A, 0x90, 0x96, 0xAF, 0xCF, 0xC7,
    0xA8, 0x4D, 0x83, 0xDA, 0x5D, 0x01, 0x38, 0x29, 0x86, 0xC9, 0xDD, 0x84, 0x91, 0x14, 0x81, 0xF6, 0x08, 0x24, 0x9B, 0xFB, 0x1F,
    0xB6, 0xDD, 0xF6, 0x8E, 0x43, 0x9A, 0x92, 0xB8, 0x35, 0x34, 0xDB, 0x22, 0xCA, 0x95, 0xE9, 0xB6, 0x51, 0x89, 0xEB, 0xAC, 0x77,
    0x23, 0x80, 0xD2, 0x7C, 0x53, 0xE7, 0x3D, 0x13, 0xB3, 0xBA, 0xB0, 0x43, 0xD2, 0x4D, 0x6F, 0xF3, 0xA7, 0x34, 0xB4, 0x2E, 0xF6,
    0xD7, 0x59, 0xC4, 0x12, 0xAF, 0x09, 0x56, 0x65, 0xC1, 0xA9, 0x0C, 0x01, 0x94, 0x20, 0x4A, 0x51, 0xC1, 0x5C, 0x0D, 0x43, 0xB9,
    0x9F, 0x35, 0xCD, 0x02, 0xAD, 0x85, 0xFE, 0x49, 0xE7, 0xE1, 0x63, 0x01, 0xFF, 0x4F, 0x38, 0x7F, 0x03, 0xDE, 0xE0, 0xA4, 0xC2,
    0x77, 0xB5, 0x56, 0xA3, 0xE1, 0x3D, 0x15, 0x6D, 0x66, 0x65, 0x8B, 0x7A, 0x64, 0xF1, 0xEC, 0x6A, 0x4D, 0x8D, 0x66, 0x3A, 0xDF,
    0xD0, 0xA0, 0xF6, 0xE2, 0x1F, 0x9D, 0x69, 0x78, 0x30, 0x7D, 0x10, 0xE0, 0x77, 0x21, 0xE1, 0x0B, 0x19, 0x9E, 0xCF, 0x23, 0xCF,
    0xD1, 0x68, 0xC4, 0x0E, 0x37, 0x7C, 0xFA, 0x7D, 0x6C, 0xF7, 0x81, 0xB8, 0xC2, 0x40, 0xB1, 0xC7, 0xAA, 0x91, 0x12, 0x4D, 0xB0,
    0x14, 0x1E, 0x0F, 0x31, 0xFD, 0xF0, 0xAC, 0x16, 0x84, 0x81, 0xC1, 0x3E, 0x07, 0x76, 0xDD, 0x59, 0x2D, 0x87, 0x82, 0xF1, 0x60,
    0xB6, 0x33, 0x50, 0x3B, 0x01, 0xBA, 0xA6, 0x5C, 0x3E, 0xBB, 0x7C, 0x53, 0xC0, 0xA2, 0xD5, 0x7D, 0x8C, 0xAE, 0xD3, 0xED, 0x7B,
    0x59, 0x87, 0x4E, 0x3A, 0x94, 0x71, 0x00, 0x1A, 0x52, 0xDC, 0x8E, 0x60, 0x59, 0xEF, 0x89, 0x74, 0xE9, 0xAF, 0xEE, 0x1E, 0xD4,
    0x34, 0xD6, 0x30, 0x05, 0x8D, 0x98, 0x97, 0x34, 0x1D, 0x06, 0x34, 0xDE, 0x94, 0xAA, 0xAF, 0xD3, 0xE9, 0x7A, 0x9B, 0x49, 0x80,
    0x51, 0xA9, 0x11, 0x2E, 0xBD, 0x7B, 0xFE, 0xAD, 0x5E, 0x92, 0xD8, 0x08, 0x59, 0x7F, 0x59, 0xAF, 0x21, 0x92, 0xAE, 0x71, 0xB6,
    0x28, 0xAF, 0xA0, 0x26, 0xDB, 0x2E, 0x18, 0x9C, 0x69, 0x83, 0xD5, 0x84, 0xF8, 0x06, 0xE4, 0xE8, 0x17, 0xCE, 0xDF, 0xEB, 0xC4,
    0x01, 0x8A, 0x3D, 0xF9, 0x9F, 0xD2, 0xF6, 0x82, 0xB9, 0x5A, 0xFD, 0x07, 0x9C, 0x21, 0x4B, 0xAD, 0xBB, 0x8A, 0x21, 0x10, 0x5A,
    0x9F, 0xC2, 0x4F, 0x19, 0x1E, 0x97, 0x89, 0x56, 0xF4, 0xB7, 0x50, 0x58, 0x28, 0x0B, 0x69, 0x27, 0x11, 0x92, 0xE4, 0xDC, 0x96,
    0xC0, 0x8D, 0xEC, 0xCA, 0x06, 0x1A, 0xBD, 0x28, 0xC0, 0xCD, 0x16, 0x9E, 0x53, 0xEA, 0x79, 0x14, 0x69, 0xA0, 0x3C, 0x98, 0x2B,
    0x27, 0x1A, 0x0F, 0x23, 0x31, 0xAB, 0x95, 0xA6, 0x8B, 0x5E, 0x83, 0x2A, 0x4E, 0x27, 0x3E, 0x73, 0xB3, 0x91, 0x86, 0xD7, 0xDC,
    0x7B, 0xC8, 0x1E, 0x10, 0xA3, 0x9E, 0x9F, 0x8B, 0xF1, 0x82, 0xE5, 0x5D, 0x53, 0xF0, 0xCD, 0x5B, 0x0B, 0xC3, 0x64, 0xE4, 0x4E,
    0x76, 0xF4, 0x74, 0x3D, 0x59, 0x9D, 0x05, 0xA3, 0x05, 0xCA, 0x99, 0x4C, 0x41, 0xB7, 0x1A, 0x1A, 0x80, 0xB4, 0x42, 0x4B, 0x92,
    0x60, 0x29, 0x1A, 0x96, 0x68, 0x60, 0x4E, 0x63, 0x90, 0xDD, 0xEB, 0x68, 0xD9, 0x52, 0x82, 0xB3, 0x16, 0x9B, 0x62, 0x84, 0x48,
    0xEA, 0x84, 0x2F, 0x8D, 0x54, 0xAE, 0x28, 0xEA, 0xDE, 0x57, 0x47, 0xAF, 0x14, 0x28, 0xBE, 0x53, 0xD6, 0xD0, 0xD1, 0x3A, 0x77,
    0x4A, 0x27, 0x5D, 0xC1, 0x76, 0x90, 0x55, 0xAA, 0x08, 0x11, 0x31, 0x9B, 0x65, 0x63, 0x7A, 0x12, 0x25, 0x6A, 0x8B, 0x0C, 0xA6,
    0x7C, 0x95, 0xE7, 0x2A, 0x88, 0xCB, 0xF2, 0x41, 0x67, 0x6B, 0x6D, 0xA2, 0x95, 0x8C, 0x4E, 0x6C, 0xA0, 0x21, 0xEC, 0x09, 0x0F,
    0x1D, 0x55, 0xA1, 0x9A, 0x43, 0x58, 0xA1, 0x73, 0x73, 0x38, 0x93, 0x73, 0x4D, 0xCF, 0xC0, 0xE6, 0x02, 0xB3, 0x99, 0xA2, 0x0D,
    0x81, 0x50, 0x36, 0xB2, 0xEB, 0x9A, 0xCE, 0x7F, 0x45, 0x33, 0xFF, 0xB1, 0x4B, 0x58, 0x10, 0xD1, 0xCB, 0x4B, 0x80, 0xF4, 0xDE,
    0x25, 0x2A, 0xD4, 0xBA, 0x95, 0x76, 0xDC, 0x16, 0xDA, 0xB5, 0x1A, 0x22, 0xC7, 0xBE, 0xEB, 0x97, 0xD9, 0xCA, 0x03, 0x6E, 0x37,
    0x4A, 0x66, 0x63, 0x73, 0xD8, 0x09, 0x91, 0xFF, 0x1F, 0xD9, 0x30, 0x41, 0xA1, 0xF7, 0x66, 0xF2, 0x7F, 0xEF, 0xDD, 0xFA, 0xFD,
    0xAC, 0xFC, 0x27, 0x33, 0xAB, 0xAD, 0x7D, 0x33, 0x9C, 0xD7, 0x91, 0xC5, 0x9B, 0x96, 0xF0, 0x60, 0xC9, 0x66, 0x30, 0xA4, 0x90,
    0x1F, 0xCD, 0xA9, 0x2F, 0x70, 0xE2, 0x2F, 0xF9, 0x36, 0x00, 0x18, 0xF0, 0x0E, 0x7E, 0xED, 0xD5, 0xFA, 0x4C, 0xA3, 0x7E, 0x06,
    0x45, 0x5D, 0xDA, 0xEA, 0xE6, 0x17, 0x73, 0x5E, 0x45, 0x0B, 0x36, 0x1D, 0x37, 0x0E, 0x7B, 0x6A, 0xB5, 0x27, 0xA3, 0x30, 0xB5,
    0x7C, 0x7A, 0x1C, 0x1E, 0x1A, 0xF0, 0x21, 0x5B, 0xA1, 0x52, 0x58, 0xD0, 0xE9, 0x34, 0x4A, 0xD0, 0xC7, 0xE5, 0x79, 0x3D, 0x30,
    0x24, 0x22, 0x54, 0x60, 0xBC, 0x64, 0xAB, 0x5C, 0xB3, 0x22, 0xB3, 0xB5, 0x94, 0x32, 0x55, 0xA8, 0x5E, 0xF0, 0xCC, 0x9C, 0x48,
    0x9D, 0x6A, 0x9C, 0x8C, 0xCF, 0x96, 0x42, 0xAD, 0x1E, 0x28, 0x6C, 0x02, 0xE2, 0x7A, 0x65, 0xEF, 0xB5, 0x57, 0x2D, 0xC1, 0xFA,
    0xF2, 0x2D, 0x26, 0x12, 0x84, 0x13, 0x86, 0x4C, 0x91, 0x88, 0x2F, 0x06, 0x04, 0x4D, 0xBA, 0x70, 0x9F, 0x26, 0xB0, 0x23, 0xD0,
    0x44, 0x3A, 0x08, 0xA9, 0xB3, 0x95, 0xE0, 0x94, 0x5A, 0x3B, 0x4C, 0xCB, 0xD2, 0x4F, 0x2D, 0x78, 0x2E, 0x28, 0x86, 0x9D, 0x4D,
    0xD6, 0x46, 0x33, 0x93, 0xEE, 0xD1, 0x33, 0x4A, 0x2E, 0xD4, 0x87, 0xF4, 0x42, 0x37, 0x84, 0x4C, 0x1D, 0x69, 0xE5, 0x8C, 0xA5,
    0x29, 0x16, 0x4B, 0x32, 0xE3, 0xD0, 0x37, 0x6A, 0x16, 0xE3, 0xA3, 0x8C, 0xEA, 0x76, 0x83, 0x98, 0xB2, 0xE4, 0x24, 0x40, 0x28,
    0xE1, 0xAC, 0x86, 0x2B, 0x58, 0xDE, 0x0A, 0xBA, 0xBE, 0xF9, 0xA0, 0xB8, 0x30, 0xDB, 0x74, 0x8A, 0xF4, 0xB5, 0x68, 0x90, 0x56,
    0x4E, 0xEC, 0xD0, 0x8D, 0x82, 0xC1, 0x66, 0xB6, 0x04, 0xF1, 0x89, 0xD0, 0x34, 0xAE, 0xC7, 0x8F, 0x34, 0xA3, 0x1C, 0x37, 0xF8,
    0xAB, 0xB6, 0x83, 0xDD, 0x1C, 0xC6, 0x29, 0xB3, 0x6B, 0x6E, 0x29, 0x5A, 0xAF, 0xC4, 0x90, 0x7D, 0x36, 0x5C, 0x67, 0x87, 0x66,
    0x0F, 0x71, 0x65, 0xA2, 0x05, 0xB6, 0xB0, 0x9C, 0x6B, 0xE4, 0x9E, 0x24, 0x99, 0x30, 0xB5, 0x59, 0xBA, 0x37, 0xED, 0x67, 0xD3,
    0x0F, 0x07, 0x61, 0x93, 0x4E, 0xFE, 0xB6, 0xC6, 0x10, 0xE4, 0x32, 0x38, 0x2A, 0x83, 0xD0, 0xE2, 0x35, 0x94, 0x6C, 0x5C, 0x0E,
    0x24, 0xE6, 0x9B, 0x40, 0xCD, 0x32, 0x69, 0x74, 0xA3, 0xCC, 0x4E, 0x05, 0x68, 0x09, 0x3F, 0xD1, 0xE9, 0xE8, 0xB1, 0x37, 0x54,
    0x8E, 0x0E, 0x12, 0xD5, 0x7C, 0x85, 0xDA, 0x02, 0xA0, 0xB0, 0x91, 0x58, 0x75, 0x02, 0x7C, 0xD0, 0x72, 0x74, 0x72, 0x01, 0x10,
    0x1A, 0x2E, 0xAD, 0x0A, 0x9A, 0x06, 0xEF, 0x87, 0xAA, 0x63, 0xD0, 0x82, 0xA7, 0x39, 0x17, 0x10, 0x63, 0x5D, 0x3E, 0x82, 0x66,
    0xCF, 0x05, 0xB4, 0x90, 0x8C, 0xF4, 0x8B, 0x03, 0x4B, 0x14, 0x17, 0xD7, 0x32, 0x72, 0x64, 0x84, 0x53, 0xE3, 0x59, 0x34, 0xDC,
    0x68, 0xB7, 0x21, 0x3F, 0xF3, 0x09, 0xAF, 0x2B, 0x36, 0xCC, 0x05, 0x98, 0x41, 0xD8, 0x44, 0x1F, 0xA9, 0xA8, 0x2E, 0x8D, 0xFC,
    0xCB, 0xDD, 0xCC, 0x68, 0x5D, 0x27, 0x20, 0xEC, 0x27, 0xD2, 0xF9, 0xD5, 0x28, 0x9C, 0xE4, 0x9A, 0x6B, 0xEB, 0xB7, 0xAC, 0x29,
    0x2B, 0x01, 0x4B, 0x0A, 0x36, 0xDC, 0x91, 0x8F, 0x6E, 0x36, 0xC3, 0x1C, 0xA1, 0xDA, 0x6F, 0x06, 0x74, 0xEF, 0x3B, 0xBD, 0x1F,
    0xF3, 0xE0, 0xF5, 0xDF, 0x2B, 0x28, 0x4F, 0x02, 0x82, 0xF6, 0xCF, 0x01, 0x17, 0xE8, 0x1E, 0x30, 0xC7, 0xB2, 0x82, 0x0C, 0x6A,
    0x41, 0xAA, 0x40, 0xE1, 0x8F, 0x0E, 0x51, 0x41, 0x24, 0x9B, 0xE6, 0x70, 0x21, 0x7D, 0x7B, 0x48, 0x01, 0x6D, 0x3E, 0x53, 0x83,
    0xD4, 0x3F, 0xDF, 0xE1, 0x66, 0xD2, 0x18, 0x25, 0xBB, 0x47, 0x69, 0xFB, 0x28, 0x64, 0x76, 0x72, 0x5C, 0x08, 0xEA, 0xE1, 0xF4,
    0xDC, 0x82, 0x83, 0x4F, 0xCC, 0x74, 0x92, 0x9D, 0xE6, 0x80, 0x38, 0xCC, 0x65, 0xFB, 0x7A, 0x9A, 0x13, 0x02, 0x5C, 0xB5, 0xBD,
    0xA0, 0x29, 0x56, 0x5E, 0xB4, 0x5E, 0x1B, 0x77, 0xA8, 0xB4, 0x52, 0x0F, 0x03, 0x36, 0xC7, 0xA6, 0x6E, 0x43, 0x6E, 0xB0, 0x19,
    0xD4, 0x11, 0x0C, 0xFA, 0x0E, 0xFE, 0x0D, 0x32, 0x51, 0x70, 0x90, 0xD0, 0x40, 0x01, 0xFD, 0xF6, 0x3E, 0x55, 0x76, 0x0E, 0x59,
    0xAD, 0x5B, 0xCB, 0x65, 0xA5, 0x98, 0x36, 0x5D, 0xD3, 0x44, 0xCE, 0x5A, 0xFB, 0x74, 0xB9, 0xC0, 0x51, 0x7D, 0xB8, 0x70, 0xED,
    0x9E, 0xCA, 0xBB, 0x84, 0x68, 0x98, 0x55, 0xE8, 0x18, 0x26, 0x5D, 0x62, 0x90, 0x7B, 0x51, 0x84, 0x05, 0xB3, 0x18, 0xA9, 0x0A,
    0x55, 0x17, 0x46, 0x0F, 0xEF, 0x47, 0xB5, 0x21, 0x44, 0x7F, 0x19, 0xDF, 0x43, 0xFD, 0xBB, 0x92, 0x05, 0xF3, 0x23, 0xE6, 0xBD,
    0x6A, 0xA2, 0x2A, 0xAF, 0xCD, 0xA8, 0x33, 0xCC, 0x89, 0x8A, 0xBC, 0x6E, 0x53, 0xE8, 0x35, 0x9B, 0xB6, 0xEF, 0x1B, 0x6E, 0x89,
    0x16, 0xE6, 0x4D, 0xC9, 0x6A, 0x0F, 0x47, 0x70, 0xD0, 0x08, 0x01, 0x79, 0xAC, 0xA5, 0x1A, 0xE9, 0x66, 0xCA, 0x1B, 0x79, 0x24,
    0x2D, 0xE6, 0xCD, 0x00, 0x7E, 0x5A, 0x24, 0x3D, 0x6B, 0xB3, 0xE9, 0x5E, 0xA1, 0xB7, 0xA0, 0x50, 0x2A, 0xEA, 0x9E, 0xB5, 0x27,
    0xA6, 0x75, 0xFD, 0x9A, 0xFC, 0x55, 0x37, 0x21, 0xA3, 0x18, 0x42, 0xAE, 0x44, 0xA7, 0xB2, 0x52, 0x6E, 0x21, 0x02, 0x67, 0xCB,
    0x7C, 0xBB, 0xFD, 0x5A, 0x0C, 0x22, 0xA9, 0x70, 0x39, 0xCF, 0xB2, 0x85, 0x47, 0xCB, 0x61, 0x9C, 0x1D, 0xA3, 0xD3, 0x0D, 0xFB,
    0x25, 0x2A, 0x8E, 0x28, 0x98, 0xBD, 0x1E, 0x48, 0x39, 0x12, 0xA4, 0x38, 0xDA, 0x38, 0x03, 0x64, 0x92, 0x43, 0x20, 0x83, 0x05,
    0xAD, 0x0A, 0x5A, 0x51, 0x0F, 0x00, 0xDF, 0xEB, 0x81, 0xEA, 0xCE, 0x29, 0xE0, 0x04, 0x1C, 0xB7, 0x0C, 0x70, 0xA8, 0xBA, 0xEE,
    0x9C, 0x1D, 0x4C, 0x71, 0xCD, 0x7D, 0xE3, 0x60, 0x1B, 0xC6, 0x88, 0x4A, 0xA1, 0x14, 0x84, 0x6F, 0xB6, 0x3C, 0x78, 0xE1, 0x51,
    0x98, 0x23, 0xA1, 0xC1, 0x8F, 0xD5, 0x3F, 0x43, 0x25, 0x2A, 0x4E, 0x48, 0xDC, 0x03, 0x5B, 0xC5, 0x5B, 0x92, 0x44, 0x93, 0x6F,
    0x0C, 0x32, 0x02, 0x2F, 0x01, 0x17, 0x12, 0xD3, 0x01, 0xBB, 0x9C, 0x95, 0xBB, 0xCA, 0xBB, 0x4B, 0x3E, 0x32, 0x59, 0x27, 0x62,
    0x6A, 0x8B, 0xA1, 0x29, 0x3E, 0xBF, 0x32, 0x30, 0x4C, 0x24, 0x60, 0x1B, 0x17, 0x7D, 0xF6, 0x47, 0x80, 0xAA, 0xD7, 0xB9, 0x28,
    0x4F, 0x2C, 0x74, 0xE5, 0xEE, 0x2E, 0x1D, 0xC2, 0x63, 0x0E, 0xEC, 0x53, 0x39, 0x1E, 0x52, 0xDC, 0x17, 0x3E, 0x8F, 0x05, 0x9E,
    0xAE, 0xB6, 0x2B, 0x3D, 0x13, 0xD8, 0x31, 0xBC, 0x55, 0x2B, 0x9F, 0xC0, 0xA4, 0xA7, 0x55, 0xD3, 0x50, 0x16, 0xB9, 0x15, 0x68,
    0xF4, 0xFE, 0xCC, 0xE2, 0x27, 0x44, 0xA5, 0x17, 0xA2, 0xEE, 0x3C, 0xFE, 0xC7, 0xD9, 0x16, 0x77, 0x98, 0xA2, 0x4E, 0xA7, 0x20,
    0x42, 0x85, 0x05, 0xCC, 0x79, 0xCE, 0x40, 0xAE, 0xEB, 0x16, 0xE6, 0x52, 0x10, 0xA4, 0xA0, 0x11, 0x73, 0xCE, 0xD8, 0x93, 0x3F,
    0xEA, 0x4A, 0x31, 0x67, 0x64, 0x1F, 0x9A, 0x00, 0x6B, 0xE6, 0x6C, 0x1A, 0x51, 0x68, 0x07, 0x20, 0x1B, 0x13, 0x45, 0x66, 0xB6,
    0x4E, 0x4D, 0xB1, 0xB9, 0x04, 0xD4, 0xEA, 0xE6, 0x30, 0x05, 0x16, 0xA1, 0x9E, 0x14, 0x85, 0xAF, 0x72, 0x6C, 0x40, 0x53, 0x4D,
    0x08, 0x3B, 0x38, 0x65, 0x71, 0x10, 0x1A, 0xE7, 0xB9, 0xFD, 0xC4, 0x1E, 0xE5, 0xA3, 0x19, 0x35, 0xEF, 0x4B, 0x40, 0x4F, 0x8D,
    0xC0, 0xBF, 0x73, 0xD9, 0x96, 0x3A, 0xA1, 0xA8, 0xC1, 0xAC, 0xAE, 0x5F, 0x1A, 0xC0, 0x28, 0x3F, 0x73, 0xDA, 0xF5, 0xD6, 0x5D,
    0x5F, 0x22, 0x1C, 0xF5, 0x58, 0x41, 0x0F, 0xD3, 0xAE, 0x8A, 0x0E, 0xEA, 0xFC, 0x2F, 0x9D, 0x10, 0x55, 0xE1, 0x8A, 0x3E, 0x07,
    0x86, 0xA0, 0xA4, 0xEB, 0x5B, 0x30, 0x88, 0x99, 0x98, 0xFA, 0x39, 0xF5, 0xA3, 0x28, 0xEB, 0x7C, 0x50, 0xFB, 0x7E, 0x1A, 0x19,
    0x72, 0x5B, 0x83, 0x30, 0xE4, 0xAA, 0x5E, 0x0C, 0x9C, 0x2D, 0xB6, 0xFC, 0x81, 0x5E, 0xB8, 0xBE, 0x2F, 0x5F, 0x27, 0x62, 0x29,
    0xAF, 0x6A, 0x9C, 0x60, 0x15, 0x51, 0x61, 0x3C, 0xB8, 0xAA, 0x3B, 0x9C, 0xC5, 0xC5, 0x89, 0xB0, 0x0D, 0x4B, 0xE6, 0x6E, 0x7A,
    0xE6, 0x0D, 0x01, 0x90, 0x6E, 0xE0, 0x10, 0xA8, 0x82, 0x27, 0x8C, 0xF9, 0x8C, 0xC0, 0xDB, 0x94, 0x72, 0xFE, 0x17, 0x11, 0x08,
    0x73, 0x73, 0xAD, 0x44, 0xEE, 0xDA, 0x00, 0xB7, 0x45, 0x4D, 0x8F, 0xF4, 0xAE, 0x31, 0x55, 0xC5, 0x10, 0x7B, 0x4E, 0x13, 0x81,
    0xA7, 0x13, 0xF6, 0x00, 0x48, 0xB3, 0x51, 0x80, 0xBD, 0xBA, 0x38, 0x36, 0x8A, 0xAA, 0xC1, 0x38, 0xDE, 0xC6, 0xB1, 0xF5, 0x08,
    0x92, 0x98, 0xB9, 0xCF, 0xF7, 0xBB, 0x2C, 0x74, 0xF4, 0xB3, 0xA8, 0xD0, 0x9F, 0x4F, 0x7A, 0xAC, 0x3B, 0x36, 0x92, 0x5D, 0xEA,
    0x25, 0x42, 0x71, 0x04, 0xFD, 0x89, 0x67, 0xBF, 0xD4, 0x50, 0xE4, 0x88, 0x46, 0x6A, 0x2A, 0xE4, 0x70, 0x78, 0xF9, 0x79, 0xBC,
    0x9F, 0x95, 0x63, 0xDA, 0xC4, 0x13, 0x1A, 0xD8, 0xA2, 0xA9, 0x65, 0x5F, 0xC7, 0x24, 0xB4, 0xEE, 0xD2, 0x91, 0xD7, 0x21, 0x62,
    0xD2, 0x29, 0x5D, 0x8A, 0x14, 0x1B, 0xA3, 0xCC, 0x48, 0x09, 0xBE, 0x4F, 0x20, 0xE4, 0x51, 0x18, 0xD6, 0x84, 0x1A, 0xFF, 0xC7,
    0x73, 0x7B, 0x54, 0xDB, 0x86, 0x87, 0xC7, 0xCA, 0x26, 0xB1, 0xEE, 0x93, 0xEA, 0x24, 0xE2, 0x68, 0x18, 0xE7, 0xA2, 0x97, 0x13,
    0xD0, 0x88, 0x69, 0x4E, 0x92, 0xB1, 0xEE, 0x33, 0x4D, 0x80, 0x24, 0xF6, 0x64, 0x1F, 0xBB, 0x0C, 0xA1, 0xD7, 0x40, 0x1F, 0x49,
    0x80, 0x8D, 0xE6, 0x83, 0x30, 0x7B, 0x68, 0xD0, 0x05, 0x83, 0x60, 0xC3, 0x12, 0x86, 0xC5, 0x4B, 0x41, 0xFB, 0x59, 0x9F, 0x50,
    0xFF, 0xA3, 0x69, 0xA9, 0xEB, 0x3B, 0x21, 0x56, 0x03, 0x41, 0xFA, 0xE9, 0xF5, 0x8C, 0xA0, 0x98, 0x4F, 0x1B, 0xE7, 0x45, 0x41,
    0x01, 0x41, 0x9A, 0x14, 0xFA, 0x53, 0x0F, 0x45, 0x6E, 0xC0, 0x2A, 0x84, 0x80, 0x84, 0x30, 0x2E, 0x63, 0x6F, 0x3F, 0x7F, 0x17,
    0xF0, 0xEF, 0x39, 0x62, 0xAC, 0x80, 0xE6, 0x08, 0xBD, 0x21, 0x3C, 0xCF, 0x32, 0xCB, 0xC2, 0x91, 0xD6, 0xF0, 0x92, 0xAE, 0xA4,
    0xCC, 0x02, 0x57, 0xF4, 0xB3, 0x06, 0x3A, 0x5D, 0x4A, 0xAF, 0x27, 0xEA, 0xCC, 0x81, 0x81, 0xBA, 0x54, 0x1C, 0x56, 0xBF, 0xEC,
    0xCB, 0xA4, 0xF8, 0x95, 0x63, 0xB8, 0x67, 0x71, 0xBA, 0x97, 0x95, 0x58, 0xEB, 0x65, 0x02, 0xAF, 0x15, 0x4A, 0x82, 0x00, 0x70,
    0x31, 0x10, 0xDC, 0x19, 0x09, 0xE4, 0x41, 0xBE, 0xFE, 0xF9, 0x09, 0xBA, 0x04, 0x31, 0x1C, 0x22, 0x0E, 0xD8, 0x6C, 0x7E, 0x54,
    0x63, 0x2A, 0xC9, 0x08, 0x89, 0x57, 0x03, 0xC3, 0x1C, 0xBB, 0x61, 0xA1, 0x9A, 0xA2, 0xCA, 0x02, 0x08, 0x75, 0x7E, 0x7E, 0xE8,
    0xB0, 0x22, 0xD5, 0x39, 0xCF, 0x07, 0x1A, 0x24, 0x57, 0x89, 0x8B, 0x3C, 0xFA, 0x87, 0x84, 0x41, 0xF5, 0x59, 0x7D, 0x0E, 0xAF,
    0xF4, 0x85, 0x83, 0xE3, 0xFF, 0x82, 0x1D, 0xBF, 0x56, 0x4C, 0x60, 0x55, 0xB5, 0xFE, 0x1E, 0x30, 0x63, 0x77, 0x8C, 0x04, 0x10,
    0xF6, 0xBD, 0x36, 0xC6, 0xA3, 0x09, 0x08, 0xF5, 0xDA, 0xD7, 0x29, 0xD1, 0xDB, 0xF7, 0xD3, 0xF0, 0xA1, 0xF4, 0xC0, 0xB9, 0x79,
    0x5F, 0x28, 0x9C, 0x81, 0xF8, 0x38, 0x75, 0x93, 0x2A, 0xB9, 0x43, 0x6B, 0x40, 0xB8, 0x37, 0xEC, 0xD0, 0xA3, 0x68, 0x5D, 0xA6,
    0xD2, 0x49, 0x39, 0xA1, 0xB1, 0x63, 0x59, 0xC2, 0x73, 0xAB, 0xA3, 0xB9, 0x30, 0x90, 0x3E, 0x66, 0xAC, 0x55, 0xEE, 0xB4, 0x72,
    0x62, 0xA9, 0x30, 0x24, 0xBE, 0xDC, 0xF1, 0x46, 0x40, 0xBE, 0x73, 0x86, 0xCA, 0xD0, 0x76, 0xDB, 0x34, 0x0A, 0x53, 0xC8, 0x58,
    0x68, 0xE3, 0x16, 0x41, 0x41, 0x10, 0xAF, 0x8F, 0xC1, 0xD4, 0x43, 0x60, 0xE3, 0x2D, 0xE0, 0x1C, 0x3B, 0xC5, 0x3C, 0x83, 0x56,
    0xF3, 0x30, 0x66, 0x3C, 0xE4, 0x62, 0x8A, 0x65, 0xF4, 0xC7, 0x77, 0x5E, 0x04, 0xDA, 0x5E, 0xA6, 0x10, 0xA6, 0xE0, 0x06, 0xB7,
    0x64, 0x04, 0x4E, 0xB6, 0x46, 0xDB, 0x77, 0x30, 0x1D, 0x78, 0x90, 0x35, 0x4E, 0x22, 0x9E, 0x8A, 0xD7, 0x83, 0x25, 0x1A, 0xAB,
    0xA8, 0xA7, 0xFB, 0x5A, 0x12, 0x60, 0x4F, 0x33, 0xAA, 0x19, 0xFB, 0xA0, 0x09, 0x9B, 0x40, 0xB8, 0xBF, 0x8D, 0xD4, 0x23, 0xA7,
    0xFD, 0x40, 0xE0, 0x9B, 0xFC, 0x70, 0x4C, 0x1F, 0x29, 0xB0, 0x17, 0xD8, 0x1B, 0x63, 0xFD, 0x11, 0xF4, 0xBA, 0xA6, 0x28, 0x8C,
    0xE0, 0x21, 0xED, 0x1D, 0x66, 0xCD, 0xF4, 0x4D, 0x8A, 0xA3, 0xAD, 0x8D, 0xE2, 0x86, 0x82, 0xEC, 0xA6, 0xA9, 0x21, 0xE2, 0x46,
    0xF4, 0x12, 0xA7, 0xFE, 0xED, 0xE2, 0x47, 0xD8, 0x76, 0xB0, 0xD2, 0x84, 0xA6, 0xC0, 0xA9, 0x09, 0xF6, 0x22, 0x66, 0xFE, 0x74,
    0xBA, 0x55, 0x09, 0xD5, 0x23, 0x89, 0x46, 0x81, 0x58, 0xDE, 0x63, 0x68, 0xAA, 0x27, 0x12, 0xD1, 0xD1, 0x30, 0xF8, 0x89, 0x2A,
    0xC9, 0xB8, 0x69, 0xAF, 0x58, 0xBE, 0x0F, 0xF3, 0x1B, 0xBA, 0x15, 0x85, 0xC7, 0xFB, 0x00, 0x7A, 0xAF, 0x76, 0xB2, 0x6E, 0x8D,
    0xC2, 0x73, 0xA2, 0x2F, 0x86, 0x53, 0xD4, 0xC6, 0x65, 0x7E, 0x20, 0x87, 0xDB, 0x42, 0xCC, 0xA7, 0x5D, 0xB0, 0x2C, 0x38, 0x48,
    0x64, 0xF4, 0xA1, 0x8E, 0x77, 0xE5, 0x2D, 0x25, 0xD3, 0xC8, 0x47, 0x32, 0x2C, 0xF4, 0xF3, 0x35, 0x2D, 0x63, 0x15, 0x07, 0x03,
    0xAF, 0x24, 0x9D, 0x94, 0xF9, 0x9B, 0x44, 0xC3, 0x61, 0x71, 0x88, 0xEB, 0x32, 0x3A, 0x59, 0xD7, 0x7E, 0x93, 0x3E, 0x37, 0x59,
    0x38, 0x0C, 0x85, 0xF9, 0x69, 0xCB, 0x38, 0xBE, 0x77, 0x0F, 0xCD, 0x38, 0x8D, 0xB8, 0xEB, 0x22, 0xE4, 0x2B, 0xBB, 0x58, 0x40,
    0x7D, 0x04, 0xAF, 0xE4, 0x9C, 0x3C, 0xF4, 0xC4, 0x69, 0xD7, 0x89, 0x4E, 0xA1, 0xAE, 0x92, 0xA6, 0x29, 0xA6, 0xAB, 0x66, 0x5B,
    0x60, 0x6E, 0x4E, 0xB8, 0x9A, 0x51, 0x0F, 0xCE, 0xEF, 0x28, 0xE8, 0x1A, 0x3F, 0x73, 0xC0, 0xF8, 0xD0, 0xD1, 0xC5, 0x05, 0x52,
    0xA6, 0xA6, 0x7B, 0x44, 0x71, 0xD5, 0x9B, 0x58, 0xBC, 0x67, 0xC8, 0x30, 0x66, 0xAB, 0x71, 0x2E, 0x39, 0x78, 0x8B, 0x7A, 0x5F,
    0xBD, 0x25, 0xF0, 0x72, 0xE9, 0xF7, 0x0F, 0x9E, 0x3C, 0x90, 0x90, 0xEB, 0x59, 0x6F, 0x21, 0x00, 0x1A, 0x41, 0x30, 0x85, 0x1F,
    0x47, 0x83, 0x9E, 0xE3, 0xF2, 0x95, 0x91, 0xA4, 0x55, 0xA5, 0xC8, 0x49, 0xCB, 0x39, 0x8C, 0x2C, 0x51, 0x19, 0x7D, 0x0A, 0x4B,
    0x42, 0xC6, 0xC4, 0xC1, 0x33, 0x97, 0xCE, 0x2B, 0x5D, 0x48, 0x35, 0x5A, 0x9E, 0x1F, 0xEE, 0x7D, 0x86, 0xEC, 0xBE, 0xB7, 0xD5,
    0xFE, 0x9A, 0x56, 0xD0, 0xC7, 0xBA, 0x99, 0x2B, 0x33, 0xEE, 0xAD, 0xFD, 0x6B, 0x31, 0x91, 0x0C, 0x00, 0x43, 0x74, 0x58, 0xA0,
    0x55, 0xB2, 0x46, 0x8A, 0x1F, 0x89, 0xFE, 0xF5, 0xBD, 0x7F, 0x9B, 0xF4, 0x70, 0x03, 0x82, 0x8A, 0xCE, 0xF5, 0x5D, 0x01, 0x53,
    0x5B, 0xEF, 0x24, 0xA8, 0xAC, 0x5E, 0xA6, 0x18, 0xA6, 0x4F, 0x7E, 0x5E, 0x40, 0x00, 0x82, 0x37, 0x0A, 0xA2, 0xD2, 0x3E, 0x6C,
    0xD1, 0xA0, 0xA6, 0x47, 0x53, 0x44, 0x1F, 0x89, 0x4E, 0x20, 0x52, 0x11, 0x84, 0xFA, 0x0C, 0xBB, 0x16, 0xDD, 0x9C, 0x77, 0xAF,
    0xDB, 0x86, 0xF4, 0x52, 0xFE, 0xFC, 0x06, 0xA4, 0x1B, 0x41, 0xA5, 0xB1, 0x50, 0x3C, 0x11, 0xAE, 0x71, 0x43, 0xF1, 0x9F, 0x67,
    0x60, 0xD5, 0xEB, 0x51, 0x0A, 0x77, 0xEF, 0xB1, 0x94, 0x69, 0x89, 0xBA, 0xD1, 0xC4, 0xBC, 0x4B, 0xB7, 0x2E, 0x21, 0xF0, 0x1A,
    0x9F, 0xF7, 0xAF, 0x5F, 0x42, 0x53, 0x28, 0x3E, 0x51, 0x06, 0x99, 0x2E, 0x42, 0xE1, 0x2F, 0x77, 0xA8, 0x01, 0xEB, 0x86, 0x17,
    0x2F, 0x56, 0xCC, 0xE4, 0xA2, 0x9D, 0xF9, 0xC7, 0x7B, 0x0C, 0xD1, 0x6F, 0x84, 0xF3, 0x06, 0xE0, 0xF8, 0x37, 0x42, 0x82, 0xCE,
    0x86, 0x74, 0x99, 0xF9, 0xCD, 0xE3, 0x1B, 0x75, 0x0A, 0x66, 0xE2, 0x65, 0x01, 0x34, 0xCC, 0x35, 0x1F, 0x49, 0x08, 0x29, 0x6A,
    0xD0, 0x68, 0xD1, 0xAF, 0x0F, 0x90, 0x98, 0x1C, 0xE9, 0x3C, 0x0D, 0xC2, 0x4F, 0xA7, 0xA9, 0xD0, 0x1F, 0xFF, 0x74, 0xC2, 0x4F,
    0x65, 0x5F, 0x00, 0x72, 0x69, 0x09, 0x40, 0x20, 0x4C, 0xC9, 0x71, 0xC8, 0xEB, 0xFF, 0x01, 0x9F, 0xFC, 0x2D, 0x2B, 0x6D, 0x26,
    0x1C, 0x00, 0xC0, 0xEA, 0x3F, 0x8B, 0x59, 0xAF, 0x39, 0x00, 0x2B, 0x65, 0x0D, 0x00, 0x90, 0x10, 0x7D, 0x13, 0xF9, 0xFD, 0xAC,
    0x5B, 0x6F, 0x3F, 0x01, 0x00, 0xF6, 0xB2, 0x1C, 0x00, 0x11, 0xE8, 0x33, 0x00, 0x3C, 0xFD, 0x2F, 0x99, 0x6C, 0x05, 0x70, 0x02,
    0xF6, 0x07, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00, 0x1C, 0x4D, 0x11, 0x00, 0x6A, 0x0C, 0x00, 0x00, 0xDE, 0x64, 0x00, 0x00, 0xEF,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x5F, 0x22, 0x01, 0x00, 0xFE, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x3D, 0x00, 0x00, 0x00, 0x04, 0x2A, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static uint8_t compressedData2[COMPRESSED_SIZE2] = {
    0xB5, 0x5A, 0xBB, 0xF7, 0x34, 0x5E, 0xEC, 0x73, 0x44, 0xF3, 0x1D, 0x75, 0x83, 0x23, 0x52, 0xAA, 0xF4, 0x3E, 0xB8, 0xD5, 0xBC,
    0x03, 0xA9, 0xD0, 0x64, 0x29, 0xF3, 0x21, 0x3B, 0x80, 0xF2, 0x1E, 0x93, 0x7C, 0xC6, 0x3F, 0x03, 0xBB, 0x2D, 0x2D, 0xAC, 0xC2,
    0x96, 0xCF, 0xBC, 0x40, 0x3A, 0xDC, 0x98, 0xDA, 0x2D, 0x79, 0x5D, 0xB1, 0xF6, 0x73, 0x36, 0xD6, 0x39, 0xE4, 0x00, 0xF6, 0x5C,
    0xCF, 0xAD, 0x3E, 0x4A, 0x0A, 0x23, 0x84, 0xDB, 0x76, 0x43, 0x9C, 0xE1, 0xDE, 0xA3, 0xCA, 0x89, 0xBE, 0xC8, 0xAC, 0xEB, 0xDB,
    0xE8, 0x0E, 0x39, 0x3F, 0x56, 0xC6, 0x5A, 0xF2, 0x90, 0xB6, 0x97, 0x5C, 0xA0, 0x52, 0x78, 0x8D, 0x43, 0xD5, 0xFF, 0xD2, 0x4E,
    0x4E, 0x6D, 0x3B, 0x03, 0x86, 0x35, 0x86, 0x53, 0x31, 0xAF, 0xB7, 0x73, 0xFC, 0xCF, 0x1E, 0xF6, 0x2B, 0x5B, 0x2C, 0x88, 0x38,
    0x43, 0x98, 0xE7, 0xFD, 0x27, 0xAD, 0x6B, 0x0B, 0xEF, 0xDA, 0x3E, 0x5A, 0xA0, 0x4D, 0x67, 0xB9, 0x8B, 0x0D, 0x46, 0xFF, 0xD9,
    0xC9, 0xCE, 0x5C, 0x8F, 0x94, 0xDF, 0x85, 0x7A, 0x84, 0xC2, 0x52, 0x62, 0x7C, 0x5E, 0x72, 0xE8, 0xA6, 0x9C, 0x29, 0x64, 0x89,
    0x5F, 0xD6, 0x96, 0xAB, 0x6B, 0x0C, 0xB9, 0xC4, 0x6F, 0x8F, 0x93, 0x96, 0x3A, 0xD2, 0x76, 0xA6, 0x75, 0xAF, 0xB6, 0xF7, 0xB0,
    0xD0, 0x32, 0xAB, 0x31, 0xAC, 0x07, 0x5D, 0xA7, 0x55, 0x5B, 0x4E, 0xF6, 0xF7, 0x8D, 0x3C, 0x3A, 0x12, 0xAE, 0xE8, 0xCA, 0xB7,
    0xFE, 0xEC, 0x52, 0x29, 0x6F, 0xF1, 0xBC, 0x98, 0xBB, 0xC7, 0xD2, 0x21, 0xDF, 0xE4, 0x25, 0x05, 0xF2, 0x39, 0xDF, 0x78, 0x2C,
    0x27, 0x4E, 0x36, 0x8A, 0x4D, 0xF0, 0x2F, 0x7A, 0x7E, 0xBA, 0xD4, 0x97, 0x4C, 0x4B, 0x8E, 0x39, 0x4C, 0xF7, 0xF8, 0x2B, 0xB9,
    0x65, 0x31, 0x5A, 0xF9, 0x73, 0x2E, 0xDB, 0xB7, 0x68, 0xDD, 0x1A, 0x68, 0xEC, 0x1B, 0x59, 0x32, 0x7B, 0x3C, 0xE9, 0x22, 0xBC,
    0x5A, 0x68, 0xF9, 0xB6, 0x72, 0x9C, 0x1B, 0x52, 0x7A, 0x0D, 0xF6, 0x97, 0x5A, 0xC2, 0x3C, 0xD2, 0x36, 0xF5, 0x9E, 0x4E, 0x1F,
    0xF4, 0x74, 0x35, 0x6B, 0xFC, 0x81, 0x94, 0x76, 0xDA, 0x7F, 0x25, 0xE6, 0xF8, 0x21, 0x22, 0x8F, 0x51, 0x06, 0x46, 0xCE, 0xE4,
    0xEC, 0xC7, 0x91, 0x2F, 0xE8, 0x3B, 0x3E, 0xAC, 0xFF, 0x78, 0xD9, 0xE2, 0xBA, 0x9A, 0xF1, 0xCC, 0x64, 0x17, 0xC3, 0xDA, 0x93,
    0xFF, 0x89, 0xCD, 0x16, 0xF7, 0xF3, 0x2D, 0xC3, 0x2D, 0x16, 0x87, 0x47, 0x7E, 0x5D, 0x62, 0xA5, 0x81, 0x8D, 0xF3, 0xF2, 0xA7,
    0xED, 0x2D, 0x96, 0x46, 0xC1, 0x3B, 0x4B, 0x5C, 0xBA, 0xED, 0x2F, 0x4D, 0x14, 0x80, 0x10, 0xF8, 0x4C, 0x9E, 0xC5, 0x36, 0x8A,
    0x1E, 0xDD, 0x25, 0x4B, 0x8E, 0xB6, 0x4F, 0x01, 0xA2, 0xEB, 0x52, 0xC2, 0x69, 0xCA, 0xCC, 0xEF, 0xB7, 0x9C, 0x7D, 0xCB, 0xE7,
    0xD5, 0x9D, 0x47, 0xA6, 0xAB, 0x47, 0x76, 0x5F, 0x5D, 0xC9, 0x7B, 0xC2, 0xAF, 0x4D, 0xAF, 0xE7, 0x8C, 0xFA, 0xA1, 0x95, 0x65,
    0x88, 0xA1, 0xC0, 0x1B, 0x5B, 0xA4, 0x9B, 0x70, 0x0A, 0xF9, 0xF7, 0x73, 0x05, 0xCD, 0x33, 0x8B, 0x16, 0x32, 0x89, 0x22, 0xE7,
    0x4C, 0xA8, 0x55, 0x87, 0x7C, 0xD6, 0x1A, 0xB6, 0x38, 0xE5, 0xAB, 0x0C, 0x12, 0x24, 0x52, 0xDB, 0x17, 0xDB, 0x5B, 0xC7, 0xC3,
    0xBF, 0x97, 0x3F, 0xEC, 0x29, 0x1D, 0x1F, 0x29, 0x8B, 0x47, 0x2B, 0x5D, 0x01, 0x32, 0x8B, 0x87, 0x56, 0x04, 0x04, 0x2D, 0x4D,
    0x6F, 0x6F, 0xCD, 0x1E, 0x65, 0x24, 0xB8, 0x1D, 0xE2, 0x61, 0x8D, 0xEC, 0xC5, 0x94, 0x64, 0xCB, 0x4A, 0x55, 0x02, 0x5E, 0xE2,
    0x10, 0x0E, 0x08, 0x25, 0x2F, 0x69, 0xAD, 0x37, 0x42, 0x41, 0xB9, 0xBF, 0x7A, 0x8A, 0xD9, 0xDC, 0x85, 0x56, 0x8D, 0x3B, 0x36,
    0x98, 0x9C, 0xF5, 0xEE, 0x53, 0xB8, 0x8A, 0x3F, 0x1E, 0xD0, 0x66, 0xDB, 0xD9, 0x0E, 0xF8, 0x0D, 0x56, 0xB7, 0xED, 0xBB, 0x20,
    0xF0, 0x71, 0x59, 0x30, 0xDE, 0x08, 0x82, 0x26, 0x72, 0xF5, 0xA3, 0x31, 0xAD, 0xAE, 0xF2, 0xCC, 0xD3, 0x72, 0xF4, 0x52, 0x4C,
    0x08, 0x12, 0x25, 0x15, 0xF9, 0x3B, 0xF9, 0xB8, 0x72, 0x0B, 0x07, 0x3F, 0xAF, 0x7A, 0x47, 0xE0, 0x0F, 0xC1, 0x2C, 0xCA, 0x02,
    0xCF, 0x7B, 0x09, 0x39, 0x96, 0x2B, 0x14, 0x26, 0x18, 0x63, 0xA2, 0xB6, 0xF4, 0x1F, 0xE5, 0xEE, 0x63, 0x4D, 0x47, 0x4A, 0x97,
    0xC5, 0x49, 0xD6, 0x4D, 0x07, 0xAE, 0xE5, 0xA3, 0x05, 0x20, 0x91, 0xB9, 0x50, 0xCE, 0x6B, 0x8D, 0x79, 0x9F, 0x14, 0xA0, 0x33,
    0x12, 0x41, 0x0E, 0xE9, 0x0B, 0x29, 0x38, 0x9A, 0x5A, 0xAA, 0x3B, 0x50, 0x08, 0x6F, 0x32, 0xF6, 0xF2, 0xF2, 0x3A, 0xB4, 0xC8,
    0x49, 0xD5, 0xE9, 0xA2, 0xBC, 0xF6, 0xB7, 0x43, 0x58, 0xB4, 0xBA, 0x03, 0x8F, 0xED, 0xD6, 0xC8, 0x23, 0x50, 0xE8, 0x4A, 0x5E,
    0x11, 0xDB, 0x21, 0x7B, 0x63, 0x67, 0xCE, 0x28, 0x07, 0x7E, 0xEF, 0x87, 0x06, 0xF4, 0x28, 0xE5, 0xFE, 0xED, 0x0D, 0x7C, 0x1E,
    0x97, 0xE3, 0xDE, 0xF2, 0xCB, 0x48, 0xCB, 0x9D, 0x32, 0xA5, 0x14, 0x26, 0xAD, 0x3A, 0x69, 0x74, 0x40, 0xF6, 0xD4, 0x29, 0x46,
    0xFE, 0x06, 0xBD, 0xBE, 0x9E, 0x13, 0x80, 0x33, 0x63, 0x08, 0x64, 0x82, 0xB6, 0x20, 0x92, 0x6C, 0xDC, 0xFF, 0xE7, 0x17, 0xFA,
    0xF7, 0xF1, 0xD6, 0x0D, 0xF3, 0xC4, 0x39, 0x3E, 0xA5, 0x27, 0xF0, 0xDC, 0xD7, 0x9E, 0xEF, 0x87, 0x53, 0x35, 0xB4, 0xCA, 0x22,
    0x0C, 0x6C, 0x77, 0xDE, 0x72, 0x0B, 0x31, 0xF2, 0xE4, 0x95, 0xFB, 0xB8, 0x0B, 0x52, 0xB2, 0x00, 0x5D, 0xB8, 0xC5, 0x19, 0xE5,
    0xE8, 0x04, 0x90, 0xC5, 0x75, 0x6D, 0x71, 0x10, 0x40, 0x5E, 0xC9, 0x53, 0xF0, 0x04, 0xCC, 0xCC, 0x82, 0x59, 0x29, 0x25, 0x0F,
    0xEB, 0xF9, 0x4E, 0x33, 0x6A, 0x34, 0x20, 0xCE, 0x0F, 0x40, 0x93, 0xAB, 0x6D, 0xAA, 0x03, 0x9C, 0xE4, 0x58, 0xA2, 0xDD, 0xAA,
    0x77, 0xBB, 0x6A, 0x3B, 0xBC, 0x73, 0xAC, 0x99, 0x9B, 0x83, 0x80, 0xB8, 0x12, 0x5B, 0xAF, 0x89, 0x4A, 0xBD, 0x67, 0x51, 0xBB,
    0x35, 0x1A, 0xD4, 0xF1, 0xF9, 0x87, 0x07, 0x23, 0xF3, 0xF8, 0xA4, 0x71, 0x96, 0x4D, 0xDB, 0x4E, 0x84, 0x0C, 0x73, 0xA0, 0x29,
    0x4F, 0xD8, 0x87, 0x0E, 0x46, 0xCE, 0xF0, 0xC4, 0x7E, 0x5B, 0x1A, 0x81, 0xE1, 0xA9, 0x50, 0x9D, 0xE9, 0x08, 0xD2, 0x43, 0x71,
    0xFF, 0xFF, 0xFB, 0x1E, 0x65, 0x42, 0xFC, 0xBE, 0x7B, 0xA3, 0x09, 0x5A, 0x0F, 0x5E, 0x77, 0xFC, 0x57, 0x8A, 0x0C, 0x44, 0xC5,
    0x8D, 0x46, 0xC0, 0xC7, 0x67, 0x35, 0xEA, 0xB4, 0x5E, 0x1F, 0xB9, 0xD1, 0x95, 0x40, 0x0F, 0x3A, 0x2B, 0xC0, 0xBE, 0xD0, 0x37,
    0xF7, 0x39, 0x82, 0xB9, 0xEC, 0xCE, 0xEB, 0x92, 0x68, 0x0D, 0x42, 0x7C, 0xAF, 0xCA, 0x96, 0xB0, 0x43, 0x49, 0x87, 0x06, 0x86,
    0x70, 0x80, 0x21, 0x0C, 0x62, 0x73, 0x9E, 0x1A, 0x85, 0x96, 0x6C, 0x79, 0x47, 0x22, 0x93, 0xA5, 0x89, 0xD7, 0x30, 0x58, 0x27,
    0xA4, 0x85, 0xE2, 0x4C, 0x57, 0xE3, 0x21, 0xDF, 0x80, 0x9A, 0xE4, 0xBA, 0xCF, 0x8F, 0xA6, 0x9F, 0x2F, 0xDE, 0xFA, 0xB7, 0xAF,
    0x80, 0x92, 0xCE, 0xBE, 0xB4, 0x50, 0xD7, 0x57, 0x21, 0x37, 0x41, 0xB1, 0x4B, 0xAF, 0x79, 0x10, 0x06, 0x6C, 0x8F, 0xCE, 0x19,
    0x38, 0xF2, 0x02, 0x8D, 0xED, 0x68, 0x9B, 0xA9, 0x21, 0x07, 0x98, 0xAA, 0xF6, 0x44, 0x88, 0x61, 0x90, 0x9A, 0xA0, 0xDC, 0x6B,
    0x90, 0xC5, 0x14, 0x77, 0x28, 0x3C, 0xD1, 0x4E, 0x22, 0x3D, 0x29, 0x2C, 0xE4, 0x85, 0x37, 0xBC, 0x62, 0x96, 0x2B, 0x40, 0x56,
    0xCE, 0x68, 0x38, 0x5F, 0x9D, 0x98, 0x64, 0x45, 0x01, 0xEC, 0x29, 0x0B, 0x2F, 0x48, 0xCA, 0xB4, 0xDD, 0x99, 0x86, 0xAB, 0x30,
    0x64, 0x2F, 0x5E, 0xA4, 0xF7, 0xE7, 0x2F, 0xE6, 0xFB, 0x84, 0x52, 0x50, 0x57, 0x88, 0xEE, 0xE6, 0xC2, 0x70, 0x29, 0x1E, 0xB7,
    0x42, 0xD7, 0xCB, 0x49, 0xD7, 0x20, 0xB0, 0xEA, 0xC3, 0x94, 0x4D, 0x77, 0x6E, 0x4B, 0x25, 0xCF, 0xDC, 0xBD, 0x67, 0x4E, 0x78,
    0x4D, 0xC1, 0xD7, 0xE7, 0xF6, 0xA8, 0x56, 0x5A, 0x55, 0x51, 0x89, 0xB4, 0x14, 0x34, 0x80, 0x8A, 0xFE, 0xDD, 0x1F, 0x9C, 0xC2,
    0x98, 0x76, 0x0D, 0x15, 0x0D, 0x1B, 0x78, 0xAC, 0x6E, 0x23, 0xA6, 0xEA, 0x9C, 0xB5, 0xB3, 0xA3, 0x3C, 0x5D, 0xCF, 0x95, 0x3D,
    0xA1, 0x65, 0x08, 0x56, 0xD0, 0x4D, 0x14, 0xA3, 0x06, 0xBC, 0x19, 0x7C, 0x69, 0xCA, 0xEC, 0xED, 0x32, 0xBD, 0xA0, 0x1B, 0x3A,
    0xAC, 0x0E, 0xF8, 0x9E, 0x4E, 0xD1, 0xBD, 0x75, 0x12, 0x05, 0x13, 0xDD, 0x40, 0xE9, 0xC4, 0x0D, 0xC3, 0xD9, 0x0E, 0x64, 0x65,
    0x8B, 0x5B, 0xE0, 0xC4, 0x19, 0x39, 0xC7, 0x3E, 0x1D, 0xA1, 0xB6, 0x5E, 0x19, 0xAA, 0xCD, 0xD7, 0xBD, 0xF3, 0x7F, 0xB4, 0x79,
    0x33, 0x47, 0x73, 0xF2, 0x96, 0x70, 0xCD, 0x2E, 0x5F, 0x30, 0x66, 0x84, 0x90, 0x18, 0x04, 0x91, 0x78, 0x8E, 0x31, 0x09, 0xD3,
    0xA3, 0x25, 0x2A, 0x8B, 0x65, 0xAE, 0x02, 0x71, 0x63, 0xDA, 0x4C, 0xA1, 0x0D, 0xF8, 0x06, 0x77, 0x49, 0xA2, 0xD9, 0x4E, 0xD7,
    0x30, 0x88, 0xEF, 0x46, 0x65, 0x71, 0x30, 0x96, 0x65, 0x2B, 0xF2, 0x1F, 0x5A, 0xC9, 0x74, 0x1D, 0x78, 0x68, 0x67, 0x37, 0xB9,
    0x83, 0xF4, 0x75, 0x36, 0x71, 0xE2, 0xE0, 0x25, 0x8D, 0x05, 0x3A, 0x5B, 0x93, 0xF2, 0x00, 0xA8, 0x4F, 0x81, 0xA1, 0xCA, 0x76,
    0xAD, 0x8B, 0xF2, 0xBF, 0x67, 0x7F, 0xE5, 0x9C, 0xF8, 0x65, 0x13, 0xF9, 0x7F, 0xB4, 0x0B, 0x70, 0xF0, 0xCB, 0x11, 0x50, 0x34,
    0xA4, 0xB8, 0x9D, 0xA0, 0x53, 0x50, 0xE8, 0x46, 0x7D, 0xA2, 0x3E, 0xDA, 0xE8, 0xC1, 0x1D, 0x37, 0x25, 0xD1, 0x6A, 0x65, 0x54,
    0xC7, 0xFD, 0xA4, 0xFA, 0x5D, 0xB3, 0x21, 0xB2, 0x06, 0x00, 0x86, 0xF2, 0x33, 0x9C, 0x1B, 0xEA, 0xB8, 0xB3, 0xA4, 0x73, 0xE5,
    0x95, 0xB7, 0x60, 0x71, 0xE3, 0xE4, 0x67, 0x51, 0x91, 0x25, 0x56, 0x7A, 0x46, 0xCC, 0x6A, 0x41, 0xB6, 0x44, 0xA5, 0x59, 0xAC,
    0x89, 0x20, 0x3F, 0x9B, 0x6B, 0x81, 0x5F, 0x25, 0x54, 0x55, 0xC9, 0x68, 0x5D, 0xD3, 0x13, 0x86, 0x78, 0xDD, 0x21, 0x80, 0xBF,
    0x0C, 0x23, 0x08, 0xC7, 0x0D, 0x91, 0xC9, 0x5A, 0xCC, 0x16, 0x92, 0x28, 0x12, 0x81, 0xA4, 0x90, 0x2B, 0x88, 0xEB, 0xC8, 0xDE,
    0xA4, 0x1E, 0x8D, 0x21, 0x26, 0x2A, 0x50, 0x5E, 0x1D, 0x67, 0xA5, 0x76, 0x8E, 0x93, 0xD0, 0x2D, 0x3E, 0x9A, 0x89, 0x74, 0x82,
    0x8D, 0x83, 0x18, 0x43, 0x50, 0xA4, 0xCB, 0xD2, 0x35, 0x6B, 0x62, 0xA0, 0x96, 0x29, 0x27, 0x42, 0xA0, 0xB1, 0xF7, 0x4D, 0xB4,
    0x2C, 0x2C, 0x31, 0x8E, 0x1E, 0x61, 0x85, 0xF0, 0x12, 0xFA, 0x24, 0xA3, 0xC9, 0x32, 0x2D, 0xC6, 0x90, 0x52, 0xCA, 0x98, 0x26,
    0x60, 0xC2, 0xAE, 0x70, 0xAE, 0x5C, 0x39, 0x53, 0x2E, 0x17, 0xC5, 0x92, 0x7A, 0x75, 0xB2, 0xF2, 0xA0, 0x4A, 0x45, 0x3F, 0x35,
    0xE7, 0x0C, 0x85, 0x23, 0x74, 0x67, 0x95, 0x75, 0x2D, 0x7D, 0x80, 0x4E, 0x69, 0xD8, 0x96, 0x71, 0x51, 0xC2, 0x81, 0x78, 0xF6,
    0x45, 0x76, 0xD0, 0x55, 0x6F, 0xC2, 0x0E, 0x18, 0x46, 0x41, 0x27, 0x93, 0x07, 0xB9, 0x32, 0x44, 0x53, 0xDB, 0xB0, 0xCE, 0xCD,
    0x16, 0x9D, 0x8A, 0x5C, 0xA8, 0x02, 0xBD, 0xD0, 0x8F, 0x77, 0xEE, 0xCE, 0x74, 0x74, 0xCB, 0x38, 0x1C, 0xB8, 0x0E, 0xB2, 0xDC,
    0x51, 0x4D, 0x63, 0xAA, 0xDA, 0xAF, 0x96, 0x7B, 0x24, 0xDB, 0x08, 0x6A, 0x9A, 0x30, 0x0D, 0xDD, 0x28, 0xA6, 0x53, 0x47, 0x4F,
    0x8A, 0xD6, 0xEA, 0x98, 0xE7, 0xBD, 0xD1, 0x7E, 0x64, 0x9F, 0x64, 0x60, 0x75, 0x76, 0x68, 0xAE, 0x4E, 0x20, 0x26, 0x07, 0x67,
    0x8A, 0x3C, 0xF9, 0x18, 0x82, 0xD0, 0x6B, 0x9A, 0xA1, 0xA7, 0xB5, 0x4E, 0x93, 0x03, 0x11, 0xC0, 0x32, 0x62, 0x2F, 0x83, 0x3F,
    0x4B, 0xC3, 0xC2, 0x94, 0xAB, 0x75, 0x28, 0xB3, 0x4B, 0x05, 0x89, 0x96, 0x82, 0x04, 0x8A, 0x9A, 0x26, 0x66, 0x9B, 0x2D, 0xE4,
    0x72, 0x3B, 0x12, 0x3B, 0x6E, 0x5E, 0xC1, 0x65, 0x72, 0x75, 0x25, 0x0B, 0xDE, 0x9C, 0xD0, 0xF9, 0xD5, 0xA6, 0xC9, 0x83, 0x06,
    0x39, 0x70, 0x01, 0xDA, 0xD4, 0x84, 0xA1, 0x5F, 0x3A, 0xF4, 0x15, 0x76, 0xC1, 0xB9, 0x02, 0x70, 0x9B, 0x4C, 0xC7, 0xC8, 0xE9,
    0x84, 0xD6, 0x21, 0x01, 0x04, 0x3A, 0x69, 0x54, 0xC3, 0xA1, 0xDA, 0x97, 0xB7, 0xD1, 0xDD, 0xB6, 0x00, 0xD0, 0x3E, 0x9F, 0xE4,
    0x2B, 0x6A, 0xB9, 0xF3, 0x02, 0x73, 0x5B, 0x23, 0xFF, 0xBC, 0xE7, 0x02, 0xD5, 0x49, 0x07, 0x2D, 0x1F, 0xD4, 0xA8, 0x9C, 0xB8,
    0x31, 0x61, 0xCD, 0xE7, 0x6F, 0x45, 0x98, 0x2F, 0x40, 0x88, 0x41, 0xB0, 0x49, 0xFA, 0x88, 0x45, 0x85, 0xF1, 0xE2, 0x02, 0x33,
    0x65, 0x6D, 0xE5, 0x8E, 0x45, 0x37, 0xD7, 0x67, 0x4D, 0xEE, 0x14, 0x2A, 0x28, 0x36, 0xBA, 0xD6, 0x58, 0x0A, 0xDB, 0x9F, 0x91,
    0x86, 0x26, 0x84, 0xB4, 0x8F, 0x13, 0x34, 0x97, 0x19, 0x86, 0x0D, 0x1B, 0xB8, 0x83, 0xA5, 0x52, 0x80, 0x36, 0x54, 0x7D, 0x6A,
    0xCE, 0xC1, 0xD4, 0xEB, 0x31, 0xCC, 0x69, 0x15, 0x94, 0x04, 0x1F, 0x10, 0x94, 0x7F, 0x6C, 0x27, 0x90, 0x20, 0x14, 0xC3, 0xFD,
    0x34, 0x28, 0xBE, 0xB0, 0x20, 0x08, 0xC9, 0x66, 0xE6, 0xD8, 0xE9, 0xE5, 0x83, 0xEC, 0xC4, 0xE9, 0xCD, 0xE0, 0x82, 0xF4, 0x09,
    0x29, 0xD9, 0xC5, 0x31, 0x0F, 0x46, 0x9F, 0xBA, 0x8E, 0x1A, 0xF4, 0xDB, 0x01, 0xDD, 0x43, 0x3B, 0x24, 0x2B, 0x4B, 0x2D, 0x39,
    0xC0, 0x0F, 0xB3, 0x64, 0xE7, 0x95, 0x1D, 0x79, 0x09, 0xB0, 0x71, 0xE9, 0xD4, 0x46, 0xF9, 0x5D, 0x69, 0xD3, 0x05, 0xC7, 0x71,
    0x49, 0x22, 0x2D, 0xCB, 0x74, 0x8D, 0x75, 0x04, 0xA6, 0x85, 0xFE, 0xD4, 0x5B, 0xAF, 0x53, 0x8F, 0x31, 0x8C, 0x41, 0x5F, 0xC0,
    0x15, 0xC0, 0x36, 0x2C, 0xA4, 0x62, 0xD7, 0x00, 0x65, 0xD0, 0x85, 0xE8, 0x97, 0xD5, 0x85, 0x6B, 0xCF, 0x8A, 0xDC, 0x98, 0x87,
    0x6C, 0x82, 0x99, 0x8C, 0xEA, 0x10, 0x0F, 0xA7, 0xCD, 0x65, 0xF5, 0x84, 0xAE, 0xEA, 0x52, 0xA6, 0x93, 0x2C, 0xD3, 0xF6, 0x91,
    0xEB, 0x2A, 0x35, 0xA5, 0xF2, 0x4E, 0xA1, 0x66, 0x19, 0xBA, 0x92, 0x76, 0x64, 0x9A, 0x73, 0x41, 0xEE, 0x99, 0x11, 0xBB, 0x91,
    0xF2, 0x1D, 0x7B, 0x72, 0xFD, 0xD1, 0xD4, 0xE4, 0x4C, 0x04, 0xB7, 0x57, 0x5B, 0x42, 0x8C, 0x16, 0x5C, 0xFB, 0x8D, 0x5C, 0x24,
    0xC0, 0x11, 0xEA, 0xDF, 0x64, 0x1C, 0xB5, 0xF2, 0x2D, 0x47, 0xE5, 0x44, 0xFB, 0xA2, 0xA2, 0x09, 0xD5, 0x2A, 0xAF, 0xAF, 0xEC,
    0xC7, 0x4C, 0xF9, 0x41, 0xFC, 0xE1, 0xAE, 0x49, 0x76, 0x15, 0x91, 0x47, 0xEC, 0x17, 0x05, 0xE3, 0xCC, 0xA3, 0xDC, 0x5C, 0x64,
    0xB1, 0xEA, 0x6C, 0x16, 0x2E, 0x7A, 0x96, 0xB0, 0x4B, 0x78, 0xB8, 0x36, 0x8D, 0x84, 0x06, 0xDA, 0xEB, 0xC1, 0x8F, 0x64, 0x9C,
    0x01, 0x64, 0x6A, 0x15, 0x37, 0x3E, 0xEB, 0x80, 0xEA, 0xC1, 0xEE, 0xE9, 0xC6, 0x94, 0x53, 0xB1, 0x4A, 0x5F, 0xC2, 0x74, 0x83,
    0xFD, 0xFE, 0x58, 0x2E, 0x13, 0x20, 0xD0, 0x8E, 0xE9, 0xF6, 0x7B, 0x63, 0x53, 0x68, 0x25, 0x0D, 0xC9, 0x8B, 0x17, 0x5B, 0x1E,
    0x06, 0x70, 0x58, 0x2F, 0x02, 0x08, 0x8B, 0xC2, 0x09, 0x70, 0xDC, 0x9E, 0xBA, 0xE7, 0xCF, 0xCF, 0x50, 0x28, 0x0A, 0x89, 0x11,
    0x05, 0x26, 0xA0, 0xE9, 0xEC, 0xC0, 0x78, 0xF9, 0x86, 0x94, 0x03, 0x9E, 0xB4, 0xDB, 0xB1, 0xD0, 0x9C, 0x28, 0xAB, 0x90, 0xD0,
    0xE4, 0x5B, 0x77, 0x5D, 0xD8, 0xDD, 0xD8, 0x11, 0x54, 0x22, 0xDB, 0x97, 0x64, 0x23, 0x29, 0x94, 0x42, 0x45, 0x64, 0x17, 0x92,
    0x6F, 0xAC, 0x76, 0x4F, 0x36, 0x7E, 0xAC, 0x8E, 0x3C, 0x04, 0xA8, 0x62, 0xE8, 0x10, 0x1E, 0xA2, 0xA1, 0x83, 0x98, 0x06, 0x2C,
    0xE2, 0x67, 0xE5, 0x0D, 0x49, 0x44, 0x84, 0xE7, 0xA2, 0x02, 0x98, 0x33, 0x76, 0x71, 0x37, 0x05, 0xD4, 0x94, 0x15, 0x98, 0x46,
    0xDD, 0x9F, 0x00, 0xC7, 0x63, 0x27, 0x64, 0xDA, 0x4C, 0x75, 0xE3, 0x9A, 0xED, 0xA8, 0x2B, 0xAF, 0x0C, 0x58, 0x84, 0xBB, 0x74,
    0x0B, 0x09, 0x8B, 0x23, 0x13, 0xC8, 0xE5, 0x51, 0xCA, 0x12, 0xF1, 0xCF, 0x15, 0x29, 0x09, 0xB0, 0x0D, 0x1A, 0x18, 0x20, 0x24,
    0x2C, 0x71, 0x3C, 0xE4, 0xD8, 0xAD, 0x6C, 0x07, 0x4E, 0x27, 0x3E, 0xC7, 0x25, 0x3E, 0x34, 0x69, 0xDC, 0x51, 0xE7, 0x68, 0x5A,
    0xFD, 0x21, 0x16, 0x30, 0xFA, 0x0E, 0x9E, 0xAE, 0x1C, 0xD2, 0x01, 0x68, 0x02, 0x1A, 0xA3, 0x06, 0xF4, 0xF8, 0xDF, 0x47, 0xB3,
    0x45, 0x60, 0xC4, 0x75, 0x8E, 0x85, 0xB4, 0xB4, 0x14, 0x20, 0x54, 0x73, 0x9C, 0xB1, 0x47, 0xAE, 0xCC, 0x29, 0xD7, 0xA5, 0x67,
    0x40, 0xDD, 0xCC, 0xAC, 0x9D, 0x1A, 0x3A, 0x05, 0x10, 0x1D, 0x71, 0xC9, 0xD4, 0x4F, 0x17, 0xB9, 0xAB, 0x22, 0x61, 0x68, 0x7B,
    0xC5, 0x59, 0x98, 0x88, 0x4D, 0x3C, 0x84, 0x88, 0x02, 0x03, 0xB3, 0x9A, 0x7E, 0xEF, 0xE3, 0xB3, 0x63, 0x30, 0x05, 0xBC, 0x80,
    0xD2, 0x76, 0x63, 0x89, 0x1A, 0x03, 0x89, 0xD7, 0x5F, 0x43, 0xEC, 0xCF, 0xB2, 0xED, 0xCF, 0xD0, 0xFD, 0x38, 0xB6, 0xF2, 0x68,
    0x0E, 0x2E, 0x3F, 0x59, 0x8C, 0x9E, 0x93, 0xE1, 0x3C, 0xAF, 0x0A, 0x51, 0x4F, 0x8C, 0x2F, 0xB4, 0xDB, 0xAB, 0x1A, 0xA0, 0x2F,
    0xD5, 0x66, 0xD5, 0xBE, 0x73, 0x94, 0xCE, 0x50, 0xD4, 0x10, 0x10, 0xCA, 0x6F, 0x23, 0xB5, 0xA1, 0x6F, 0x29, 0x2A, 0xB1, 0xC5,
    0x1F, 0xEA, 0x61, 0x85, 0x13, 0x69, 0x1C, 0x45, 0x21, 0xFD, 0x7E, 0xF6, 0xAC, 0x6A, 0xCC, 0x1C, 0x4E, 0xAF, 0xEF, 0x0B, 0xBC,
    0x83, 0x72, 0x00, 0xB7, 0x75, 0xD9, 0x8E, 0xF3, 0x18, 0xC5, 0x00, 0xBB, 0x8A, 0x25, 0xD4, 0x4E, 0xC5, 0x1B, 0x02, 0x65, 0x22,
    0x5D, 0x84, 0xDD, 0x9D, 0x27, 0xFC, 0xD8, 0x6C, 0x45, 0xE4, 0xAE, 0xA1, 0x02, 0xD5, 0x09, 0x08, 0x8C, 0x8A, 0xB2, 0x1C, 0xF7,
    0xDB, 0x59, 0xA0, 0x07, 0x22, 0xF8, 0x64, 0x76, 0xEC, 0x3E, 0x43, 0x63, 0x7A, 0x0B, 0x11, 0x46, 0x13, 0xE1, 0x98, 0xDA, 0xC6,
    0xBE, 0xE1, 0xE2, 0x12, 0x0E, 0xA8, 0x18, 0xA6, 0xFB, 0xAA, 0x06, 0xF6, 0x99, 0x08, 0xAB, 0x49, 0xC7, 0xE3, 0x10, 0xAE, 0x83,
    0x1B, 0x39, 0xD8, 0x7B, 0x53, 0x24, 0xD0, 0x9F, 0x62, 0x4D, 0x16, 0x1A, 0xEC, 0xF3, 0x49, 0x8F, 0xBC, 0x4F, 0x94, 0x47, 0xDA,
    0xC9, 0xD5, 0x4A, 0x04, 0xBC, 0x4D, 0xA8, 0xF0, 0x97, 0x12, 0xF1, 0x91, 0x8A, 0x8A, 0xF2, 0x89, 0x31, 0xF7, 0x6D, 0x79, 0x4D,
    0xE4, 0x0A, 0x3F, 0xF0, 0x14, 0xBB, 0x2B, 0xD1, 0x04, 0x0F, 0xCD, 0xCC, 0xC5, 0xB0, 0x4A, 0x93, 0x22, 0xD9, 0x01, 0x92, 0x96,
    0x9E, 0xC8, 0x33, 0x04, 0x64, 0x6D, 0x92, 0x0D, 0x7D, 0x8C, 0xFD, 0xFD, 0x51, 0x11, 0xCA, 0x9C, 0xBD, 0x36, 0x81, 0x20, 0xE9,
    0xE4, 0xE1, 0xFF, 0x1F, 0xC5, 0xBE, 0xFE, 0x52, 0x94, 0x6B, 0x34, 0x4F, 0xB5, 0x70, 0x6E, 0x1B, 0x90, 0xEC, 0x8E, 0x8D, 0x13,
    0x68, 0x32, 0xD1, 0x8A, 0xEB, 0x7B, 0x04, 0x87, 0xC7, 0x59, 0x69, 0xE3, 0xC8, 0xBA, 0x74, 0xD0, 0x3B, 0x48, 0xC0, 0x06, 0x01,
    0x99, 0xF4, 0x88, 0x3D, 0x48, 0xD1, 0xB0, 0x4E, 0xD8, 0xDB, 0xF3, 0xE9, 0x83, 0x10, 0x94, 0x11, 0xE8, 0x42, 0x4A, 0x32, 0xBE,
    0xFA, 0x91, 0xEC, 0x55, 0x4B, 0xC1, 0x4F, 0x40, 0x97, 0xD7, 0x16, 0xD0, 0xCB, 0xA0, 0x18, 0x9C, 0x17, 0x23, 0xF8, 0x86, 0xEB,
    0xE1, 0xC2, 0x38, 0x03, 0xDB, 0x2E, 0x05, 0x2A, 0x51, 0xDD, 0x9F, 0xAD, 0x8E, 0x7A, 0x7D, 0x91, 0x0B, 0xCB, 0x38, 0x5E, 0x82,
    0xFC, 0xF2, 0x7E, 0xE9, 0x0C, 0x29, 0x6D, 0xD3, 0xEB, 0x95, 0x38, 0x17, 0xE0, 0x0F, 0x02, 0x27, 0xFF, 0xEC, 0x04, 0x4F, 0x3D,
    0x18, 0x09, 0x06, 0xF5, 0xDF, 0xDF, 0x90, 0xB7, 0x68, 0xC6, 0xD2, 0x95, 0x28, 0x33, 0xC5, 0x00, 0xEA, 0x0C, 0x18, 0x4C, 0x40,
    0x1E, 0x12, 0x06, 0x11, 0xA2, 0xC9, 0x52, 0xC4, 0xAA, 0xF6, 0xB1, 0x02, 0x44, 0x0F, 0x49, 0x1C, 0x10, 0x2A, 0x3D, 0xAC, 0x98,
    0x3B, 0x1C, 0x3A, 0xC8, 0xCE, 0x1F, 0xDD, 0x4B, 0xAB, 0x8E, 0x3E, 0x1C, 0x08, 0x7C, 0x38, 0xF4, 0x75, 0x5F, 0xC6, 0x11, 0x61,
    0x52, 0xFC, 0xDC, 0x3C, 0x43, 0xFF, 0x00, 0x94, 0x58, 0x43, 0x7F, 0xE6, 0xB8, 0x1B, 0x93, 0xB3, 0x73, 0xA7, 0x01, 0x19, 0x0D,
    0x43, 0xB2, 0x36, 0x45, 0xAA, 0x4A, 0x09, 0x9C, 0xCA, 0xE5, 0x38, 0xDD, 0x80, 0xF8, 0xAB, 0x3C, 0xEB, 0x30, 0x30, 0xA8, 0x21,
    0x14, 0x72, 0x0A, 0x9C, 0xB6, 0x70, 0x76, 0x18, 0x51, 0xEE, 0x89, 0x9D, 0x8F, 0xC9, 0xD9, 0xD1, 0x9B, 0xBA, 0xA3, 0xF4, 0xEE,
    0x8F, 0x76, 0x95, 0x08, 0x79, 0x36, 0x50, 0xD8, 0xD7, 0xB1, 0xDF, 0x6B, 0x06, 0xAF, 0x48, 0xB9, 0xF9, 0x36, 0x99, 0x0A, 0xF6,
    0x6A, 0x40, 0x6B, 0x4E, 0x24, 0x20, 0xDC, 0x1D, 0xC7, 0x6E, 0xB7, 0x68, 0x02, 0x6B, 0x84, 0x6A, 0xFC, 0x7C, 0x68, 0x09, 0xAC,
    0x2F, 0x6C, 0xB1, 0xC0, 0x88, 0x17, 0x81, 0x31, 0xDC, 0xF1, 0x1C, 0xFF, 0xE5, 0x14, 0x77, 0xEC, 0xA7, 0xE8, 0x74, 0xE3, 0x41,
    0x2E, 0x2A, 0x77, 0xCF, 0xA5, 0x04, 0x5A, 0xD6, 0x4D, 0x9D, 0x9F, 0xAC, 0x32, 0x4C, 0xA7, 0x66, 0xBE, 0x87, 0x36, 0xC6, 0x18,
    0x6A, 0x4D, 0xC1, 0x4D, 0x75, 0x0A, 0x38, 0x47, 0x43, 0x83, 0x2D, 0x1D, 0xB3, 0x46, 0x20, 0x2F, 0x84, 0xE7, 0xEC, 0x09, 0xE4,
    0xBE, 0x43, 0x71, 0xEF, 0x6F, 0xE1, 0xA9, 0x01, 0xE7, 0x8B, 0x30, 0x0B, 0x06, 0x72, 0xEB, 0xE3, 0xF1, 0x9D, 0xDF, 0x14, 0xB2,
    0x9D, 0x83, 0x84, 0x79, 0xCA, 0x5F, 0x86, 0x84, 0x2F, 0xA3, 0xE8, 0x21, 0xE0, 0x58, 0x83, 0x32, 0x46, 0x71, 0x1E, 0x33, 0xB8,
    0xEF, 0xB5, 0xB2, 0x28, 0x26, 0x57, 0xC1, 0xA7, 0x2A, 0x38, 0xEF, 0xC0, 0x74, 0x58, 0xB2, 0xE2, 0xA1, 0xBA, 0xD3, 0x83, 0x52,
    0x40, 0x8B, 0x51, 0x76, 0x33, 0x5B, 0xD3, 0x64, 0x24, 0x27, 0x16, 0xEB, 0xC6, 0xEC, 0x87, 0x63, 0x7B, 0x13, 0x06, 0x66, 0x9A,
    0x0C, 0xE7, 0x70, 0xA6, 0x80, 0x3D, 0xC7, 0x93, 0x87, 0x0D, 0x89, 0x90, 0x35, 0x9C, 0x44, 0x81, 0xCC, 0x24, 0x75, 0xB1, 0x41,
    0x73, 0x2A, 0xD6, 0xDF, 0x83, 0x03, 0x79, 0xDD, 0xE0, 0x78, 0x66, 0xEE, 0x24, 0x2E, 0xA6, 0x44, 0xF4, 0xE4, 0x95, 0xD0, 0x2C,
    0x02, 0x11, 0x5E, 0x41, 0xE1, 0x83, 0x82, 0xE5, 0x7B, 0xC6, 0xA9, 0x91, 0x85, 0x57, 0xDA, 0x9E, 0x20, 0x31, 0x52, 0xFF, 0x51,
    0x34, 0xEB, 0x48, 0x82, 0xCE, 0xD7, 0xB4, 0x4C, 0x0F, 0x12, 0x4D, 0x01, 0xAE, 0x59, 0x99, 0x8A, 0x18, 0xFE, 0xB1, 0x77, 0x4F,
    0xC6, 0x6A, 0xE7, 0x80, 0x4D, 0xFC, 0x10, 0x34, 0x0A, 0x24, 0x12, 0x68, 0xC7, 0x5C, 0x73, 0x60, 0x7E, 0x02, 0x9B, 0x0C, 0xF6,
    0x42, 0x1A, 0x23, 0xBA, 0x15, 0x0A, 0xAF, 0x4E, 0x4A, 0x9F, 0xFC, 0x30, 0x32, 0x89, 0x5B, 0x7E, 0x08, 0xF3, 0x3E, 0x1C, 0xB6,
    0x77, 0xBA, 0x08, 0xA7, 0x5D, 0x18, 0x68, 0x27, 0xA3, 0x8D, 0x53, 0x0C, 0x57, 0xA2, 0x8A, 0xAC, 0x63, 0xDE, 0x70, 0xA2, 0xF1,
    0x16, 0x6D, 0x59, 0x89, 0xB4, 0x0B, 0xEF, 0xF1, 0x85, 0x11, 0x9A, 0x76, 0x1F, 0x80, 0xD6, 0x77, 0x65, 0x24, 0x30, 0x8B, 0x2B,
    0xBB, 0xA0, 0xAB, 0x32, 0x86, 0x8D, 0x26, 0xC1, 0xA3, 0xE6, 0xDE, 0xB4, 0x49, 0xF5, 0xD5, 0xA1, 0x16, 0x8D, 0x6C, 0x71, 0xDA,
    0xD5, 0x1F, 0xD4, 0x65, 0xEC, 0xC3, 0x63, 0xFA, 0xFD, 0xB8, 0xAE, 0x6B, 0x22, 0x97, 0xDF, 0xCF, 0x03, 0x09, 0x9D, 0x81, 0x4B,
    0xF6, 0x01, 0xE3, 0x83, 0x57, 0xB3, 0xF1, 0xDE, 0x09, 0x5E, 0xDD, 0x49, 0xCA, 0x77, 0x9C, 0x46, 0x20, 0xBA, 0x01, 0x6A, 0x7A,
    0xF9, 0xCC, 0x98, 0xC2, 0x14, 0xC6, 0x69, 0x55, 0xE1, 0xAE, 0xD3, 0xCE, 0x5F, 0xCF, 0xEF, 0x50, 0xE5, 0xA3, 0x25, 0xC0, 0xD9,
    0xDE, 0x42, 0x00, 0x10, 0x20, 0xC3, 0x30, 0xF6, 0x38, 0x7D, 0x85, 0x8A, 0xA4, 0x62, 0x79, 0xAE, 0xA2, 0x54, 0x32, 0xF3, 0xC2,
    0xF1, 0x6D, 0x96, 0x39, 0x42, 0xC6, 0xD3, 0xDC, 0xD0, 0x61, 0x5A, 0xD3, 0xC4, 0x5E, 0x70, 0x2E, 0x89, 0xF7, 0xFA, 0x58, 0x5E,
    0x4A, 0xF8, 0x12, 0x29, 0x92, 0x8E, 0x06, 0xAD, 0xA8, 0x30, 0x73, 0xA1, 0x20, 0xE6, 0x3E, 0x21, 0xFA, 0x72, 0xED, 0x6E, 0x00,
    0x1F, 0x3C, 0xE3, 0x92, 0xF8, 0x44, 0x12, 0xF8, 0x48, 0x51, 0xE6, 0x86, 0x2B, 0x9D, 0x49, 0xD2, 0x98, 0x5C, 0x86, 0x29, 0x44,
    0x14, 0x8E, 0x32, 0x66, 0xAC, 0xF7, 0xA1, 0x66, 0xC8, 0x11, 0x4D, 0xB7, 0x8E, 0xAF, 0xB9, 0xB3, 0x1B, 0x79, 0xFD, 0xF5, 0x5D,
    0xC1, 0xF3, 0xC6, 0x98, 0x0F, 0x18, 0xC3, 0x60, 0xFA, 0x54, 0xDA, 0xEA, 0xF8, 0x5B, 0xA6, 0x3D, 0x39, 0xFD, 0xF4, 0xF9, 0x6F,
    0x40, 0xED, 0x99, 0x7C, 0x80, 0x03, 0x41, 0xE1, 0xC5, 0x7C, 0x46, 0xD0, 0xF0, 0x0D, 0x23, 0x34, 0x85, 0x30, 0x88, 0x28, 0x42,
    0xF3, 0xA2, 0x70, 0xDC, 0x68, 0x0A, 0xD0, 0x84, 0x11, 0x08, 0x07, 0x89, 0x0E, 0x85, 0xD5, 0x79, 0x8B, 0x2E, 0x3E, 0xCF, 0x89,
    0x32, 0xD1, 0x2E, 0xE3, 0x2E, 0xF0, 0xA1, 0x7E, 0x9D, 0x20, 0xF1, 0x96, 0x8A, 0x85, 0x52, 0x50, 0x69, 0xBD, 0x0C, 0xC6, 0xA7,
    0x4D, 0x8A, 0x38, 0x52, 0xD1, 0xCD, 0x08, 0x85, 0xEB, 0xF9, 0x51, 0xBC, 0x53, 0x20, 0x44, 0x87, 0xFA, 0x97, 0x61, 0xCE, 0xD7,
    0xA3, 0xE5, 0xCE, 0x0B, 0x09, 0x56, 0xB7, 0x4F, 0xA7, 0x17, 0xFC, 0x84, 0x04, 0xB5, 0xDF, 0xF8, 0x2A, 0x7C, 0xF4, 0x13, 0x25,
    0x1D, 0xAA, 0xBF, 0x7C, 0x92, 0x22, 0xDC, 0x61, 0x80, 0x21, 0xE2, 0x2B, 0x92, 0xFC, 0xFE, 0x4F, 0x7A, 0x2F, 0x35, 0x99, 0xC0,
    0x5F, 0x14, 0x10, 0xCB, 0xE4, 0x6F, 0x59, 0x8F, 0xF7, 0x38, 0xAE, 0x1E, 0x0B, 0x0D, 0x22, 0xAF, 0x53, 0x00, 0x00, 0xEC, 0xE5,
    0xD2, 0x0B, 0x45, 0x8D, 0x01, 0x00, 0x0D, 0x7D, 0x06, 0x00, 0xDF, 0x94, 0x01, 0x00, 0xB4, 0x84, 0x05, 0x00, 0xB2, 0xE8, 0x9B,
    0x00, 0x75, 0xBA, 0x07, 0x00, 0x3D, 0xD5, 0xAD, 0x00, 0xB3, 0xBF, 0x4E, 0x00, 0xFB, 0xD9, 0x51, 0x96, 0xCB, 0x6B, 0x7B, 0x89,
    0x89, 0xF3, 0x57, 0x00, 0xE7, 0x4D, 0x11, 0x00, 0x87, 0x99, 0x06, 0x00, 0x64, 0x3F, 0x8B, 0x05, 0xA8, 0x3E, 0x00, 0x00, 0xCA,
    0x1A, 0x00, 0x00, 0x46, 0x1B, 0xFA, 0x15, 0xE0, 0x17, 0x00, 0x00, 0x15, 0x50, 0x79, 0x00, 0x56, 0xCD, 0x2C, 0x00, 0xA9, 0xD8,
    0x17, 0x00, 0x97, 0x79, 0xBB, 0x43, 0x6A, 0xC3, 0x2F, 0x99, 0xE0, 0x3C, 0x00, 0x00, 0x8A, 0x1A, 0x00, 0x00, 0x02, 0x15, 0x00,
    0x00, 0x27, 0x74, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x04, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static uint8_t decompressedData[DECOMPRESSED_SIZE] = {
    0x4C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x73, 0x69, 0x74,
    0x20, 0x61, 0x6D, 0x65, 0x74, 0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x61, 0x64,
    0x69, 0x70, 0x69, 0x73, 0x63, 0x69, 0x6E, 0x67, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x6D,
    0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2C, 0x20, 0x74,
    0x65, 0x6D, 0x70, 0x75, 0x73, 0x20, 0x66, 0x69, 0x6E, 0x69, 0x62, 0x75, 0x73, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x20, 0x63,
    0x75, 0x72, 0x73, 0x75, 0x73, 0x20, 0x69, 0x64, 0x2E, 0x20, 0x4D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x70, 0x75, 0x6C, 0x76,
    0x69, 0x6E, 0x61, 0x72, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x6E, 0x69, 0x73, 0x6C, 0x20, 0x76,
    0x65, 0x6C, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x2E, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20, 0x64,
    0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x20, 0x65, 0x75,
    0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x2E, 0x20, 0x45, 0x74, 0x69, 0x61,
    0x6D, 0x20, 0x69, 0x64, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x65, 0x72, 0x61, 0x74, 0x2E, 0x20, 0x4E, 0x75, 0x6C,
    0x6C, 0x61, 0x20, 0x69, 0x6E, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x65, 0x72, 0x61, 0x74,
    0x2E, 0x20, 0x49, 0x6E, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x65, 0x72, 0x61, 0x74, 0x20, 0x64, 0x69,
    0x61, 0x6D, 0x2E, 0x20, 0x51, 0x75, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x64, 0x61, 0x70,
    0x69, 0x62, 0x75, 0x73, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x2E, 0x20, 0x51, 0x75, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x66,
    0x65, 0x6C, 0x69, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x2C, 0x20, 0x65, 0x6C, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20,
    0x6E, 0x6F, 0x6E, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x2C, 0x20, 0x70,
    0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x6C, 0x65,
    0x63, 0x74, 0x75, 0x73, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x6D, 0x61, 0x78, 0x69,
    0x6D, 0x75, 0x73, 0x20, 0x6C, 0x65, 0x6F, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65,
    0x20, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74,
    0x69, 0x71, 0x75, 0x65, 0x20, 0x73, 0x65, 0x6E, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6E, 0x65, 0x74, 0x75,
    0x73, 0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x66, 0x61, 0x6D, 0x65, 0x73, 0x20,
    0x61, 0x63, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x2E, 0x20, 0x4E, 0x75,
    0x6C, 0x6C, 0x61, 0x6D, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61,
    0x64, 0x61, 0x20, 0x61, 0x72, 0x63, 0x75, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65,
    0x78, 0x2C, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x69, 0x70, 0x73,
    0x75, 0x6D, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69, 0x63, 0x69, 0x74, 0x75, 0x64, 0x69, 0x6E, 0x2C, 0x20, 0x70, 0x6F, 0x72, 0x74,
    0x61, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x71, 0x75, 0x61, 0x74, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x2E, 0x20, 0x44,
    0x6F, 0x6E, 0x65, 0x63, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x6E, 0x6F, 0x6E, 0x20,
    0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F, 0x64, 0x6F, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x56,
    0x69, 0x76, 0x61, 0x6D, 0x75, 0x73, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x6C, 0x61, 0x63, 0x69, 0x6E,
    0x69, 0x61, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x2E, 0x20, 0x50, 0x72, 0x6F, 0x69, 0x6E, 0x20, 0x75, 0x74,
    0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x2E, 0x20, 0x56, 0x65, 0x73,
    0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x6D, 0x65, 0x74, 0x75,
    0x73, 0x20, 0x65, 0x72, 0x61, 0x74, 0x2C, 0x20, 0x69, 0x64, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x65,
    0x6E, 0x69, 0x6D, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69, 0x63, 0x69, 0x74, 0x75, 0x64, 0x69, 0x6E, 0x20, 0x69, 0x64, 0x2E, 0x20,
    0x4E, 0x61, 0x6D, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20,
    0x61, 0x74, 0x20, 0x6D, 0x61, 0x78, 0x69, 0x6D, 0x75, 0x73, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x2E,
    0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x20, 0x6D, 0x61, 0x78, 0x69, 0x6D, 0x75, 0x73, 0x20, 0x6D, 0x65, 0x74, 0x75, 0x73,
    0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x2C, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73,
    0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x20, 0x6E, 0x6F, 0x6E, 0x2E,
    0x20, 0x50, 0x72, 0x61, 0x65, 0x73, 0x65, 0x6E, 0x74, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69, 0x63, 0x69, 0x74, 0x75, 0x64, 0x69,
    0x6E, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75, 0x72, 0x20, 0x6D, 0x69, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x73, 0x63,
    0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20, 0x74, 0x72, 0x69,
    0x73, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20, 0x61, 0x74, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x75, 0x74, 0x20, 0x63, 0x6F, 0x6E,
    0x67, 0x75, 0x65, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x2E, 0x20,
    0x56, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x70, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71,
    0x75, 0x65, 0x20, 0x64, 0x69, 0x61, 0x6D, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x76, 0x65, 0x6E, 0x65, 0x6E, 0x61, 0x74, 0x69,
    0x73, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x49, 0x6E, 0x20, 0x73, 0x65,
    0x6D, 0x70, 0x65, 0x72, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x6D, 0x65, 0x74,
    0x75, 0x73, 0x20, 0x70, 0x75, 0x6C, 0x76, 0x69, 0x6E, 0x61, 0x72, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x2E, 0x20,
    0x49, 0x6E, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x20, 0x64, 0x75, 0x69,
    0x20, 0x65, 0x74, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x2C, 0x20, 0x69,
    0x6E, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x76, 0x75, 0x6C, 0x70, 0x75, 0x74, 0x61,
    0x74, 0x65, 0x2E, 0x20, 0x44, 0x75, 0x69, 0x73, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x6C,
    0x69, 0x62, 0x65, 0x72, 0x6F, 0x20, 0x65, 0x75, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x72, 0x61, 0x74, 0x2E, 0x20, 0x4E, 0x75,
    0x6C, 0x6C, 0x61, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x6C,
    0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x65, 0x75, 0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69,
    0x62, 0x75, 0x73, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x61, 0x75, 0x63,
    0x74, 0x6F, 0x72, 0x2C, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x65, 0x75, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69,
    0x73, 0x71, 0x75, 0x65, 0x20, 0x66, 0x72, 0x69, 0x6E, 0x67, 0x69, 0x6C, 0x6C, 0x61, 0x2C, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72,
    0x6F, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x6E, 0x75,
    0x6C, 0x6C, 0x61, 0x2C, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74,
    0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x65, 0x73, 0x74, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x2E, 0x20,
    0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x20, 0x6F, 0x72, 0x6E, 0x61, 0x72, 0x65, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69,
    0x73, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x2C, 0x20, 0x61, 0x63, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x20,
    0x65, 0x72, 0x6F, 0x73, 0x2E, 0x20, 0x43, 0x72, 0x61, 0x73, 0x20, 0x61, 0x74, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x69,
    0x6E, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x63, 0x75, 0x72, 0x73, 0x75, 0x73, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75,
    0x6C, 0x75, 0x6D, 0x2E, 0x20, 0x50, 0x68, 0x61, 0x73, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x20, 0x73, 0x75, 0x73, 0x63, 0x69, 0x70,
    0x69, 0x74, 0x2C, 0x20, 0x74, 0x6F, 0x72, 0x74, 0x6F, 0x72, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x75,
    0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72, 0x20, 0x73, 0x75, 0x73, 0x63, 0x69, 0x70, 0x69, 0x74, 0x2C, 0x20,
    0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x70, 0x68, 0x61, 0x72, 0x65, 0x74, 0x72, 0x61, 0x20,
    0x75, 0x72, 0x6E, 0x61, 0x2C, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C, 0x6C, 0x69, 0x73, 0x20, 0x61,
    0x72, 0x63, 0x75, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x6C,
    0x65, 0x6F, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x6C, 0x65, 0x6F, 0x20,
    0x6F, 0x72, 0x63, 0x69, 0x2C, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x6E,
    0x69, 0x62, 0x68, 0x20, 0x76, 0x75, 0x6C, 0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20, 0x61, 0x63, 0x2E, 0x20, 0x50, 0x65, 0x6C,
    0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x72, 0x75, 0x74, 0x72, 0x75, 0x6D, 0x20, 0x65, 0x67, 0x65, 0x73,
    0x74, 0x61, 0x73, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x2C, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20,
    0x65, 0x75, 0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x70, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65,
    0x73, 0x71, 0x75, 0x65, 0x20, 0x69, 0x64, 0x2E, 0x20, 0x45, 0x74, 0x69, 0x61, 0x6D, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69, 0x62,
    0x75, 0x73, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x20,
    0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x20, 0x63, 0x6F, 0x6E, 0x67, 0x75, 0x65, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x44, 0x75,
    0x69, 0x73, 0x20, 0x6D, 0x65, 0x74, 0x75, 0x73, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2C, 0x20, 0x66, 0x69, 0x6E, 0x69, 0x62,
    0x75, 0x73, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6F, 0x64, 0x69, 0x6F, 0x20, 0x71, 0x75, 0x69, 0x73, 0x2C, 0x20, 0x75, 0x6C,
    0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2E,
    0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x61, 0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x20, 0x6D, 0x6F, 0x6C, 0x6C, 0x69,
    0x73, 0x2C, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x69, 0x64, 0x2C, 0x20,
    0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x61, 0x6E, 0x74, 0x65, 0x2E, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E,
    0x61, 0x73, 0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x20, 0x65, 0x6E,
    0x69, 0x6D, 0x2C, 0x20, 0x61, 0x74, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x61, 0x72, 0x63, 0x75, 0x20,
    0x76, 0x69, 0x76, 0x65, 0x72, 0x72, 0x61, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x2E, 0x20, 0x51, 0x75, 0x69, 0x73, 0x71, 0x75,
    0x65, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x6D, 0x65, 0x74, 0x75, 0x73, 0x20, 0x75, 0x74, 0x20, 0x6E, 0x75,
    0x6C, 0x6C, 0x61, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x2C, 0x20, 0x75, 0x74, 0x20, 0x66,
    0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x65, 0x73, 0x74, 0x20, 0x65, 0x6C, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x75,
    0x6D, 0x2E, 0x20, 0x4F, 0x72, 0x63, 0x69, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x6E, 0x61, 0x74, 0x6F, 0x71, 0x75,
    0x65, 0x20, 0x70, 0x65, 0x6E, 0x61, 0x74, 0x69, 0x62, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x69, 0x73,
    0x20, 0x64, 0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x69, 0x65, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x6E, 0x74, 0x65,
    0x73, 0x2C, 0x20, 0x6E, 0x61, 0x73, 0x63, 0x65, 0x74, 0x75, 0x72, 0x20, 0x72, 0x69, 0x64, 0x69, 0x63, 0x75, 0x6C, 0x75, 0x73,
    0x20, 0x6D, 0x75, 0x73, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x68, 0x61,
    0x62, 0x69, 0x74, 0x61, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69, 0x71, 0x75,
    0x65, 0x20, 0x73, 0x65, 0x6E, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6E, 0x65, 0x74, 0x75, 0x73, 0x20, 0x65,
    0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x66, 0x61, 0x6D, 0x65, 0x73, 0x20, 0x61, 0x63, 0x20,
    0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65,
    0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x73, 0x65, 0x64, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x20, 0x6E, 0x75, 0x6C,
    0x6C, 0x61, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x67, 0x72, 0x61, 0x76, 0x69, 0x64, 0x61, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75,
    0x73, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x70, 0x75,
    0x6C, 0x76, 0x69, 0x6E, 0x61, 0x72, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x61, 0x74, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73,
    0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x4E, 0x61, 0x6D, 0x20, 0x64, 0x75, 0x69, 0x20, 0x73,
    0x61, 0x70, 0x69, 0x65, 0x6E, 0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x67, 0x75, 0x65, 0x20, 0x65, 0x75, 0x20, 0x76, 0x65, 0x6C, 0x69,
    0x74, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x2C, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63, 0x75, 0x6C, 0x61, 0x20, 0x62, 0x69,
    0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x62, 0x6C, 0x61,
    0x6E, 0x64, 0x69, 0x74, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x20, 0x70, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73,
    0x71, 0x75, 0x65, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x2E,
    0x20, 0x4E, 0x61, 0x6D, 0x20, 0x6C, 0x61, 0x6F, 0x72, 0x65, 0x65, 0x74, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69,
    0x73, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6C, 0x61, 0x63, 0x69, 0x6E, 0x69, 0x61, 0x2E,
    0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x65, 0x72, 0x61, 0x74,
    0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x20, 0x70, 0x75, 0x6C, 0x76, 0x69, 0x6E, 0x61, 0x72, 0x2C, 0x20,
    0x73, 0x65, 0x64, 0x20, 0x69, 0x61, 0x63, 0x75, 0x6C, 0x69, 0x73, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69,
    0x64, 0x75, 0x6E, 0x74, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x6C, 0x61, 0x63,
    0x75, 0x73, 0x2C, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x61, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62,
    0x75, 0x73, 0x20, 0x65, 0x74, 0x2C, 0x20, 0x66, 0x69, 0x6E, 0x69, 0x62, 0x75, 0x73, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x75, 0x72,
    0x6E, 0x61, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x75, 0x74, 0x20, 0x69, 0x6E,
    0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x6E, 0x65,
    0x63, 0x20, 0x6D, 0x69, 0x20, 0x66, 0x69, 0x6E, 0x69, 0x62, 0x75, 0x73, 0x2C, 0x20, 0x67, 0x72, 0x61, 0x76, 0x69, 0x64, 0x61,
    0x20, 0x6D, 0x65, 0x74, 0x75, 0x73, 0x20, 0x69, 0x6E, 0x2C, 0x20, 0x65, 0x75, 0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x69, 0x70,
    0x73, 0x75, 0x6D, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x61, 0x74, 0x20,
    0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x2E, 0x20, 0x56, 0x69, 0x76, 0x61, 0x6D, 0x75, 0x73,
    0x20, 0x6F, 0x72, 0x6E, 0x61, 0x72, 0x65, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x6D, 0x61, 0x75, 0x72, 0x69,
    0x73, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63,
    0x65, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x2E, 0x0D, 0x0A, 0x0D,
    0x0A, 0x55, 0x74, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D,
    0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C, 0x6C, 0x69, 0x73,
    0x20, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x76, 0x75, 0x6C, 0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20,
    0x6D, 0x61, 0x67, 0x6E, 0x61, 0x20, 0x61, 0x74, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E,
    0x64, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x2E, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20,
    0x6E, 0x65, 0x71, 0x75, 0x65, 0x20, 0x6F, 0x64, 0x69, 0x6F, 0x2C, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x20,
    0x65, 0x74, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x65, 0x74, 0x2C, 0x20, 0x6F, 0x72, 0x6E, 0x61, 0x72,
    0x65, 0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x2E, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x70,
    0x6C, 0x61, 0x63, 0x65, 0x72, 0x61, 0x74, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74,
    0x61, 0x73, 0x2E, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x74,
    0x65, 0x6D, 0x70, 0x75, 0x73, 0x20, 0x64, 0x75, 0x69, 0x2C, 0x20, 0x73, 0x65, 0x64, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62,
    0x75, 0x6C, 0x75, 0x6D, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x61, 0x2E,
    0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x20,
    0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x2C, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x64,
    0x75, 0x69, 0x20, 0x65, 0x6C, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x6E, 0x6F, 0x6E, 0x2E, 0x20, 0x4E, 0x75, 0x6C,
    0x6C, 0x61, 0x20, 0x73, 0x65, 0x6D, 0x70, 0x65, 0x72, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x20, 0x76,
    0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73,
    0x65, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x6D, 0x69, 0x2C, 0x20, 0x65, 0x75, 0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x65,
    0x75, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x65, 0x75, 0x2C, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x70,
    0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x2E, 0x20, 0x4D, 0x61, 0x75, 0x72, 0x69, 0x73,
    0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x6E,
    0x69, 0x73, 0x6C, 0x2C, 0x20, 0x73, 0x65, 0x64, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x64, 0x6F,
    0x6C, 0x6F, 0x72, 0x20, 0x65, 0x75, 0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69, 0x6D, 0x65, 0x6E, 0x74,
    0x75, 0x6D, 0x2E, 0x20, 0x50, 0x68, 0x61, 0x73, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x65, 0x72, 0x61,
    0x74, 0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x64,
    0x75, 0x69, 0x20, 0x69, 0x6E, 0x2C, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75, 0x72, 0x20, 0x74, 0x69, 0x6E, 0x63,
    0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x6E, 0x69, 0x73, 0x6C, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73,
    0x71, 0x75, 0x65, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x2C, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x6E, 0x6F, 0x6E,
    0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x2C, 0x20, 0x74,
    0x65, 0x6C, 0x6C, 0x75, 0x73, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72,
    0x20, 0x6F, 0x64, 0x69, 0x6F, 0x2C, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x69, 0x70, 0x73,
    0x75, 0x6D, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x20, 0x65, 0x75, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x2E, 0x20, 0x43, 0x75, 0x72,
    0x61, 0x62, 0x69, 0x74, 0x75, 0x72, 0x20, 0x6F, 0x72, 0x6E, 0x61, 0x72, 0x65, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x61,
    0x63, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x6D, 0x61, 0x6C,
    0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20,
    0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69,
    0x71, 0x75, 0x65, 0x20, 0x73, 0x65, 0x6E, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6E, 0x65, 0x74, 0x75, 0x73,
    0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x66, 0x61, 0x6D, 0x65, 0x73, 0x20, 0x61,
    0x63, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x2E, 0x20, 0x46, 0x75, 0x73,
    0x63, 0x65, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x65, 0x73, 0x74, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x6D,
    0x65, 0x74, 0x75, 0x73, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D,
    0x2E, 0x20, 0x43, 0x75, 0x72, 0x61, 0x62, 0x69, 0x74, 0x75, 0x72, 0x20, 0x65, 0x74, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69,
    0x74, 0x75, 0x72, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x61, 0x75,
    0x67, 0x75, 0x65, 0x20, 0x65, 0x6E, 0x69, 0x6D, 0x2C, 0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D,
    0x20, 0x65, 0x74, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x73, 0x65, 0x64, 0x2C, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73,
    0x69, 0x6D, 0x20, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72, 0x20, 0x65, 0x73, 0x74, 0x2E, 0x20, 0x4D,
    0x6F, 0x72, 0x62, 0x69, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x64, 0x75, 0x69, 0x2C, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69,
    0x63, 0x69, 0x74, 0x75, 0x64, 0x69, 0x6E, 0x20, 0x66, 0x69, 0x6E, 0x69, 0x62, 0x75, 0x73, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x61,
    0x20, 0x73, 0x65, 0x64, 0x2C, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x61, 0x74, 0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C,
    0x61, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x6E, 0x69, 0x62, 0x68, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x2C, 0x20, 0x61,
    0x6C, 0x69, 0x71, 0x75, 0x65, 0x74, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x61,
    0x74, 0x2C, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x70, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73,
    0x71, 0x75, 0x65, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x65, 0x75, 0x20, 0x6C, 0x61,
    0x63, 0x75, 0x73, 0x20, 0x6D, 0x61, 0x74, 0x74, 0x69, 0x73, 0x2C, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x20, 0x61, 0x75, 0x67,
    0x75, 0x65, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x2C, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x6E, 0x65,
    0x71, 0x75, 0x65, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x74, 0x72, 0x69,
    0x73, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20, 0x73, 0x6F, 0x64, 0x61, 0x6C, 0x65, 0x73, 0x20, 0x6D, 0x69, 0x20, 0x73, 0x69, 0x74,
    0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x70, 0x6F, 0x72,
    0x74, 0x74, 0x69, 0x74, 0x6F, 0x72, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x2E, 0x20, 0x4E,
    0x61, 0x6D, 0x20, 0x64, 0x69, 0x61, 0x6D, 0x20, 0x6D, 0x69, 0x2C, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74,
    0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65, 0x74, 0x2C, 0x20, 0x64, 0x69, 0x67, 0x6E,
    0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x6A, 0x75, 0x73, 0x74,
    0x6F, 0x2E, 0x20, 0x50, 0x72, 0x61, 0x65, 0x73, 0x65, 0x6E, 0x74, 0x20, 0x61, 0x74, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20,
    0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x61, 0x74, 0x20, 0x6C, 0x65, 0x6F, 0x20, 0x6D,
    0x6F, 0x6C, 0x6C, 0x69, 0x73, 0x2C, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61,
    0x20, 0x65, 0x67, 0x65, 0x74, 0x2C, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x64, 0x69, 0x61, 0x6D,
    0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x2C, 0x20, 0x71, 0x75,
    0x61, 0x6D, 0x20, 0x65, 0x74, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x76, 0x69, 0x76, 0x65, 0x72, 0x72, 0x61, 0x2C,
    0x20, 0x6D, 0x65, 0x74, 0x75, 0x73, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x6D, 0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65,
    0x20, 0x65, 0x72, 0x61, 0x74, 0x2C, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20,
    0x6D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73,
    0x20, 0x6E, 0x75, 0x6E, 0x63, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x70, 0x6F,
    0x74, 0x65, 0x6E, 0x74, 0x69, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x75, 0x74, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E,
    0x64, 0x75, 0x6D, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x65, 0x75, 0x69, 0x73, 0x6D,
    0x6F, 0x64, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x6D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20,
    0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x2E, 0x20, 0x4D, 0x61,
    0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x2C, 0x20, 0x6D,
    0x61, 0x73, 0x73, 0x61, 0x20, 0x69, 0x6E, 0x20, 0x72, 0x75, 0x74, 0x72, 0x75, 0x6D, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63, 0x75,
    0x6C, 0x61, 0x2C, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x6D, 0x69, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75,
    0x6D, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x2C, 0x20, 0x61, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x6C,
    0x6F, 0x72, 0x65, 0x6D, 0x20, 0x6F, 0x64, 0x69, 0x6F, 0x20, 0x65, 0x75, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x2E, 0x20, 0x56,
    0x69, 0x76, 0x61, 0x6D, 0x75, 0x73, 0x20, 0x61, 0x63, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x65, 0x74, 0x20, 0x6E, 0x65, 0x71,
    0x75, 0x65, 0x2C, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x6E, 0x75, 0x6C,
    0x6C, 0x61, 0x2E, 0x20, 0x4F, 0x72, 0x63, 0x69, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x6E, 0x61, 0x74, 0x6F, 0x71,
    0x75, 0x65, 0x20, 0x70, 0x65, 0x6E, 0x61, 0x74, 0x69, 0x62, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x69,
    0x73, 0x20, 0x64, 0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x69, 0x65, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x6E, 0x74,
    0x65, 0x73, 0x2C, 0x20, 0x6E, 0x61, 0x73, 0x63, 0x65, 0x74, 0x75, 0x72, 0x20, 0x72, 0x69, 0x64, 0x69, 0x63, 0x75, 0x6C, 0x75,
    0x73, 0x20, 0x6D, 0x75, 0x73, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x49, 0x6E, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x76, 0x69, 0x76,
    0x65, 0x72, 0x72, 0x61, 0x20, 0x70, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x61, 0x75, 0x67,
    0x75, 0x65, 0x2C, 0x20, 0x61, 0x63, 0x20, 0x67, 0x72, 0x61, 0x76, 0x69, 0x64, 0x61, 0x20, 0x6C, 0x65, 0x6F, 0x20, 0x74, 0x69,
    0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x61, 0x63, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72,
    0x64, 0x75, 0x6D, 0x20, 0x61, 0x74, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69,
    0x62, 0x75, 0x73, 0x2E, 0x20, 0x51, 0x75, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x61, 0x20, 0x66, 0x72, 0x69, 0x6E, 0x67, 0x69,
    0x6C, 0x6C, 0x61, 0x20, 0x6D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x2E, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20,
    0x6E, 0x75, 0x6E, 0x63, 0x20, 0x6C, 0x65, 0x6F, 0x2C, 0x20, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72,
    0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x65, 0x75, 0x2C, 0x20, 0x6D, 0x61,
    0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x75, 0x74, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x2E, 0x20, 0x50, 0x72, 0x6F, 0x69,
    0x6E, 0x20, 0x6E, 0x69, 0x73, 0x6C, 0x20, 0x64, 0x69, 0x61, 0x6D, 0x2C, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69, 0x71, 0x75,
    0x65, 0x20, 0x65, 0x75, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x69, 0x61, 0x63, 0x75, 0x6C, 0x69, 0x73, 0x2C, 0x20, 0x70, 0x6F, 0x72,
    0x74, 0x74, 0x69, 0x74, 0x6F, 0x72, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x2E, 0x20,
    0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x20, 0x65, 0x72,
    0x6F, 0x73, 0x2E, 0x20, 0x45, 0x74, 0x69, 0x61, 0x6D, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73,
    0x20, 0x61, 0x74, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x20, 0x66, 0x72, 0x69,
    0x6E, 0x67, 0x69, 0x6C, 0x6C, 0x61, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x69,
    0x70, 0x73, 0x75, 0x6D, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E,
    0x74, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x6F, 0x64, 0x69, 0x6F, 0x2C, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x61,
    0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x20, 0x6C, 0x65, 0x6F, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x20, 0x69,
    0x64, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x75, 0x74, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x20,
    0x65, 0x72, 0x6F, 0x73, 0x2C, 0x20, 0x69, 0x64, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75,
    0x73, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x6D, 0x61, 0x74, 0x74, 0x69, 0x73, 0x20, 0x74, 0x6F, 0x72, 0x74, 0x6F, 0x72, 0x20, 0x61,
    0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x2E, 0x20, 0x4F, 0x72, 0x63, 0x69,
    0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x6E, 0x61, 0x74, 0x6F, 0x71, 0x75, 0x65, 0x20, 0x70, 0x65, 0x6E, 0x61, 0x74,
    0x69, 0x62, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x69, 0x73, 0x20, 0x64, 0x69, 0x73, 0x20, 0x70, 0x61,
    0x72, 0x74, 0x75, 0x72, 0x69, 0x65, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x6E, 0x74, 0x65, 0x73, 0x2C, 0x20, 0x6E, 0x61, 0x73, 0x63,
    0x65, 0x74, 0x75, 0x72, 0x20, 0x72, 0x69, 0x64, 0x69, 0x63, 0x75, 0x6C, 0x75, 0x73, 0x20, 0x6D, 0x75, 0x73, 0x2E, 0x20, 0x44,
    0x6F, 0x6E, 0x65, 0x63, 0x20, 0x65, 0x75, 0x20, 0x61, 0x72, 0x63, 0x75, 0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75,
    0x6D, 0x2C, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x6E, 0x6F, 0x6E,
    0x2C, 0x20, 0x72, 0x75, 0x74, 0x72, 0x75, 0x6D, 0x20, 0x64, 0x69, 0x61, 0x6D, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x64, 0x69,
    0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69, 0x62, 0x75, 0x73, 0x20, 0x65, 0x72, 0x61, 0x74,
    0x2C, 0x20, 0x65, 0x74, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x20, 0x67,
    0x72, 0x61, 0x76, 0x69, 0x64, 0x61, 0x20, 0x73, 0x65, 0x64, 0x2E, 0x20, 0x43, 0x75, 0x72, 0x61, 0x62, 0x69, 0x74, 0x75, 0x72,
    0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x78, 0x20, 0x73, 0x65, 0x64, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x20,
    0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x6C, 0x61, 0x6F, 0x72, 0x65, 0x65, 0x74, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x44,
    0x6F, 0x6E, 0x65, 0x63, 0x20, 0x6D, 0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65, 0x20, 0x75, 0x74, 0x20, 0x6C, 0x65, 0x6F, 0x20,
    0x61, 0x74, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69, 0x63, 0x69, 0x74, 0x75, 0x64, 0x69, 0x6E, 0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62,
    0x69, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x71, 0x75, 0x61, 0x74, 0x20, 0x65, 0x73, 0x74, 0x2C, 0x20,
    0x65, 0x75, 0x20, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x2E,
    0x20, 0x41, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x70, 0x6F, 0x73,
    0x75, 0x65, 0x72, 0x65, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D,
    0x20, 0x70, 0x68, 0x61, 0x72, 0x65, 0x74, 0x72, 0x61, 0x20, 0x65, 0x75, 0x20, 0x65, 0x75, 0x20, 0x65, 0x73, 0x74, 0x2E, 0x20,
    0x45, 0x74, 0x69, 0x61, 0x6D, 0x20, 0x63, 0x75, 0x72, 0x73, 0x75, 0x73, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x6E,
    0x65, 0x71, 0x75, 0x65, 0x2C, 0x20, 0x69, 0x64, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x6C,
    0x20, 0x73, 0x75, 0x73, 0x63, 0x69, 0x70, 0x69, 0x74, 0x20, 0x69, 0x64, 0x2E, 0x20, 0x44, 0x75, 0x69, 0x73, 0x20, 0x76, 0x65,
    0x6E, 0x65, 0x6E, 0x61, 0x74, 0x69, 0x73, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x61, 0x63, 0x20, 0x73, 0x65, 0x6D, 0x20,
    0x73, 0x65, 0x6D, 0x70, 0x65, 0x72, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61,
    0x20, 0x73, 0x65, 0x64, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x6C,
    0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x72, 0x61, 0x74, 0x20, 0x6E, 0x65, 0x63, 0x20,
    0x65, 0x75, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20,
    0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x6F, 0x64, 0x69, 0x6F, 0x20, 0x6D, 0x65, 0x74, 0x75, 0x73, 0x2C, 0x20,
    0x6E, 0x65, 0x63, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69, 0x63, 0x69, 0x74, 0x75, 0x64, 0x69, 0x6E, 0x20, 0x6A, 0x75, 0x73, 0x74,
    0x6F, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x75, 0x74, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E,
    0x20, 0x65, 0x74, 0x20, 0x6D, 0x69, 0x20, 0x73, 0x65, 0x64, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F,
    0x64, 0x6F, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x20, 0x69, 0x64, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x65,
    0x78, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20, 0x65, 0x78, 0x2C, 0x20, 0x61, 0x63, 0x63, 0x75,
    0x6D, 0x73, 0x61, 0x6E, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x72, 0x61, 0x74, 0x20, 0x65, 0x6E, 0x69, 0x6D, 0x20, 0x69, 0x64,
    0x2C, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x6D, 0x6F, 0x6C, 0x6C, 0x69, 0x73, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D,
    0x2E, 0x20, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x20, 0x61, 0x70, 0x74, 0x65, 0x6E, 0x74, 0x20, 0x74, 0x61, 0x63, 0x69, 0x74, 0x69,
    0x20, 0x73, 0x6F, 0x63, 0x69, 0x6F, 0x73, 0x71, 0x75, 0x20, 0x61, 0x64, 0x20, 0x6C, 0x69, 0x74, 0x6F, 0x72, 0x61, 0x20, 0x74,
    0x6F, 0x72, 0x71, 0x75, 0x65, 0x6E, 0x74, 0x20, 0x70, 0x65, 0x72, 0x20, 0x63, 0x6F, 0x6E, 0x75, 0x62, 0x69, 0x61, 0x20, 0x6E,
    0x6F, 0x73, 0x74, 0x72, 0x61, 0x2C, 0x20, 0x70, 0x65, 0x72, 0x20, 0x69, 0x6E, 0x63, 0x65, 0x70, 0x74, 0x6F, 0x73, 0x20, 0x68,
    0x69, 0x6D, 0x65, 0x6E, 0x61, 0x65, 0x6F, 0x73, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x61, 0x72, 0x63, 0x75, 0x20, 0x61, 0x6E, 0x74,
    0x65, 0x2C, 0x20, 0x6D, 0x61, 0x74, 0x74, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x73,
    0x65, 0x64, 0x2C, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69, 0x71,
    0x75, 0x65, 0x20, 0x6C, 0x65, 0x6F, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x50, 0x72, 0x61, 0x65, 0x73, 0x65, 0x6E, 0x74, 0x20, 0x73,
    0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6E, 0x65, 0x71, 0x75,
    0x65, 0x2E, 0x20, 0x43, 0x75, 0x72, 0x61, 0x62, 0x69, 0x74, 0x75, 0x72, 0x20, 0x73, 0x75, 0x73, 0x63, 0x69, 0x70, 0x69, 0x74,
    0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20,
    0x6E, 0x69, 0x73, 0x6C, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x2C, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x74, 0x69, 0x74, 0x6F, 0x72,
    0x20, 0x61, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x20, 0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C, 0x6C, 0x69, 0x73, 0x2C, 0x20, 0x72,
    0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x2E,
    0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x61, 0x6E, 0x74, 0x65, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x2C, 0x20, 0x6D, 0x61,
    0x78, 0x69, 0x6D, 0x75, 0x73, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x6E, 0x65, 0x63,
    0x2C, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x64, 0x75, 0x69, 0x2E, 0x20, 0x4E,
    0x75, 0x6E, 0x63, 0x20, 0x73, 0x65, 0x6D, 0x70, 0x65, 0x72, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x20, 0x65, 0x67, 0x65,
    0x74, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63,
    0x69, 0x74, 0x75, 0x72, 0x2E, 0x20, 0x43, 0x75, 0x72, 0x61, 0x62, 0x69, 0x74, 0x75, 0x72, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F,
    0x72, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x2C, 0x20, 0x65, 0x75, 0x20, 0x65, 0x6C, 0x65,
    0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x76,
    0x69, 0x74, 0x61, 0x65, 0x2E, 0x20, 0x4E, 0x75, 0x6E, 0x63, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x75, 0x73, 0x20, 0x76, 0x61, 0x72,
    0x69, 0x75, 0x73, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x73,
    0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x65, 0x78, 0x20,
    0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x2C, 0x20, 0x75, 0x74, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69, 0x62, 0x75, 0x73, 0x20,
    0x6D, 0x61, 0x73, 0x73, 0x61, 0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x2E, 0x20, 0x45, 0x74, 0x69, 0x61,
    0x6D, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x65, 0x78, 0x2C, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75,
    0x65, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x2C, 0x20, 0x66, 0x61,
    0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x6E,
    0x69, 0x73, 0x6C, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x6A, 0x75,
    0x73, 0x74, 0x6F, 0x20, 0x65, 0x74, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x73, 0x6F, 0x64, 0x61, 0x6C, 0x65, 0x73, 0x20,
    0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61, 0x74, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61,
    0x6E, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x75, 0x74, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x20, 0x65, 0x66, 0x66, 0x69,
    0x63, 0x69, 0x74, 0x75, 0x72, 0x20, 0x73, 0x6F, 0x64, 0x61, 0x6C, 0x65, 0x73, 0x2E, 0x20, 0x4D, 0x61, 0x75, 0x72, 0x69, 0x73,
    0x20, 0x70, 0x6F, 0x72, 0x74, 0x74, 0x69, 0x74, 0x6F, 0x72, 0x20, 0x6D, 0x69, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6D, 0x61,
    0x73, 0x73, 0x61, 0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x2C, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x72, 0x69,
    0x73, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x2E,
    0x20, 0x49, 0x6E, 0x20, 0x68, 0x61, 0x63, 0x20, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x73, 0x73, 0x65, 0x20, 0x70, 0x6C, 0x61,
    0x74, 0x65, 0x61, 0x20, 0x64, 0x69, 0x63, 0x74, 0x75, 0x6D, 0x73, 0x74, 0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x61,
    0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x20, 0x64, 0x69, 0x61, 0x6D, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64,
    0x69, 0x73, 0x73, 0x65, 0x20, 0x61, 0x74, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x74, 0x75, 0x72,
    0x70, 0x69, 0x73, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x63, 0x6F, 0x6E, 0x76, 0x61, 0x6C,
    0x6C, 0x69, 0x73, 0x20, 0x69, 0x6E, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65,
    0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x6C, 0x61, 0x6F, 0x72, 0x65, 0x65, 0x74,
    0x20, 0x65, 0x72, 0x61, 0x74, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x56, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20,
    0x71, 0x75, 0x69, 0x73, 0x20, 0x72, 0x75, 0x74, 0x72, 0x75, 0x6D, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x2C, 0x20, 0x61, 0x20, 0x75,
    0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x76, 0x69, 0x74,
    0x61, 0x65, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x61, 0x72, 0x63, 0x75, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x65,
    0x67, 0x65, 0x74, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75, 0x72, 0x20, 0x61, 0x72, 0x63, 0x75, 0x2E, 0x20, 0x4E,
    0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x20, 0x61, 0x74, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x75, 0x72, 0x6E,
    0x61, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x2E, 0x20, 0x44, 0x75,
    0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x65, 0x72, 0x61, 0x74, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x2E, 0x20, 0x45, 0x74,
    0x69, 0x61, 0x6D, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x69, 0x6E, 0x20, 0x6C, 0x65, 0x6F, 0x20,
    0x65, 0x6C, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x2E, 0x20,
    0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x6D, 0x61, 0x78, 0x69, 0x6D, 0x75, 0x73, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x6E,
    0x65, 0x63, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61, 0x74, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x2E,
    0x0D, 0x0A, 0x0D, 0x0A, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20, 0x75, 0x74, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61,
    0x20, 0x65, 0x72, 0x61, 0x74, 0x2E, 0x20, 0x4E, 0x75, 0x6E, 0x63, 0x20, 0x75, 0x74, 0x20, 0x72, 0x75, 0x74, 0x72, 0x75, 0x6D,
    0x20, 0x65, 0x6E, 0x69, 0x6D, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x73, 0x75, 0x73, 0x63, 0x69, 0x70, 0x69, 0x74, 0x20, 0x74,
    0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x63, 0x6F, 0x6E, 0x67, 0x75, 0x65, 0x20, 0x76, 0x6F, 0x6C, 0x75,
    0x74, 0x70, 0x61, 0x74, 0x2E, 0x20, 0x43, 0x75, 0x72, 0x61, 0x62, 0x69, 0x74, 0x75, 0x72, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74,
    0x70, 0x61, 0x74, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x61, 0x63, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63,
    0x75, 0x6C, 0x61, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20, 0x61, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x6F, 0x72,
    0x63, 0x69, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20, 0x70,
    0x68, 0x61, 0x72, 0x65, 0x74, 0x72, 0x61, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x2C, 0x20, 0x61, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65,
    0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x6C, 0x61, 0x63, 0x69, 0x6E, 0x69, 0x61,
    0x20, 0x65, 0x75, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x68, 0x61, 0x62,
    0x69, 0x74, 0x61, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69, 0x71, 0x75, 0x65,
    0x20, 0x73, 0x65, 0x6E, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6E, 0x65, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74,
    0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x66, 0x61, 0x6D, 0x65, 0x73, 0x20, 0x61, 0x63, 0x20, 0x74,
    0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x61, 0x6C, 0x69,
    0x71, 0x75, 0x61, 0x6D, 0x20, 0x6F, 0x64, 0x69, 0x6F, 0x20, 0x73, 0x65, 0x64, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x74, 0x69, 0x74,
    0x6F, 0x72, 0x20, 0x70, 0x68, 0x61, 0x72, 0x65, 0x74, 0x72, 0x61, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x4E, 0x75, 0x6C, 0x6C, 0x61,
    0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x2E, 0x20, 0x4E, 0x75, 0x6E, 0x63, 0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69,
    0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x6E, 0x65, 0x63,
    0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x65, 0x74, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20, 0x61, 0x74, 0x20, 0x75,
    0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x2E, 0x20, 0x56, 0x65, 0x73, 0x74, 0x69,
    0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72, 0x20, 0x75, 0x72, 0x6E,
    0x61, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x2C, 0x20, 0x65, 0x75, 0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73,
    0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x2E,
    0x20, 0x43, 0x72, 0x61, 0x73, 0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F, 0x64, 0x6F, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75,
    0x6D, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x73, 0x65, 0x6D, 0x70, 0x65, 0x72, 0x2E, 0x20, 0x56,
    0x69, 0x76, 0x61, 0x6D, 0x75, 0x73, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73,
    0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x6C, 0x61, 0x63, 0x69, 0x6E, 0x69, 0x61, 0x20, 0x63, 0x6F,
    0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x2E, 0x20, 0x41, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x74, 0x75,
    0x72, 0x70, 0x69, 0x73, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x2C, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E,
    0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F, 0x64, 0x6F, 0x20, 0x69, 0x61, 0x63, 0x75, 0x6C, 0x69, 0x73, 0x20, 0x76, 0x69, 0x74, 0x61,
    0x65, 0x2C, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71,
    0x75, 0x65, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62,
    0x75, 0x73, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x2C, 0x20, 0x65, 0x75, 0x20, 0x74,
    0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x20,
    0x61, 0x74, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75,
    0x6D, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x2C, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x64, 0x69, 0x67, 0x6E,
    0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x65, 0x6C, 0x65, 0x69,
    0x66, 0x65, 0x6E, 0x64, 0x20, 0x6E, 0x69, 0x62, 0x68, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20,
    0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61, 0x74, 0x2E, 0x20, 0x44,
    0x6F, 0x6E, 0x65, 0x63, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x6C,
    0x69, 0x67, 0x75, 0x6C, 0x61, 0x2C, 0x20, 0x69, 0x64, 0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x6D,
    0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61, 0x74, 0x20, 0x6E, 0x6F, 0x6E, 0x2E, 0x20, 0x55,
    0x74, 0x20, 0x61, 0x74, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x73, 0x65, 0x6D, 0x2E, 0x20, 0x4D, 0x6F, 0x72,
    0x62, 0x69, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x75, 0x74, 0x20, 0x6D,
    0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x72, 0x61, 0x74, 0x2E, 0x20, 0x56, 0x69, 0x76,
    0x61, 0x6D, 0x75, 0x73, 0x20, 0x66, 0x72, 0x69, 0x6E, 0x67, 0x69, 0x6C, 0x6C, 0x61, 0x2C, 0x20, 0x64, 0x69, 0x61, 0x6D, 0x20,
    0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x76, 0x65, 0x6E, 0x65, 0x6E, 0x61, 0x74, 0x69, 0x73, 0x20, 0x69, 0x61,
    0x63, 0x75, 0x6C, 0x69, 0x73, 0x2C, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x20, 0x74, 0x69, 0x6E,
    0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x2C, 0x20, 0x61, 0x74, 0x20, 0x66, 0x65, 0x72, 0x6D,
    0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x6C, 0x69, 0x67, 0x75, 0x6C, 0x61, 0x20, 0x65, 0x74, 0x20,
    0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x72, 0x69, 0x73,
    0x75, 0x73, 0x2C, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x20, 0x69, 0x6E, 0x20, 0x6D, 0x69, 0x20, 0x75,
    0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2C, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x63,
    0x6F, 0x6D, 0x6D, 0x6F, 0x64, 0x6F, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x2E, 0x20, 0x41, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D,
    0x20, 0x65, 0x72, 0x61, 0x74, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61, 0x74, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x53, 0x75,
    0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x69, 0x64, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x6E, 0x65, 0x63,
    0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x74, 0x65, 0x6D, 0x70,
    0x6F, 0x72, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x6F, 0x72, 0x63,
    0x69, 0x20, 0x61, 0x74, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x65, 0x6C, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20,
    0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x2E, 0x20, 0x50, 0x72, 0x6F, 0x69, 0x6E, 0x20, 0x73, 0x61, 0x67, 0x69,
    0x74, 0x74, 0x69, 0x73, 0x2C, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x69, 0x61, 0x63,
    0x75, 0x6C, 0x69, 0x73, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x2C, 0x20, 0x61, 0x72, 0x63, 0x75, 0x20, 0x6A, 0x75,
    0x73, 0x74, 0x6F, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x61, 0x6E, 0x74, 0x65, 0x2C, 0x20, 0x76, 0x65,
    0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x20, 0x66, 0x65,
    0x6C, 0x69, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x6C, 0x20, 0x75, 0x74, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x2E, 0x20, 0x50, 0x72,
    0x61, 0x65, 0x73, 0x65, 0x6E, 0x74, 0x20, 0x61, 0x63, 0x20, 0x65, 0x72, 0x6F, 0x73, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75,
    0x6D, 0x2C, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x6E, 0x65, 0x63, 0x2C,
    0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65,
    0x63, 0x20, 0x73, 0x65, 0x64, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x2C,
    0x20, 0x66, 0x61, 0x63, 0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x67, 0x72, 0x61, 0x76, 0x69, 0x64, 0x61, 0x20, 0x71, 0x75,
    0x61, 0x6D, 0x2E, 0x20, 0x50, 0x72, 0x6F, 0x69, 0x6E, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x6D, 0x61,
    0x74, 0x74, 0x69, 0x73, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x2C, 0x20, 0x75, 0x74, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x71,
    0x75, 0x61, 0x74, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x63, 0x75, 0x72, 0x73, 0x75, 0x73, 0x20, 0x73, 0x65, 0x64, 0x2E,
    0x20, 0x50, 0x72, 0x6F, 0x69, 0x6E, 0x20, 0x61, 0x74, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x70,
    0x75, 0x72, 0x75, 0x73, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75, 0x72, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75,
    0x61, 0x64, 0x61, 0x20, 0x61, 0x63, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x73, 0x65, 0x6D, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x50, 0x72,
    0x6F, 0x69, 0x6E, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x69,
    0x6E, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x2E, 0x20, 0x49, 0x6E,
    0x20, 0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x6E, 0x69, 0x62, 0x68, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61,
    0x6D, 0x65, 0x74, 0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74,
    0x65, 0x74, 0x75, 0x72, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69, 0x6D, 0x65, 0x6E, 0x74,
    0x75, 0x6D, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61,
    0x20, 0x76, 0x75, 0x6C, 0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20, 0x70, 0x68, 0x61, 0x72, 0x65, 0x74, 0x72, 0x61, 0x2E, 0x20,
    0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x65, 0x75, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x66, 0x65, 0x6C,
    0x69, 0x73, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x76, 0x69, 0x76, 0x65, 0x72, 0x72, 0x61, 0x20, 0x69, 0x70, 0x73,
    0x75, 0x6D, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x2C, 0x20, 0x75, 0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61,
    0x64, 0x61, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20, 0x64, 0x69, 0x67, 0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x75, 0x74,
    0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69, 0x64, 0x75,
    0x6E, 0x74, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x6D, 0x6F, 0x6C, 0x6C, 0x69, 0x73, 0x20,
    0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E, 0x2E, 0x20, 0x43, 0x6C, 0x61, 0x73, 0x73, 0x20, 0x61, 0x70, 0x74, 0x65, 0x6E,
    0x74, 0x20, 0x74, 0x61, 0x63, 0x69, 0x74, 0x69, 0x20, 0x73, 0x6F, 0x63, 0x69, 0x6F, 0x73, 0x71, 0x75, 0x20, 0x61, 0x64, 0x20,
    0x6C, 0x69, 0x74, 0x6F, 0x72, 0x61, 0x20, 0x74, 0x6F, 0x72, 0x71, 0x75, 0x65, 0x6E, 0x74, 0x20, 0x70, 0x65, 0x72, 0x20, 0x63,
    0x6F, 0x6E, 0x75, 0x62, 0x69, 0x61, 0x20, 0x6E, 0x6F, 0x73, 0x74, 0x72, 0x61, 0x2C, 0x20, 0x70, 0x65, 0x72, 0x20, 0x69, 0x6E,
    0x63, 0x65, 0x70, 0x74, 0x6F, 0x73, 0x20, 0x68, 0x69, 0x6D, 0x65, 0x6E, 0x61, 0x65, 0x6F, 0x73, 0x2E, 0x20, 0x51, 0x75, 0x69,
    0x73, 0x71, 0x75, 0x65, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x65, 0x74, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x75, 0x74,
    0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x2E, 0x20, 0x4E, 0x75, 0x6C,
    0x6C, 0x61, 0x6D, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x68, 0x65, 0x6E, 0x64, 0x72, 0x65, 0x72, 0x69,
    0x74, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2E, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x67, 0x65, 0x72, 0x20, 0x71, 0x75, 0x69, 0x73,
    0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x65, 0x74, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63,
    0x69, 0x65, 0x73, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x71, 0x75, 0x69, 0x73,
    0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x2E, 0x20, 0x4D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63,
    0x75, 0x6C, 0x61, 0x20, 0x65, 0x74, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x20, 0x67, 0x72, 0x61, 0x76, 0x69, 0x64, 0x61, 0x20,
    0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x2E, 0x20, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x65, 0x75,
    0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x69, 0x61, 0x63, 0x75, 0x6C, 0x69, 0x73, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x2C,
    0x20, 0x6C, 0x61, 0x6F, 0x72, 0x65, 0x65, 0x74, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x6E, 0x69, 0x73,
    0x6C, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x61, 0x74, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x63,
    0x6F, 0x6E, 0x67, 0x75, 0x65, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x2C, 0x20, 0x61,
    0x74, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x74, 0x69, 0x74, 0x6F, 0x72, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x62, 0x69, 0x62,
    0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x2E, 0x20, 0x56, 0x65,
    0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x61, 0x72, 0x63,
    0x75, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65,
    0x73, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x2E, 0x20, 0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65,
    0x73, 0x71, 0x75, 0x65, 0x20, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x6E, 0x74, 0x20, 0x6D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x74,
    0x72, 0x69, 0x73, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20, 0x73, 0x65, 0x6E, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20,
    0x6E, 0x65, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x66, 0x61,
    0x6D, 0x65, 0x73, 0x20, 0x61, 0x63, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73,
    0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x41, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x64, 0x69, 0x63, 0x74, 0x75, 0x6D, 0x20, 0x74,
    0x69, 0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75,
    0x73, 0x20, 0x6D, 0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65, 0x2E, 0x20, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20,
    0x65, 0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x20, 0x66, 0x61, 0x6D, 0x65, 0x73, 0x20, 0x61, 0x63,
    0x20, 0x61, 0x6E, 0x74, 0x65, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x70, 0x72, 0x69, 0x6D, 0x69, 0x73, 0x20, 0x69, 0x6E,
    0x20, 0x66, 0x61, 0x75, 0x63, 0x69, 0x62, 0x75, 0x73, 0x2E, 0x20, 0x44, 0x75, 0x69, 0x73, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72,
    0x74, 0x69, 0x73, 0x2C, 0x20, 0x6E, 0x69, 0x73, 0x6C, 0x20, 0x69, 0x6E, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65,
    0x73, 0x20, 0x76, 0x65, 0x6E, 0x65, 0x6E, 0x61, 0x74, 0x69, 0x73, 0x2C, 0x20, 0x6C, 0x65, 0x6F, 0x20, 0x6D, 0x65, 0x74, 0x75,
    0x73, 0x20, 0x6D, 0x61, 0x74, 0x74, 0x69, 0x73, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x2C, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x70,
    0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x76, 0x65, 0x6C, 0x69, 0x74, 0x20, 0x69, 0x70, 0x73,
    0x75, 0x6D, 0x20, 0x75, 0x74, 0x20, 0x6C, 0x65, 0x6F, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x74, 0x65, 0x6D, 0x70,
    0x75, 0x73, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x75, 0x74, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x20, 0x76, 0x6F, 0x6C,
    0x75, 0x74, 0x70, 0x61, 0x74, 0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x2E, 0x20, 0x50, 0x72, 0x61, 0x65,
    0x73, 0x65, 0x6E, 0x74, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x20, 0x65, 0x72, 0x61, 0x74, 0x20, 0x75,
    0x74, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x2E, 0x20, 0x4D,
    0x6F, 0x72, 0x62, 0x69, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x74, 0x69, 0x74, 0x6F, 0x72, 0x20, 0x69, 0x64, 0x20, 0x6E, 0x65, 0x71,
    0x75, 0x65, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x2E, 0x20, 0x49, 0x6E, 0x20,
    0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x65, 0x73,
    0x74, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2E, 0x0D,
    0x0A, 0x0D, 0x0A, 0x43, 0x72, 0x61, 0x73, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x6E, 0x69, 0x62, 0x68, 0x20,
    0x61, 0x74, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x20, 0x75, 0x6C,
    0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x61, 0x74, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x69, 0x6E,
    0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x75,
    0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x20, 0x61, 0x63, 0x20, 0x61, 0x74, 0x20, 0x64, 0x75, 0x69, 0x2E, 0x20, 0x49,
    0x6E, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x76, 0x61, 0x72, 0x69, 0x75, 0x73, 0x20, 0x65, 0x75, 0x69,
    0x73, 0x6D, 0x6F, 0x64, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73,
    0x2C, 0x20, 0x6D, 0x61, 0x78, 0x69, 0x6D, 0x75, 0x73, 0x20, 0x73, 0x65, 0x64, 0x20, 0x76, 0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61,
    0x74, 0x20, 0x75, 0x74, 0x2C, 0x20, 0x6C, 0x61, 0x6F, 0x72, 0x65, 0x65, 0x74, 0x20, 0x69, 0x6E, 0x20, 0x6C, 0x65, 0x63, 0x74,
    0x75, 0x73, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75, 0x72, 0x20,
    0x71, 0x75, 0x61, 0x6D, 0x2E, 0x20, 0x56, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C, 0x75, 0x6D, 0x20, 0x61, 0x6E, 0x74, 0x65,
    0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x70, 0x72, 0x69, 0x6D, 0x69, 0x73, 0x20, 0x69, 0x6E, 0x20, 0x66, 0x61, 0x75, 0x63,
    0x69, 0x62, 0x75, 0x73, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x75,
    0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x20, 0x63, 0x75, 0x62, 0x69, 0x6C,
    0x69, 0x61, 0x20, 0x63, 0x75, 0x72, 0x61, 0x65, 0x3B, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20, 0x63, 0x6F,
    0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x2C, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x20, 0x75, 0x74, 0x20, 0x66,
    0x69, 0x6E, 0x69, 0x62, 0x75, 0x73, 0x20, 0x66, 0x61, 0x75, 0x63, 0x69, 0x62, 0x75, 0x73, 0x2C, 0x20, 0x6D, 0x61, 0x75, 0x72,
    0x69, 0x73, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x75, 0x72, 0x6E, 0x61,
    0x2C, 0x20, 0x75, 0x74, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x20, 0x71, 0x75,
    0x61, 0x6D, 0x20, 0x65, 0x75, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x76,
    0x6F, 0x6C, 0x75, 0x74, 0x70, 0x61, 0x74, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x66, 0x65,
    0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x2C, 0x20, 0x76, 0x69, 0x74,
    0x61, 0x65, 0x20, 0x72, 0x68, 0x6F, 0x6E, 0x63, 0x75, 0x73, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x76, 0x61, 0x72, 0x69,
    0x75, 0x73, 0x20, 0x61, 0x63, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x6D, 0x65, 0x74,
    0x75, 0x73, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2C, 0x20, 0x66, 0x69, 0x6E, 0x69, 0x62, 0x75, 0x73,
    0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x6E, 0x65, 0x63, 0x2C, 0x20, 0x76, 0x75, 0x6C, 0x70, 0x75, 0x74, 0x61, 0x74, 0x65,
    0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x2E, 0x20, 0x4E, 0x75, 0x6E, 0x63, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75,
    0x72, 0x20, 0x65, 0x72, 0x61, 0x74, 0x20, 0x61, 0x63, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x20, 0x63, 0x6F, 0x6E, 0x64, 0x69, 0x6D,
    0x65, 0x6E, 0x74, 0x75, 0x6D, 0x2C, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x6D, 0x61, 0x78, 0x69, 0x6D,
    0x75, 0x73, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x2E, 0x20, 0x50, 0x65, 0x6C,
    0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x73, 0x65, 0x64, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x20, 0x65,
    0x6E, 0x69, 0x6D, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20, 0x61, 0x20, 0x72, 0x75, 0x74, 0x72,
    0x75, 0x6D, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x2C, 0x20, 0x73, 0x69, 0x74, 0x20, 0x61, 0x6D, 0x65, 0x74, 0x20, 0x63, 0x6F,
    0x6E, 0x73, 0x65, 0x71, 0x75, 0x61, 0x74, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x6E, 0x65,
    0x63, 0x20, 0x6E, 0x75, 0x6E, 0x63, 0x20, 0x65, 0x6E, 0x69, 0x6D, 0x2E, 0x20, 0x56, 0x65, 0x73, 0x74, 0x69, 0x62, 0x75, 0x6C,
    0x75, 0x6D, 0x20, 0x73, 0x63, 0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x76, 0x65, 0x73, 0x74, 0x69, 0x62,
    0x75, 0x6C, 0x75, 0x6D, 0x20, 0x61, 0x6C, 0x69, 0x71, 0x75, 0x65, 0x74, 0x2E, 0x20, 0x41, 0x65, 0x6E, 0x65, 0x61, 0x6E, 0x20,
    0x65, 0x67, 0x65, 0x74, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x2E, 0x20, 0x41, 0x6C, 0x69,
    0x71, 0x75, 0x61, 0x6D, 0x20, 0x61, 0x20, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72, 0x20, 0x65, 0x6C,
    0x69, 0x74, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x6F,
    0x64, 0x6F, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x69, 0x6E, 0x20, 0x72, 0x69, 0x73, 0x75, 0x73, 0x20, 0x6C, 0x61, 0x63, 0x69,
    0x6E, 0x69, 0x61, 0x2C, 0x20, 0x6E, 0x6F, 0x6E, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6D, 0x61, 0x73,
    0x73, 0x61, 0x20, 0x6D, 0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65, 0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x73, 0x63,
    0x65, 0x6C, 0x65, 0x72, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x61, 0x6E, 0x74, 0x65, 0x2C,
    0x20, 0x69, 0x6D, 0x70, 0x65, 0x72, 0x64, 0x69, 0x65, 0x74, 0x20, 0x6C, 0x61, 0x63, 0x69, 0x6E, 0x69, 0x61, 0x20, 0x65, 0x72,
    0x61, 0x74, 0x20, 0x6D, 0x6F, 0x6C, 0x65, 0x73, 0x74, 0x69, 0x65, 0x20, 0x61, 0x63, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70, 0x65,
    0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72,
    0x74, 0x69, 0x73, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x65, 0x74, 0x20, 0x6C, 0x6F, 0x62, 0x6F, 0x72, 0x74, 0x69, 0x73,
    0x2E, 0x20, 0x45, 0x74, 0x69, 0x61, 0x6D, 0x20, 0x61, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x20, 0x69, 0x64, 0x20, 0x69, 0x70,
    0x73, 0x75, 0x6D, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75, 0x6D, 0x20, 0x75, 0x6C, 0x74, 0x72, 0x69, 0x63, 0x65, 0x73,
    0x2E, 0x20, 0x50, 0x72, 0x6F, 0x69, 0x6E, 0x20, 0x65, 0x75, 0x69, 0x73, 0x6D, 0x6F, 0x64, 0x20, 0x65, 0x6E, 0x69, 0x6D, 0x20,
    0x69, 0x6E, 0x20, 0x64, 0x75, 0x69, 0x20, 0x70, 0x6C, 0x61, 0x63, 0x65, 0x72, 0x61, 0x74, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73,
    0x75, 0x61, 0x64, 0x61, 0x2E, 0x20, 0x4D, 0x61, 0x65, 0x63, 0x65, 0x6E, 0x61, 0x73, 0x20, 0x69, 0x64, 0x20, 0x64, 0x69, 0x67,
    0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x2C, 0x20, 0x65, 0x75, 0x20, 0x76, 0x75, 0x6C,
    0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6D, 0x69, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x4E, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x20,
    0x71, 0x75, 0x69, 0x73, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63, 0x75, 0x6C, 0x61, 0x20, 0x65, 0x78, 0x2C, 0x20, 0x61, 0x63, 0x20,
    0x63, 0x6F, 0x6E, 0x73, 0x65, 0x63, 0x74, 0x65, 0x74, 0x75, 0x72, 0x20, 0x65, 0x78, 0x2E, 0x20, 0x4E, 0x75, 0x6E, 0x63, 0x20,
    0x6D, 0x65, 0x74, 0x75, 0x73, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x2C, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73, 0x61, 0x6E,
    0x20, 0x65, 0x74, 0x20, 0x70, 0x6F, 0x72, 0x74, 0x61, 0x20, 0x61, 0x74, 0x2C, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E, 0x64, 0x75,
    0x6D, 0x20, 0x61, 0x63, 0x20, 0x66, 0x65, 0x6C, 0x69, 0x73, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x76, 0x65, 0x6C,
    0x20, 0x6C, 0x61, 0x63, 0x75, 0x73, 0x20, 0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x6D, 0x65, 0x74, 0x75,
    0x73, 0x20, 0x65, 0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x61, 0x20,
    0x75, 0x74, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x2E, 0x20, 0x46, 0x75, 0x73, 0x63, 0x65, 0x20, 0x6C, 0x61, 0x63, 0x69, 0x6E, 0x69,
    0x61, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63, 0x75, 0x6C, 0x61, 0x20, 0x6E, 0x65, 0x71, 0x75, 0x65, 0x2C, 0x20, 0x65, 0x67, 0x65,
    0x74, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73, 0x2E, 0x20, 0x53, 0x75, 0x73, 0x70,
    0x65, 0x6E, 0x64, 0x69, 0x73, 0x73, 0x65, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x20, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x73,
    0x20, 0x75, 0x74, 0x20, 0x71, 0x75, 0x61, 0x6D, 0x20, 0x75, 0x6C, 0x6C, 0x61, 0x6D, 0x63, 0x6F, 0x72, 0x70, 0x65, 0x72, 0x20,
    0x61, 0x6C, 0x69, 0x71, 0x75, 0x61, 0x6D, 0x2E, 0x20, 0x49, 0x6E, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x2C, 0x20,
    0x6A, 0x75, 0x73, 0x74, 0x6F, 0x20, 0x73, 0x65, 0x64, 0x20, 0x76, 0x65, 0x68, 0x69, 0x63, 0x75, 0x6C, 0x61, 0x20, 0x66, 0x69,
    0x6E, 0x69, 0x62, 0x75, 0x73, 0x2C, 0x20, 0x73, 0x65, 0x6D, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20, 0x70, 0x6F, 0x73, 0x75,
    0x65, 0x72, 0x65, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2C, 0x20, 0x69, 0x6E, 0x20, 0x65, 0x67, 0x65, 0x73, 0x74, 0x61, 0x73,
    0x20, 0x6E, 0x69, 0x73, 0x6C, 0x20, 0x61, 0x6E, 0x74, 0x65, 0x20, 0x73, 0x65, 0x64, 0x20, 0x75, 0x72, 0x6E, 0x61, 0x2E, 0x20,
    0x50, 0x65, 0x6C, 0x6C, 0x65, 0x6E, 0x74, 0x65, 0x73, 0x71, 0x75, 0x65, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x65, 0x78, 0x20, 0x6E,
    0x75, 0x6E, 0x63, 0x2E, 0x20, 0x53, 0x65, 0x64, 0x20, 0x72, 0x75, 0x74, 0x72, 0x75, 0x6D, 0x2C, 0x20, 0x65, 0x6C, 0x69, 0x74,
    0x20, 0x76, 0x65, 0x6C, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x73, 0x6F, 0x6C, 0x6C, 0x69, 0x63, 0x69, 0x74,
    0x75, 0x64, 0x69, 0x6E, 0x2C, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x20, 0x64, 0x69, 0x67,
    0x6E, 0x69, 0x73, 0x73, 0x69, 0x6D, 0x20, 0x6A, 0x75, 0x73, 0x74, 0x6F, 0x2C, 0x20, 0x6E, 0x65, 0x63, 0x20, 0x73, 0x61, 0x67,
    0x69, 0x74, 0x74, 0x69, 0x73, 0x20, 0x6F, 0x72, 0x63, 0x69, 0x20, 0x6D, 0x61, 0x67, 0x6E, 0x61, 0x20, 0x73, 0x69, 0x74, 0x20,
    0x61, 0x6D, 0x65, 0x74, 0x20, 0x6E, 0x75, 0x6C, 0x6C, 0x61, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x55, 0x74, 0x20, 0x66, 0x61, 0x63,
    0x69, 0x6C, 0x69, 0x73, 0x69, 0x73, 0x20, 0x6D, 0x61, 0x75, 0x72, 0x69, 0x73, 0x20, 0x61, 0x74, 0x20, 0x69, 0x70, 0x73, 0x75,
    0x6D, 0x20, 0x70, 0x72, 0x65, 0x74, 0x69, 0x75, 0x6D, 0x2C, 0x20, 0x65, 0x74, 0x20, 0x66, 0x72, 0x69, 0x6E, 0x67, 0x69, 0x6C,
    0x6C, 0x61, 0x20, 0x74, 0x6F, 0x72, 0x74, 0x6F, 0x72, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F, 0x72, 0x2E, 0x20, 0x50, 0x72, 0x6F,
    0x69, 0x6E, 0x20, 0x61, 0x75, 0x67, 0x75, 0x65, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x2C, 0x20, 0x62, 0x69, 0x62, 0x65, 0x6E,
    0x64, 0x75, 0x6D, 0x20, 0x65, 0x75, 0x20, 0x61, 0x6E, 0x74, 0x65, 0x20, 0x61, 0x63, 0x2C, 0x20, 0x74, 0x69, 0x6E, 0x63, 0x69,
    0x64, 0x75, 0x6E, 0x74, 0x20, 0x64, 0x61, 0x70, 0x69, 0x62, 0x75, 0x73, 0x20, 0x74, 0x6F, 0x72, 0x74, 0x6F, 0x72, 0x2E, 0x20,
    0x45, 0x74, 0x69, 0x61, 0x6D, 0x20, 0x6D, 0x61, 0x74, 0x74, 0x69, 0x73, 0x20, 0x6C, 0x65, 0x63, 0x74, 0x75, 0x73, 0x20, 0x61,
    0x74, 0x20, 0x70, 0x75, 0x72, 0x75, 0x73, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75, 0x61, 0x64, 0x61, 0x2C, 0x20, 0x69, 0x6E,
    0x20, 0x63, 0x75, 0x72, 0x73, 0x75, 0x73, 0x20, 0x73, 0x61, 0x70, 0x69, 0x65, 0x6E, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69,
    0x74, 0x75, 0x72, 0x2E, 0x20, 0x4D, 0x6F, 0x72, 0x62, 0x69, 0x20, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x64, 0x75, 0x6D, 0x20, 0x65,
    0x6C, 0x65, 0x69, 0x66, 0x65, 0x6E, 0x64, 0x20, 0x6C, 0x6F, 0x72, 0x65, 0x6D, 0x2E, 0x20, 0x56, 0x65, 0x73, 0x74, 0x69, 0x62,
    0x75, 0x6C, 0x75, 0x6D, 0x20, 0x70, 0x68, 0x61, 0x72, 0x65, 0x74, 0x72, 0x61, 0x20, 0x73, 0x61, 0x67, 0x69, 0x74, 0x74, 0x69,
    0x73, 0x20, 0x64, 0x6F, 0x6C, 0x6F, 0x72, 0x2C, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x74, 0x75, 0x72, 0x20, 0x74, 0x69,
    0x6E, 0x63, 0x69, 0x64, 0x75, 0x6E, 0x74, 0x20, 0x74, 0x75, 0x72, 0x70, 0x69, 0x73, 0x20, 0x6D, 0x6F, 0x6C, 0x6C, 0x69, 0x73,
    0x20, 0x69, 0x64, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x67, 0x72, 0x61, 0x76, 0x69, 0x64, 0x61, 0x20, 0x67, 0x72, 0x61, 0x76,
    0x69, 0x64, 0x61, 0x20, 0x61, 0x72, 0x63, 0x75, 0x2C, 0x20, 0x71, 0x75, 0x69, 0x73, 0x20, 0x6D, 0x61, 0x6C, 0x65, 0x73, 0x75,
    0x61, 0x64, 0x61, 0x20, 0x69, 0x70, 0x73, 0x75, 0x6D, 0x20, 0x74, 0x72, 0x69, 0x73, 0x74, 0x69, 0x71, 0x75, 0x65, 0x20, 0x70,
    0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x2E, 0x20, 0x4E, 0x61, 0x6D, 0x20, 0x76, 0x69, 0x74, 0x61, 0x65, 0x20, 0x76, 0x61, 0x72,
    0x69, 0x75, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x69, 0x2E, 0x20, 0x51, 0x75, 0x69, 0x73, 0x71, 0x75, 0x65, 0x20, 0x65, 0x75, 0x20,
    0x66, 0x65, 0x72, 0x6D, 0x65, 0x6E, 0x74, 0x75, 0x6D, 0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x2C, 0x20, 0x65, 0x75, 0x20, 0x64,
    0x69, 0x63, 0x74, 0x75, 0x6D, 0x20, 0x65, 0x6C, 0x69, 0x74, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x61, 0x63, 0x63, 0x75, 0x6D, 0x73,
    0x61, 0x6E, 0x20, 0x6C, 0x69, 0x62, 0x65, 0x72, 0x6F, 0x20, 0x6C, 0x75, 0x63, 0x74, 0x75, 0x73, 0x20, 0x6E, 0x75, 0x6C, 0x6C,
    0x61, 0x20, 0x6D, 0x61, 0x78, 0x69, 0x6D, 0x75, 0x73, 0x2C, 0x20, 0x61, 0x74, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65,
    0x20, 0x6D, 0x61, 0x73, 0x73, 0x61, 0x20, 0x70, 0x6F, 0x73, 0x75, 0x65, 0x72, 0x65, 0x2E, 0x20, 0x55, 0x74, 0x20, 0x68, 0x65,
    0x6E, 0x64, 0x72, 0x65, 0x72, 0x69, 0x74, 0x20, 0x73, 0x6F, 0x64, 0x61, 0x6C, 0x65, 0x73, 0x20, 0x61, 0x75, 0x63, 0x74, 0x6F,
    0x72, 0x2E, 0x20, 0x44, 0x6F, 0x6E, 0x65, 0x63, 0x20, 0x75, 0x74, 0x20, 0x62, 0x6C, 0x61, 0x6E, 0x64, 0x69, 0x74, 0x20, 0x64,
    0x75, 0x69, 0x2C, 0x20, 0x65, 0x67, 0x65, 0x74, 0x20, 0x70, 0x75, 0x6C, 0x76, 0x69, 0x6E, 0x61, 0x72, 0x20, 0x65, 0x6C, 0x69,
    0x74, 0x2E, 0x20, 0x56, 0x69, 0x76, 0x61, 0x6D, 0x75, 0x73, 0x20, 0x6E, 0x69, 0x73, 0x6C, 0x20, 0x6C, 0x61, 0x63, 0x75, 0x73,
    0x2C, 0x20, 0x76, 0x75, 0x6C, 0x70, 0x75, 0x74, 0x61, 0x74, 0x65, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x74, 0x65, 0x6D, 0x70, 0x6F,
    0x72, 0x20, 0x69, 0x64, 0x2C, 0x20, 0x66, 0x65, 0x75, 0x67, 0x69, 0x61, 0x74, 0x20, 0x76, 0x65, 0x6C, 0x20, 0x71, 0x75, 0x61,
    0x6D, 0x2E};
