/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef NETDEVICES_H
#define NETDEVICES_H

class QPopupMenu;
namespace KSim
{
  class Chart;
  class Label;
  class LedLabel;
}

class NetDevice
{
 public:
   NetDevice() {}
   NetDevice(bool timer,
      const QString &format,
      bool commands,
      const QString &connectC,
      const QString &disconnectC,
      bool graph, bool label,
      const QString &device)
      : showTimer(timer),
      timerFormat(format),
      commandsEnabled(commands),
      cCommand(connectC),
      dCommand(disconnectC),
      showGraph(graph),
      showLabel(label),
      deviceName(device) {}

   NetDevice(const QString &item,
      bool timer,
      const QString &format,
      bool slabel,
      const QString &device,
      KSim::Chart *chart,
      KSim::LedLabel *led,
      KSim::Label *label,
      QPopupMenu *menu)
      : itemNo(item),
      showTimer(timer),
      timerFormat(format),
      showLabel(slabel),
      deviceName(device),
      netChart(chart),
      netLed(led),      
      netLabel(label),
      cMenu(menu) {}

    bool operator<(const NetDevice &rhs) const
    {
      return deviceName < rhs.deviceName;
    }

    bool operator>(const NetDevice &rhs) const
    {
      return deviceName > rhs.deviceName;
    }

    bool operator<=(const NetDevice &rhs) const
    {
      return !(*this > rhs);
    }

    bool operator==(const NetDevice &rhs) const
    {
      return (showTimer == rhs.showTimer &&
         timerFormat == rhs.timerFormat &&
         commandsEnabled == rhs.commandsEnabled &&
         cCommand == rhs.cCommand &&
         dCommand == rhs.dCommand &&
         showGraph == rhs.showGraph &&
         showLabel == rhs.showLabel &&
         deviceName == rhs.deviceName);
    }

   QString itemNo;
   bool showTimer;
   QString timerFormat;
   bool commandsEnabled;
   QString cCommand;
   QString dCommand;
   bool showGraph;
   bool showLabel;
   QString deviceName;
   KSim::Chart *netChart;
   KSim::LedLabel *netLed;
   KSim::Label *netLabel;
   QPopupMenu *cMenu;
};

typedef QValueList<NetDevice> DeviceList;
#endif
