/*  This file is part of the KDE project
    Copyright (C) 2002 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2
    as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
// $Id: confmodules.h,v 1.5 2002/08/25 14:38:26 mkretz Exp $

#ifndef CONFMODULES_H
#define CONFMODULES_H

#include "kpreferencesmodule.h"
#include <qptrlist.h>

namespace KImageViewer { class Canvas; }
class KInstance;
class GeneralConfigWidget;
class QCheckListItem;

class GeneralConfig : public KPreferencesModule
{
	Q_OBJECT
	public:
		GeneralConfig( KImageViewer::Canvas *, KInstance *, QObject * parent );
		~GeneralConfig();

	signals:
		void configChanged();

	protected:
		void applyChanges();
		void reset();
		void createPage( QFrame * page );

	private:
		KInstance * m_instance;
		KImageViewer::Canvas * m_pCanvas;
		GeneralConfigWidget * m_pWidget;
		QPtrList<QCheckListItem> m_items;
};

class KPluginSelector;

class PluginConfig : public KPreferencesModule
{
	Q_OBJECT
	public:
		PluginConfig( KInstance *, QObject * );
		~PluginConfig();

	signals:
		void configChanged();

	protected:
		void applyChanges();
		void reset();
		void createPage( QFrame * page );

	private:
		KInstance * m_instance;
		KPluginSelector * m_pPluginSelector;
};

// vim:sw=4:ts=4

#endif // CONFMODULES_H
