/*  This file is part of the KDE project
    Copyright (C) 2002 Matthias Kretz <kretz@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

*/
// $Id: kpreferencesdialog.h,v 1.3 2002/09/23 13:14:12 mkretz Exp $
//
// DESIGN:
//
// Things to consider:
// - Keep it simple and small. Every configuration page should be reachable
//   in the KPD. More than one dialog is bad.
// - Apps can load and unload different parts. It should always be clear how
//   to reach the preferences for those parts.
//   Since GUI merging already takes place (e.g. menu/toolbar entries are
//   added/removed) why not merge dialogs? Hmm actually it already happens:
//   the KEditToolbar Dialog changes when a different part is activated in
//   Konqueror.
//   Now, using Konqueror, if an image is shown, using the KView part, the
//   preferences for the part need to be available somewhere. Two
//   possibilities come to mind: An action is added to open a dialog for them
//   or the preferences dialog of the shell (Konqueror) includes the pages
//   from the part. The GUI changes - no way to avoid that. The only question
//   is: what is better? more logical?
//   Currently in Konqueror there's an action called "Configure Konqueror".
//   This gives you a dialog where you can configure the KHTML part and
//   Konqueror itself. Of course there is a pretty strong relationship between
//   the KHTML part and Konqueror but still it's not entirely logical.
//   Why would I want to configure the KHTML part preferences if I'm looking
//   at my home directory. I'd rather want to change the KonqDir part
//   settings. And if I open an image in Konqueror (using KView) and I open up
//   the Preferences Dialog I want to see the whole configuration for the
//   program I'm currently using - and that program currently is an image
//   viewer.
// - KOffice:
//   In KOffice it happens that you embed a part in a part. Since both parts
//   are available to you in the program you see, the preferences dialog should
//   include the configuration for both. If you then remove the embedded part,
//   so that only the first part remains, the preferences for that part
//   need to be removed from the dialog. I consider this part of the GUI
//   merging.
//
// - The problem with a singleton approach would be apps that show
//   multiple instances while only using one UNIX process. E.g. Konqueror
//   showing a Webpage and an image in two different windows sharing the
//   process would create a dialog with Konq, khtml and kview preferences.
// - Ideally every MainWindow would own a KPD. But how?
// (
// - KP belongs to GUI merging and therefore into the KXMLGUI stuff.
// - KPMs need a parent KXMLGUIClient - whether they need to be one
//   themselves I don't know, yet.
// - The KPD though needs to find all KPMs that belong to the KXMLGUIClient
//   tree it's responsible for. KXMLGUIClients could provide a method for
//   returning a list of KPMs or the KPMs would search through the tree for
//   the KPD on creation - then I'd need a method returning the KPD.
// )
//
// How can a KPM find a KPD?
// - The KPM looks at all the QObject children of its parent. If there is no
//   KPD it looks at the children of that one's parent. If there is none, it
//   goes on so forth. If finally there's no parent left it needs to create a
//   new KPD. The KPD's parent is the parent of the KPM.
//
// How could a KPD find KPMs?
// - The KPMs are already created. If a KPD is created it searches recursively
//   through all the children of its parent for KPMs.
//
#ifndef KPREFERENCESDIALOG_H
#define KPREFERENCESDIALOG_H

#include <qobject.h>

class KPreferencesDialog : public QObject
{
	friend class KPreferencesModule;

	Q_OBJECT
	public:
		KPreferencesDialog( QObject * parent, const char * name = 0 );
		~KPreferencesDialog();

	public slots:
		/**
		 * Creates the dialog and shows it.
		 */
		void show();

	protected:
		void registerModule( KPreferencesModule * );
		void setGroupName( KPreferencesModule *, const QString & name );
		void createMenuEntry();

	protected slots:
		void unregisterModule( QObject * );
		void slotApply();
		void slotOk();
		void slotFinished();

	private:
		void createPage( KPreferencesModule * );

		class KPreferencesDialogPrivate;
		KPreferencesDialogPrivate * d;
};

// vim: sw=4 ts=4 tw=78
#endif // KPREFERENCESDIALOG_H
