// $Id: kundo.h,v 1.5 2002/09/02 16:56:27 winkvist Exp $

#ifndef KUNDO_H
#define KUNDO_H

#include <qptrlist.h>

/**
 You must subclass this class to record your undo data. You can override the
 size method to allow the KUndo class size limit to operate by size, by default
 it operates by the number of items in the undo list. Overriding the tag method
 allows you to store more than one type of undo data in the list and identify
 them to check your downcast is ok. 
 */
class KUndoData
{
public:
    virtual ~KUndoData() { };
    virtual const char *tag() { return NULL; };
    virtual int size() { return 1; };
};

/**
 * This class manages the undo list for an application
 * NB size is only per item for now
 */
class KUndo
{
public:
    /**
     *
     */
    KUndo(int maxsize_= 10);

    /**
     *
     */
    virtual ~KUndo();

    /**
     *
     */
    void record(KUndoData *);

    /**
     *
     */
    KUndoData *undo();

    /**
     *
     */
    KUndoData *redo();

    /**
     *
     */
    void clear();

    /**
     *
     */
    bool canUndo();

    /**
     *
     */
    bool canRedo();

    /**
     *
     */
    void setMaxSize(int maxsize_);

    /**
     *
     */
    int maxSize();

protected:
    virtual void checksize();
    QPtrList <KUndoData> undoList;

private:
    int behind;
    int infront;
    int maxsize;
};

#endif // KUNDO_H
