// Qt-CSharp tutorial 4
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class MyWidget : QWidget {

	public MyWidget (QWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		this.SetMinimumSize (200, 120);
		this.SetMaximumSize (200, 120);
		
		QPushButton quit = new QPushButton ("Quit", this, "quit");
		quit.SetGeometry (62, 40, 75, 30);
		quit.SetFont (new QFont ("Times", 18, QFont.Weight.Bold) );
		
		Connect ( quit, SIGNAL ("clicked()"), qApp, SLOT ("Quit()") );
		// In C++, qApp is a global variable. Here it's a property of the QObject
		// class, which we inherit, giving the same effect. We also inherit the
		// static method connect().
	}
	
	public MyWidget (QWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.
}

public class Example {

	public static int Main (String[] args)
	{
		QApplication a = new QApplication (args);
		
		MyWidget w = new MyWidget ();
		w.SetGeometry (100, 100, 200, 120);
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
