package org.kde.qt;


/** {@link QListView} emits these signals */
public interface QListViewSignals {
	void pressed( QListViewItem arg1, QPoint arg2, int arg3 );
	void verticalSliderPressed();
	void horizontalSliderPressed();
	void rightButtonClicked( QListViewItem arg1, QPoint arg2, int arg3 );
	void rightButtonPressed( QListViewItem arg1, QPoint arg2, int arg3 );
	void onViewport();
	void onItem( QListViewItem item );
	void returnPressed( QListViewItem arg1 );
	void contentsMoving( int x, int y );
	void dropped( QDropEvent e );
	void currentChanged( QListViewItem arg1 );
	void itemRenamed( QListViewItem item, int col );
	void destroyed( QObject obj );
	void contextMenuRequested( QListViewItem arg1, QPoint arg2, int arg3 );
	void verticalSliderReleased();
	void selectionChanged( QListViewItem arg1 );
	void doubleClicked( QListViewItem arg1 );
	void horizontalSliderReleased();
	void spacePressed( QListViewItem arg1 );
	void expanded( QListViewItem item );
	void mouseButtonClicked( int arg1, QListViewItem arg2, QPoint arg3, int arg4 );
	void collapsed( QListViewItem item );
	void mouseButtonPressed( int arg1, QListViewItem arg2, QPoint arg3, int arg4 );
	void clicked( QListViewItem arg1, QPoint arg2, int arg3 );
}

