/***************************************************************************
                            TransferJob.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFERJOB_H
#define TRANSFERJOB_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/SimpleJob.h>

/**

 The transfer job pumps data into and/or out of a Slave.
 Data is sent to the slave on request of the slave (@ref dataReq).
 If data coming from the slave can not be handled, the
 reading of data from the slave should be suspended.
     
 @short 
 The transfer job pumps data into and/or out of a Slave.
*/
@interface TransferJob : SimpleJob 
- initWithURL: (KURL*)url command: (int)command packedArgs: (QByteArray*)packedArgs _staticData: (QByteArray*)_staticData showProgressInfo: (BOOL)showProgressInfo;
- start: (Slave*)slave;

/** 
 Called when m_subJob finishes.
         
*/
- slotResult: (Job*)job;

/** 
 Flow control. Suspend data processing from the slave.
         
*/
- suspend;

/** 
 Flow control. Resume data processing from the slave.
         
*/
- resume;

/** 
 Flow control. Returns true if the job is suspended.
         
*/
- (BOOL) isSuspended;

/** 

*/
- (BOOL) isErrorPage;
- slotRedirection: (KURL*)url;
- slotFinished;
- slotData: (QByteArray*)data;
- slotDataReq;
- slotMimetype: (NSString *)mimetype;
- slotNeedSubURLData;
- slotSubURLData: (Job*)arg1 bytearray: (QByteArray*)arg2;
- slotErrorPage;
- slotCanResume: (unsigned long)offset;
@end

/** Override these methods in subclasses of TransferJob to customise event handling behaviour */
@protocol TransferJobEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
