/***************************************************************************
                            DeviceManager.m -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#include <qtc/qt_QString.h>
#include <qtc/qt_QCString.h>
#include <kdec/kde_DeviceManager.h>
#include <kdeobjc/KDESupport.h>
#include <kdeobjc/DeviceManager.h>
#include <kdeobjc/MidiMapper.h>


@implementation  DeviceManager

- (void *) qt
{
	return _qt;
}

- setQt: (void *) qt
{
	_qt = qt;
	return self;
}

- (BOOL) allocatedInObjcWorld
{
	return _allocatedInObjcWorld;
}

- setAllocatedInObjcWorld: (BOOL) yn
{
	_allocatedInObjcWorld = yn;
	return self;
}


- initWithInt: (int)def
{
	if ([self qt] == 0L) {
		[self setQt: kde_new_DeviceManager((int)def)];
		[self setAllocatedInObjcWorld: YES];
		[QtSupport setObject: self forQtKey: [self qt]];
	}
	[super init];
	return self;
}

- init
{
	if ([self qt] == 0L) {
		[self setQt: kde_new_DeviceManager(-1)];
		[self setAllocatedInObjcWorld: YES];
		[QtSupport setObject: self forQtKey: [self qt]];
	}
	[super init];
	return self;
}

- (void) dealloc
{
	if ([self qt] != 0L) {
		if ([self allocatedInObjcWorld]) {
			kde_del_DeviceManager((kde_DeviceManager *)[self qt]);
		}
		[QtSupport removeQtKey: [self qt]];
		[self setQt: 0L];
	}
	[super dealloc];
}

- (int) initManager
{
	return (int) kde_DeviceManager_initManager((kde_DeviceManager *)[self qt]);
}

- (int) checkInit
{
	return (int) kde_DeviceManager_checkInit((kde_DeviceManager *)[self qt]);
}

- (MidiOut*) chntodev: (int)chn
{
	return (MidiOut*) [QtSupport objectForQtKey: kde_DeviceManager_chntodev((kde_DeviceManager *)[self qt], (int)chn) withClass: [MidiOut class] allocatedInObjcWorld: YES];
}

- (MidiOut*) deviceForChannel: (int)chn
{
	return (MidiOut*) [QtSupport objectForQtKey: kde_DeviceManager_deviceForChannel((kde_DeviceManager *)[self qt], (int)chn) withClass: [MidiOut class] allocatedInObjcWorld: YES];
}

- (int) deviceNumberForChannel: (int)chn
{
	return (int) kde_DeviceManager_deviceNumberForChannel((kde_DeviceManager *)[self qt], (int)chn);
}

- setDeviceNumberForChannel: (int)chn dev: (int)dev
{
	kde_DeviceManager_setDeviceNumberForChannel((kde_DeviceManager *)[self qt], (int)chn, (int)dev);
	return self;
}

- (int) ok
{
	return (int) kde_DeviceManager_ok((kde_DeviceManager *)[self qt]);
}

- (int) usingAlsa
{
	return (int) kde_DeviceManager_usingAlsa((kde_DeviceManager *)[self qt]);
}

- openDev
{
	kde_DeviceManager_openDev((kde_DeviceManager *)[self qt]);
	return self;
}

- closeDev
{
	kde_DeviceManager_closeDev((kde_DeviceManager *)[self qt]);
	return self;
}

- initDev
{
	kde_DeviceManager_initDev((kde_DeviceManager *)[self qt]);
	return self;
}

- noteOn: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel
{
	kde_DeviceManager_noteOn((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)note, (unsigned char)vel);
	return self;
}

- noteOff: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel
{
	kde_DeviceManager_noteOff((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)note, (unsigned char)vel);
	return self;
}

- keyPressure: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel
{
	kde_DeviceManager_keyPressure((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)note, (unsigned char)vel);
	return self;
}

- chnPatchChange: (unsigned char)chn patch: (unsigned char)patch
{
	kde_DeviceManager_chnPatchChange((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)patch);
	return self;
}

- chnPressure: (unsigned char)chn vel: (unsigned char)vel
{
	kde_DeviceManager_chnPressure((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)vel);
	return self;
}

- chnPitchBender: (unsigned char)chn lsb: (unsigned char)lsb msb: (unsigned char)msb
{
	kde_DeviceManager_chnPitchBender((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)lsb, (unsigned char)msb);
	return self;
}

- chnController: (unsigned char)chn ctl: (unsigned char)ctl v: (unsigned char)v
{
	kde_DeviceManager_chnController((kde_DeviceManager *)[self qt], (unsigned char)chn, (unsigned char)ctl, (unsigned char)v);
	return self;
}

- sysEx: (unsigned char*)data size: (unsigned long)size
{
	kde_DeviceManager_sysEx((kde_DeviceManager *)[self qt], (unsigned char*)data, (unsigned long)size);
	return self;
}

- wait: (double)ms
{
	kde_DeviceManager_wait((kde_DeviceManager *)[self qt], (double)ms);
	return self;
}

- tmrSetTempo: (int)v
{
	kde_DeviceManager_tmrSetTempo((kde_DeviceManager *)[self qt], (int)v);
	return self;
}

- tmrStart: (long)tpcn
{
	kde_DeviceManager_tmrStart((kde_DeviceManager *)[self qt], (long)tpcn);
	return self;
}

- tmrStop
{
	kde_DeviceManager_tmrStop((kde_DeviceManager *)[self qt]);
	return self;
}

- tmrContinue
{
	kde_DeviceManager_tmrContinue((kde_DeviceManager *)[self qt]);
	return self;
}

- allNotesOff
{
	kde_DeviceManager_allNotesOff((kde_DeviceManager *)[self qt]);
	return self;
}

- sync: (BOOL)f
{
	kde_DeviceManager_sync((kde_DeviceManager *)[self qt], (int)f);
	return self;
}

- sync
{
	kde_DeviceManager_sync((kde_DeviceManager *)[self qt], 0);
	return self;
}

- setVolumePercentage: (int)i
{
	kde_DeviceManager_setVolumePercentage((kde_DeviceManager *)[self qt], (int)i);
	return self;
}

- (int) defaultDevice
{
	return (int) kde_DeviceManager_defaultDevice((kde_DeviceManager *)[self qt]);
}

- setDefaultDevice: (int)i
{
	kde_DeviceManager_setDefaultDevice((kde_DeviceManager *)[self qt], (int)i);
	return self;
}

- (int) setPatchesToUse: (int*)patchesused
{
	return (int) kde_DeviceManager_setPatchesToUse((kde_DeviceManager *)[self qt], (int*)patchesused);
}

- (NSString *) midiMapFilename
{
	return (NSString *) [NSString stringWithCString: kde_DeviceManager_midiMapFilename((kde_DeviceManager *)[self qt])];
}

- setMidiMap: (MidiMapper*)map
{
	kde_DeviceManager_setMidiMap((kde_DeviceManager *)[self qt], (kde_MidiMapper*) [map qt]);
	return self;
}

- (int) rate
{
	return (int) kde_DeviceManager_rate((kde_DeviceManager *)[self qt]);
}

- (int) midiPorts
{
	return (int) kde_DeviceManager_midiPorts((kde_DeviceManager *)[self qt]);
}

- (int) synthDevices
{
	return (int) kde_DeviceManager_synthDevices((kde_DeviceManager *)[self qt]);
}

- (NSString *) name: (int)i
{
	return (NSString *) [NSString stringWithCString: kde_DeviceManager_name((kde_DeviceManager *)[self qt], (int)i)];
}

- (NSString *) type: (int)i
{
	return (NSString *) [NSString stringWithCString: kde_DeviceManager_type((kde_DeviceManager *)[self qt], (int)i)];
}

- seqbuf_dump
{
	kde_DeviceManager_seqbuf_dump((kde_DeviceManager *)[self qt]);
	return self;
}

- seqbuf_clean
{
	kde_DeviceManager_seqbuf_clean((kde_DeviceManager *)[self qt]);
	return self;
}

- checkAlsa
{
	kde_DeviceManager_checkAlsa((kde_DeviceManager *)[self qt]);
	return self;
}

@end
