/***************************************************************************
                            KURLComboBox.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This combobox shows a number of recent URLs/directories, as well as some
 default directories.
 It will manage the default dirs root-directory, home-directory and
 Desktop-directory, as well as a number of URLs set via {@link #setURLs}
 and one additional entry to be set via {@link #setURL}.

 See {@link KURLComboBoxSignals} for signals emitted by KURLComboBox.

 

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A combo box showing a number of recent URLs/directories.
*/
public class KURLComboBox extends KComboBox  {
	protected KURLComboBox(Class dummy){super((Class) null);}

	private native void newKURLComboBox( int mode, QWidget parent, String name);

/** 
 Constructs a KURLComboBox.

*/
	public KURLComboBox( int mode, QWidget parent, String name) {
		super((Class) null);
		newKURLComboBox( mode, parent, name);
	}
	private native void newKURLComboBox( int mode);
	public KURLComboBox( int mode) {
		super((Class) null);
		newKURLComboBox( mode);
	}
	private native void newKURLComboBox( int mode, boolean rw, QWidget parent, String name);
	public KURLComboBox( int mode, boolean rw, QWidget parent, String name) {
		super((Class) null);
		newKURLComboBox( mode, rw, parent, name);
	}
	private native void newKURLComboBox( int mode, boolean rw);
	public KURLComboBox( int mode, boolean rw) {
		super((Class) null);
		newKURLComboBox( mode, rw);
	}

/** 
 Destructs the combo box.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the current url. This combo handles exactly one url additionally
 to the default items and those set via {@link #setURLs}. So you can call
 setURL() as often as you want, it will always replace the previous one
 set via setURL().
 If <code>url</code> is already in the combo, the last item will stay there
 and the existing item becomes the current item.
 The current item will always have the open-directory-pixmap as icon.

 Note that you won't receive any signals, e.g. textChanged(),
 returnPressed() or activated() upon calling this method.
     
*/
	public native void setURL( KURL url);

/** 
 Inserts <code>urls</code> into the combobox below the "default urls" (see
 {@link addDefaultURL}).

 If the list of urls contains more items than maxItems, the first items
 will be stripped.
     
*/
	public native void setURLs( String[] urls);

/** 
 Inserts <code>urls</code> into the combobox below the "default urls" (see
 {@link addDefaultURL}).

 If the list of urls contains more items than maxItems, the <code>remove</code>
 parameter determines whether the first or last items will be stripped.
     
*/
	public native void setURLs( String[] urls, int remove);

/** 

*/
	public native ArrayList urls();

/** 
 Sets how many items should be handled and displayed by the combobox.

*/
	public native void setMaxItems( int arg1);

/** 

*/
	public native int maxItems();

/** 
 Adds a url that will always be shown in the combobox, it can't be
 "rotated away". Default urls won't be returned in {@link #urls} and don't
 have to be set via {@link #setURLs}.
 If you want to specify a special pixmap, use the overloaded method with
 the pixmap parameter.
 Default URLs will be inserted into the combobox by {@link #setDefaults}
     
*/
	public native void addDefaultURL( KURL url, String text);
	public native void addDefaultURL( KURL url);

/** 
 Adds a url that will always be shown in the combobox, it can't be
 "rotated away". Default urls won't be returned in {@link #urls} and don't
 have to be set via {@link #setURLs}.
 If you don't need to specify a pixmap, use the overloaded method without
 the pixmap parameter.
 Default URLs will be inserted into the combobox by {@link #setDefaults}
     
*/
	public native void addDefaultURL( KURL url, QPixmap pix, String text);
	public native void addDefaultURL( KURL url, QPixmap pix);

/** 
 Clears all items and inserts the default urls into the combo. Will be
 called implicitly upon the first call to {@link #setURLs} or {@link #setURL}

*/
	public native void setDefaults();

/** 
 Removes any occurence of <code>url.</code> If <code>checkDefaultURLs</code> is false
 default-urls won't be removed.
     
*/
	public native void removeURL( KURL url, boolean checkDefaultURLs);
	public native void removeURL( KURL url);
	protected native void init( int mode);
//	protected native void insertURLItem( KURLComboItem arg1);

/** 
 Uses KMimeType.pixmapForURL() to return a proper pixmap for <code>url.</code>
 In directory mode, a folder icon is always returned.
     
*/
	protected native QPixmap getPixmap( KURL url);

/** 
 Updates <code>item</code> with <code>pixmap</code> and sets the url instead of the text
 of the KURLComboItem.
 Also works around a Qt bug.
     
*/
//	protected native void updateItem( KURLComboItem item, int index, QPixmap pix);
	protected native void slotActivated( int arg1);
	public static final int Files = -1;
	public static final int Directories = 1;
	public static final int Both = 0;
	public static final int RemoveTop = 0;
	public static final int RemoveBottom = 1;
}
