/***************************************************************************
                            KFileDetailView.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A list-view capable of showing {@link KFileItem}'. Used in the filedialog
 for example. Most of the documentation is in {@link KFileView} class.

 See {@link KFileDetailViewSignals} for signals emitted by KFileDetailView.

 

 @short *
 A list-view capable of showing @ref KFileItem'.
*/
public class KFileDetailView extends KListView implements  KFileViewInterface {
	protected KFileDetailView(Class dummy){super((Class) null);}

	private native void newKFileDetailView( QWidget parent, String name);
	public KFileDetailView( QWidget parent, String name) {
		super((Class) null);
		newKFileDetailView( parent, name);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native QWidget widget();
	public native void clearView();
	public native void setAutoUpdate( boolean arg1);
	public native void setSelectionMode( int sm);
	public native void updateView( boolean arg1);
	public native void updateView( KFileItem arg1);
	public native void removeItem( KFileItem arg1);
	public native void listingCompleted();
	public native void setSelected( KFileItem arg1, boolean arg2);
	public native boolean isSelected( KFileItem i);
	public native void clearSelection();
	public native void selectAll();
	public native void invertSelection();
	public native void setCurrentItem( KFileItem arg1);
	public native KFileItem currentFileItem();
	public native KFileItem firstFileItem();
	public native KFileItem nextItem( KFileItem arg1);
	public native KFileItem prevItem( KFileItem arg1);
	public native void insertItem( KFileItem i);
	public native void setSorting( int arg1);
	public native void ensureItemVisible( KFileItem arg1);
	public native void mimeTypeDeterminationFinished();
	public native void determineIcon( KFileListViewItem item);
	public native QScrollView scrollWidget();
	protected native void keyPressEvent( QKeyEvent arg1);
	protected native void virtual_hook( int identifier, int data);
	protected native void slotSelectionChanged();

        // From KFileView

/**
 Sets <code>filename</code> the current item in the view, if available.

*/
	public native void setCurrentItem( String filename);

/**
 Clears the view and all item lists.

*/
	public native void clear();

	public native void updateView();


/**
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.

*/
	public native boolean sorting();


/**
 Tells whether the current items are in reversed order (shortcut to
 sorting() & QDir.Reversed).

*/
	public native boolean isReversed();
	public native void sortReversed();

/**

*/
	public native int count();

/**

*/
	public native int numFiles();

/**

*/
	public native int numDirs();
	public native int selectionMode();
	public native void setViewMode( int vm);
	public native int viewMode();

/**

*/
	public native String viewName();

/**
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".

*/
	public native void setViewName( String name);
	public native void setParentView( KFileViewInterface parent);




/**

*/
	public native ArrayList selectedItems();

/**

*/
	public native ArrayList items();

/**
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on {@link #onlyDoubleClickSelectsFiles}.

*/
	public native void setOnlyDoubleClickSelectsFiles( boolean enable);

/**

*/
	public native boolean onlyDoubleClickSelectsFiles();

/**
 increases the number of dirs and files.

*/
	public native boolean updateNumbers( KFileItem i);

/**

*/
	public native KActionCollection actionCollection();
	public native KFileViewSignaler signaler();
	public native void readConfig( KConfig arg1, String group);
	public native void readConfig( KConfig arg1);
	public native void writeConfig( KConfig arg1, String group);
	public native void writeConfig( KConfig arg1);
	public static native String sortingKey( String value, boolean isDir, int sortSpec);
	public static native String sortingKey( int value, boolean isDir, int sortSpec);

}
