package org.kde.koala;
import org.kde.qt.*;


/** {@link KEdit} emits these signals */
public interface KEditSignals {
	void redoAvailable( boolean yes );
	void undoAvailable( boolean yes );
	void currentAlignmentChanged( int a );
	void verticalSliderPressed();
	void horizontalSliderPressed();
	void textChanged();
	void returnPressed();
	void contentsMoving( int x, int y );
	void destroyed( QObject obj );
	void currentFontChanged( QFont f );
	void cursorPositionChanged( int para, int pos );
	void verticalSliderReleased();
	void modificationChanged( boolean m );
	void selectionChanged();

/**  This signal is emitted if the user dropped a URL over the text editor
 {@link QMultiLineEdit} widget.

  Note that the user can drop also Text on it, but
 this is already handled internally by QMultiLineEdit.
      
*/
	void gotUrlDrop( QDropEvent e );
	void doubleClicked( int parag, int index );
	void horizontalSliderReleased();

/**  This signal is emitted whenever the cursor position changes.

 Use this in conjunction with {@link KEdit#currentLine}, {@link KEdit#currentColumn}
 if you need to know the cursor position.
     
*/
	void CursorPositionChanged();
	void currentColorChanged( QColor c );
	void copyAvailable( boolean arg1 );
	void currentVerticalAlignmentChanged( int a );

/** 
 This signal is emitted if the user toggles from insert to overwrite mode
 or vice versa.

 The user can do so by pressing the "Insert" button on a PC keyboard.

 This feature must be activated by calling {@link KEdit#setOverwriteEnabled}
 first.
     
*/
	void toggle_overwrite_signal();
	void clicked( int parag, int index );
}

