/***************************************************************************
                            kde_KIPC.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KIPC
#define KDE_KIPC

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class implements a very simple IPC mechanism for KDE. You can send
 a message of a predefined type to either a specific application, or to all
 KDE application on the current display. The message can carry one integer of
 data.

 KIPC is mainly used in KDE for sending "Change Messages", i.e. a message to
 all KDE apps that a certain setting (the font, for example) has changed.
 For anything more complex it is recommended to use DCOP -- the Desktop
 Communications Protocol.

 Messages with id code < 32 are called "System Messages". These are
 directly handled by KApplication. Examples are: PaletteChanged and
 StyleChanged. Messages with id code >= 32 are user messages. KApplication
 emits the signal kipcMessage(id,arg) for each user message it receives.

 KIPC is implemented using X11 ClientMessage events.

 @author Geert Jansen <jansen@kde.org>

 @version $Id: kde_KIPC.h,v 1.4 2002/11/25 12:24:34 rdale Exp $
 
 @short *
 This class implements a very simple IPC mechanism for KDE.
*/
#define KIPC_PaletteChanged	0
#define KIPC_FontChanged	0
#define KIPC_StyleChanged	1
#define KIPC_BackgroundChanged	2
#define KIPC_SettingsChanged	3
#define KIPC_IconChanged	4
#define KIPC_ToolbarStyleChanged	5
#define KIPC_ClipboardConfigChanged	6
#define KIPC_UserMessage	32

/** *
 Send a message to a specific application.

*/
void kde_KIPC_sendMessage( int msg, unsigned int w, int data);

/** *
 Send a message to all KDE application on the current display.

*/
void kde_KIPC_sendMessageAll( int msg, int data);

#endif
