#ifndef __L_MOUSE_TESTER_H__
#define __L_MOUSE_TESTER_H__


#include <qwidget.h>


class LMouseTester : public QWidget
{
  Q_OBJECT

public:

  LMouseTester(QWidget *parent=0, const char *name=0);
  ~LMouseTester();


public slots:

  void setMouseConfig(int buttons, int wheels);
  void resetState();


protected:

  void paintEvent(QPaintEvent *);
  bool eventFilter(QObject *, QEvent *);

//  bool x11Event(XEvent *);

  void mouseMoveEvent(QMouseEvent *);
  void focusInEvent(QFocusEvent *) {};
  void focusOutEvent(QFocusEvent *) {};

  virtual void paintState( bool = false);
  ButtonState state;
  int wheelOffset;
  int _wheels, _buttons;

};


#endif
