//////////////////////////////////////////////////////////////
//      $Id: slackInterface.h,v 1.20 2002/06/07 11:44:59 coolo Exp $
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef SLACK_IFACE_H
#define SLACK_IFACE_H

#include "../config.h"

#include <qptrlist.h>
#include <kprocess.h>

#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class SLACK: public pkgInterface
{
  Q_OBJECT

public:
  SLACK();
  ~SLACK();

  bool isType(char *buf, const QString &fname);

  packageInfo *getPackageInfo(char mode, const QString &name,
			      const QString &version);
  QStringList getFileList(packageInfo *p);

  QStringList FindFile(const QString &name);
  bool parseName(const QString& name, QString *n, QString *v);

  QString install(int installFlags, QPtrList<packageInfo> *plist, bool &test);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(const char *inp, int insState);
   void listInstalledPackages(QPtrList<packageInfo> *pki);

  QString doUninstall(int installFlags, QString packs, bool &test);
  QString doInstall(int installFlags, QString packs, bool &test);

  void listPackages(QPtrList<packageInfo> *pki);
  void listPackList(QPtrList<packageInfo> *pki, QString s,
		    cacheObj *cp, int insState);

  void initTranslate();

  void smerge(packageInfo *p);

  QDict<QString> *trl;
};

#endif



