#include "factory.h"

#include "ai.h"
#include "base/settings.h"
#include "settings.h"


CommonFactory::CommonFactory(const MainData &md, const BaseBoardInfo &bbi,
                             const CommonBoardInfo &ci)
    : BaseFactory(md, bbi), cbi(ci)
{}

KConfigWidget *CommonFactory::createGameConfig()
{
    return new GameConfig;
}

KConfigWidget *CommonFactory::createAIConfig()
{
    AI *ai = createAI();
    KConfigWidget *cw = ai->createConfigWidget();
    delete ai;
    return cw;
}
