/***************************************************************************
                            KSpell.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSPELL_H
#define KSPELL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 KDE Spellchecker

 A KDE programmer's interface to International ISpell 3.1.  (GPL 1997)
 A static method, @ref -modalCheck is provided for convenient
  access to the spellchecker.

 @author David Sweet <dsweet@kde.org>

 @version $Id: KSpell.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short 
 KDE Spellchecker

*/
@class KProcIO; 
@class KProcess; 
@class KSpellConfig; 

@interface KSpell : QObject 

/** 
 Starts the spellchecker.

 KSpell emits @ref -ready when it has verified that 
 ISpell/ASpell is working properly. Pass the name of a slot -- do not pass zero!
 Be sure to call @ref -cleanUp when you are done with KSpell.

 If KSpell could not be started correctly, @ref -death is emitted.

*/
- initWithWidget: (QWidget *)_parent _caption: (NSString *)_caption obj: (QObject *)obj slot: (NSString *)slot _kcs: (KSpellConfig*)_kcs _progressbar: (BOOL)_progressbar _modal: (BOOL)_modal;
- initWithWidget: (QWidget *)_parent _caption: (NSString *)_caption obj: (QObject *)obj slot: (NSString *)slot ;

/** 
 Returns the status of KSpell.

*/
- (int) status;

/** 
 Cleans up ISpell.

 Write out the personal dictionary and close ISpell's
  stdin.  A @ref -death signal will be emitted when the cleanup is
  complete, but this method will return immediately.

*/
- cleanUp;

/**  
 Sets the auto-delete flag. If this is set, the KSpell object
 is automatically deleted after emitting @ref -death.
   
*/
- setAutoDelete: (BOOL)_autoDelete;

/** 
  Spellchecks a buffer of many words in plain text 
  format.

 The @p _buffer is not modified.  The signal @ref -done will be
  sent when @ref -check is finished and the argument will be a 
  spell-corrected version of @p _buffer.  

 The spell check may be stopped by the user before the entire buffer
  has been checked.  You can check @ref -lastPosition to see how far
  in @p _buffer @ref -check reached before stopping.
   
*/
- (BOOL) check: (NSString *)_buffer;

/** 
 Returns the position (when using @ref -check)  or word 
 number (when using @ref -checkList) of
 the last word checked.

*/
- (int) lastPosition;

/** 
 Spellchecks a list of words.

 @ref -checkList is more flexible than @ref -check.  You could parse
  any type
  of document (HTML, TeX, etc.) into a list of spell-checkable words
  and send the list to @ref -checkList.  Sending a marked-up document
  to @ref -check would result in the mark-up tags being
  spell checked.
   
*/
- (BOOL) checkList: (NSArray *)_wordlist;

/** 
 Spellchecks a single word.

 -checkWord is the most flexible function.  Some applications
  might need this flexibility but will sacrifice speed when
  checking large numbers of words.  Consider @ref -checkList for
  checking many words.

  Use this method for implementing  "online" spellchecking (i.e.,
  spellcheck as-you-type).

 -checkWord returns @p false if @p buffer is not a single word (e.g.
  if it contains white space), otherwise it returns @p true;

 If @p usedialog is set to @p true, KSpell will open the standard
  dialog if the word is not found.  The dialog results can be queried
  by using  @ref -dlgResult and @ref -replacement. 

  The signal @ref -corrected is emitted when the check is
  complete.  You can look at @ref -suggestions to see what the
  suggested replacements were. 
   
*/
- (BOOL) checkWord: (NSString *)_buffer usedialog: (BOOL)usedialog;
- (BOOL) checkWord: (NSString *)_buffer ;

/** 
 Hides the dialog box.

 You'll need to do this when you are done with @ref -checkWord;
   
*/
- hide;

/** 
 Returns list of suggested word replacements.

 After calling @ref -checkWord (an in response to
  a @ref -misspelled signal you can
  use this to get the list of
  suggestions (if any were available).
   
*/
- (NSArray *) suggestions;

/** 
 Gets the result code of the dialog box.

 After calling checkWord, you can use this to get the dialog box's
  result code.
 The possible
  values are (from kspelldlg.h):

   
*/
- (int) dlgResult;

/** 
 Moves the dialog.

 If the dialog is not currently visible, it will
   be placed at this position when it becomes visible.
 Use this to get the dialog out of the way of a highlighted
 misspelled word in a document.
   
*/
- moveDlg: (int)x y: (int)y;

/** 
 Returns the height of the dialog box.

*/
- (int) heightDlg;

/** 
 Returns the width of the dialog box.

*/
- (int) widthDlg;

/** 
 Returns the partially spellchecked buffer.

 You might want the full buffer in its partially-checked state.
   
*/
- (NSString *) intermediateBuffer;

/** 
 Tells ISpell/ASpell to ignore this word for the life of this KSpell instance.

  @ref -ignore returns @p false if word is not a word or there was an error
  communicating with ISpell/ASpell.
   
*/
- (BOOL) ignore: (NSString *)word;

/** 
 Adds a word to the user's personal dictionary. 

 Returns @p false if @p word
  is not a word or there was an error communicating with ISpell/ASpell.
   
*/
- (BOOL) addPersonal: (NSString *)word;

/** 
 Retrurns the @ref KSpellConfig object being used by this KSpell instance.
   
*/
- (KSpellConfig*) ksConfig;

/** 
 Sets the resolution (in percent) of the @ref -progress signals.

 E.g. @ref setProgressResolution (10) instructs KSpell to send progress
  signals (at most) every 10% (10%, 20%, 30%...).
 The default is 10%.
   
*/
- setProgressResolution: (unsigned int)res;

/** 
 The destructor instructs ISpell/ASpell to write out the personal
  dictionary and then terminates ISpell/ASpell.
   
*/
- (void) dealloc;
- setIgnoreUpperWords: (BOOL)_b;
- setIgnoreTitleCase: (BOOL)_b;

/** 
 Performs a sychronous spellcheck.

 This method does not return until spellchecking is done or canceled.
 Your application's GUI will still be updated, however.
   
*/
+ (int) modalCheck: (NSString *)text;

/** 
 Used local spell config
   
*/
+ (int) modalCheck: (NSString *)text _kcs: (KSpellConfig*)_kcs;
- (int) parseOneResponse: (NSString *)_buffer word: (NSString *)word sugg: (NSArray *)sugg;
- (NSString *) funnyWord: (NSString *)word;
- dialog: (NSString *)word sugg: (NSArray *)sugg _slot: (NSString *)_slot;
- (NSString *) replacement;
- setUpDialog: (BOOL)reallyusedialogbox;
- setUpDialog;
- emitProgress;
- (BOOL) cleanFputs: (NSString *)s appendCR: (BOOL)appendCR;
- (BOOL) cleanFputs: (NSString *)s ;
- (BOOL) cleanFputsWord: (NSString *)s appendCR: (BOOL)appendCR;
- (BOOL) cleanFputsWord: (NSString *)s ;
- startIspell;
- (BOOL) writePersonalDictionary;
- KSpell2: (KProcIO*)arg1;
- checkWord2: (KProcIO*)arg1;
- checkWord3;
- check2: (KProcIO*)arg1;
- checkList2;
- checkList3a: (KProcIO*)arg1;
- checkListReplaceCurrent;
- checkList4;
- dialog2: (int)dlgresult;
- check3;
- slotStopCancel: (int)arg1;
- ispellExit: (KProcess*)arg1;
- emitDeath;
- ispellErrors: (KProcess*)arg1 string: (NSString *)arg2 int: (int)arg3;
+ (int) Starting;
+ (int) Running;
+ (int) Cleaning;
+ (int) Finished;
+ (int) Error;
+ (int) Crashed;
@end

/** Override these methods in subclasses of KSpell to customise event handling behaviour */
@protocol KSpellEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
