/***************************************************************************
                            KSSLCertificate.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSSLCERTIFICATE_H
#define KSSLCERTIFICATE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

@class QByteArray;
@class X509;

@interface  KSSLCertificate : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- (void) dealloc;
- (NSString *) toString;
- (NSString *) getSubject;
- (NSString *) getIssuer;
- (NSString *) getNotBefore;
- (NSString *) getNotAfter;
- (NSDate *) getQDTNotBefore;
- (NSDate *) getQDTNotAfter;
- (QByteArray*) toDer;
- (QByteArray*) toPem;
- (QByteArray*) toNetscape;
- (NSString *) toText;
- (NSString *) getSerialNumber;
- (NSString *) getKeyType;
- (NSString *) getPublicKeyText;
- (NSString *) getMD5DigestText;
- (NSString *) getSignatureText;
- (BOOL) isValid;
- (int) validate;
- (int) revalidate;
//- (KSSLCertChain*) chain;
- (KSSLCertificate*) replicate;
- copyWithZone: (NSZone *) zone;
- (BOOL) setCertWithName: (NSString *)cert;
//- (KSSLX509V3*) x509V3Extensions;
- (BOOL) isSigner;
+ (KSSLCertificate*) fromString: (NSString *)cert;
//+ (KSSLCertificate*) fromX509: (X509*)x5;
+ (NSString *) verifyText: (int)x;
- init;
//- setCert: (X509*)c;
- setChain: (void*)c;
//- (X509*) getCert;
- (int) processError: (int)ec;
+ (int) Unknown;
+ (int) Ok;
+ (int) NoCARoot;
+ (int) InvalidPurpose;
+ (int) PathLengthExceeded;
+ (int) InvalidCA;
+ (int) Expired;
+ (int) SelfSigned;
+ (int) ErrorReadingRoot;
+ (int) NoSSL;
+ (int) Revoked;
+ (int) Untrusted;
+ (int) SignatureFailed;
+ (int) Rejected;
+ (int) PrivateKeyFailed;
@end

#endif
