/***************************************************************************
                            KIconDialog.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KICONDIALOG_H
#define KICONDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 Dialog for interactive selection of icons. Use the function
 -getIcon let the user select an icon.

 @short An icon selection dialog.
 
*/

@class KIconLoader;
@class KIcon;

@interface KIconDialog : KDialogBase 

/** 
 Constructs an icon selection dialog using the global iconloader.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs an icon selection dialog using a specific iconloader.
     
*/
- initWithIconLoader: (KIconLoader*)loader parent: (QWidget *)parent name: (NSString *)name;
- initWithIconLoader: (KIconLoader*)loader ;

/** 
 Destructs the dialog.
     
*/
- (void) dealloc;

/** 
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in @ref -getIcon are shown.
 When false, icons not available at the desired group's size will
 also be selectable.
     
*/
- setStrictIconSize: (BOOL)b;

/** 
 Returns true if a strict icon size policy is set.
     
*/
- (BOOL) strictIconSize;

/** 
 Sets the size of the icons to be shown / selected.

*/
- setIconSize: (int)size;

/** 
 Returns the iconsize set via @ref -setIconSize or 0, if the default
 iconsize will be used.
     
*/
- (int) iconSize;

/** 

     
*/
- (NSString *) selectIcon: (int)group context: (int)context user: (BOOL)user;

/** 
 Allows you to set the same parameters as in the class method
 @ref -getIcon.
     
*/
- setup: (int)group context: (int)context strictIconSize: (BOOL)strictIconSize iconSize: (int)iconSize user: (BOOL)user;
- setup: (int)group ;

/** 
 -executes this modal dialog and returns the name of the selected icon,
 or -[QString null]if the dialog was aborted.

*/
- (NSString *) openDialog;

/** 
 Pops up the dialog an lets the user select an icon.

*/
+ (NSString *) getIcon: (int)group context: (int)context strictIconSize: (BOOL)strictIconSize iconSize: (int)iconSize user: (BOOL)user parent: (QWidget *)parent caption: (NSString *)caption;
- virtual_hook: (int)identifier data: (void*)data;
@end

/** Override these methods in subclasses of KIconDialog to customise event handling behaviour */
@protocol KIconDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
