/***************************************************************************
                            KHTMLSettings.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KHTMLSETTINGS_H
#define KHTMLSETTINGS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Settings for the HTML view.
 
 @short 
 Settings for the HTML view.
*/

@class KConfig;
@class QColor;
@class KJavaScriptAdvice;

@interface  KHTMLSettings : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 

     
*/
- init;
- copyWithZone: (NSZone *) zone;

/** 
 Called by constructor and reparseConfiguration
     
*/
- initSettings;

/**  Read settings from @p config.

*/
- initSettings: (KConfig*)config reset: (BOOL)reset;
- initSettings: (KConfig*)config ;

/** 
 Destructor. Don't delete any instance by yourself.
     
*/
- (void) dealloc;
- (BOOL) changeCursor;
- (BOOL) underlineLink;
- (BOOL) hoverLink;
- (int) showAnimations;
- (NSString *) stdFontName;
- (NSString *) fixedFontName;
- (NSString *) serifFontName;
- (NSString *) sansSerifFontName;
- (NSString *) cursiveFontName;
- (NSString *) fantasyFontName;
- setStdFontName: (NSString *)n;
- setFixedFontName: (NSString *)n;
- (int) minFontSize;
- (int) mediumFontSize;
- (NSString *) encoding;
- (QColor*) textColor;
- (QColor*) linkColor;
- (QColor*) vLinkColor;
- (BOOL) autoLoadImages;
- (BOOL) isJavaEnabled: (NSString *)hostname;
- (BOOL) isJavaEnabled;
- (BOOL) isJavaScriptEnabled: (NSString *)hostname;
- (BOOL) isJavaScriptEnabled;
- (BOOL) isJavaScriptDebugEnabled: (NSString *)hostname;
- (BOOL) isJavaScriptDebugEnabled;
- (BOOL) isPluginsEnabled: (NSString *)hostname;
- (BOOL) isPluginsEnabled;
- (NSString *) settingsToCSS;
- (NSString *) userStyleSheet;
- (BOOL) isFormCompletionEnabled;
- (int) maxFormCompletionItems;
+ (int) strToAdvice: (NSString *)_str;
+ splitDomainAdvice: (NSString *)configStr domain: (NSString *)domain javaAdvice: (KJavaScriptAdvice*)javaAdvice javaScriptAdvice: (KJavaScriptAdvice*)javaScriptAdvice;
+ (NSString *) adviceToStr: (int)_advice;
+ (NSString *) availableFamilies;
+ (int) KJavaScriptDunno;
+ (int) KJavaScriptAccept;
+ (int) KJavaScriptReject;
+ (int) KAnimationDisabled;
+ (int) KAnimationLoopOnce;
+ (int) KAnimationEnabled;
@end

#endif
