/***************************************************************************
                            KFileView.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEVIEW_H
#define KFILEVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This class defines an interface to all file views. Its intent is
 to allow to switch the view of the files in the selector very easily.
 It defines some pure virtual functions, that must be implemented to
 make a file view working.

 Since this class is not a widget, but it's meant to be added to other
 widgets, its most important function is @ref widget. This should return
 a pointer to the implemented widget.

 @author Stephan Kulow <coolo@kde.org>

 @version $Id: KFileView.h,v 1.3 2002/03/15 02:12:20 rdale Exp $

 @short A base class for views of the KDE file selector.
*/

@class KActionCollection;
@class KConfig;
@class KFileItem;
@class KFileView;
@class KFileViewSignaler;
@class QWidget;

@protocol KFileViewInterface

/**  Destructor 
*/
- (void) dealloc;

/** 
 inserts a list of items.

*/
- addItemList: (NSArray *)list;

/** 
 a pure virtual function to get a QWidget, that can be added to
 other widgets. This function is needed to make it possible for
 derived classes to derive from other widgets.

*/
- (QWidget*) widget;

/** 
 ### As const-method, to be fixed in 3.0
     
*/
- (QWidget*) widget;

/** 
 Sets @p filename the current item in the view, if available.
     
*/
- setCurrentItemFromFile: (NSString *)filename;

/** 
 Reimplement this to set @p item the current item in the view, e.g.
 the item having focus.
     
*/
- setCurrentItem: (KFileItem*)item;

/** 

*/
- (KFileItem*) currentFileItem;

/** 
 Clears the view and all item lists.
     
*/
- clear;

/** 
 does a repaint of the view.

 The default implementation calls
 <pre>-widget->repaint(f)</pre>

*/
- updateView: (BOOL)f;
- updateView;
- updateFileView: (KFileItem*)arg1;

/** 
 Removes an item from the list; has to be implemented by the view.
 Call -[KFileView removeItem]( item ) after removing it.
     
*/
- removeFileItem: (KFileItem*)item;

/** 
 This hook is called when all items of the currently listed directory
 are listed and inserted into the view, i.e. there won't come any new
 items anymore.
     
*/
- listingCompleted;

/** 
 Returns the sorting order of the internal list. Newly added files
 are added through this sorting.
      
*/
- (int) sorting;

/** 
 Sets the sorting order of the view.

 Default is -[QDir Name]| -[QDir IgnoreCase]| -[QDir DirsFirst]Override this in your subclass and sort accordingly (usually by
 setting the sorting-key for every item and telling QIconView
 or QListView to sort.

 A view may choose to use a different sorting than -[QDir Name], Time
 or Size. E.g. to sort by mimetype or any possible string. Set the
 sorting to -[QDir Unsorted]for that and do the rest internally.

*/
- setSorting: (int)sort;

/** 
 Tells whether the current items are in reversed order (shortcut to
 -sorting & -[QDir Reversed]).
     
*/
- (BOOL) isReversed;
- sortReversed;

/** 

*/
- (unsigned int) count;

/** 

*/
- (unsigned int) numFiles;

/** 

*/
- (unsigned int) numDirs;
- setSelectionMode: (int)sm;
- (int) selectionMode;
- setViewMode: (int)vm;
- (int) viewMode;

/** 

*/
- (NSString *) viewName;

/** 
 Sets the name of the view, which could be displayed somewhere.
 E.g. "Image Preview".
     
*/
- setViewName: (NSString *)name;
- setParentView: (KFileView*)parent;

/** 
 The derived view must implement this function to add
 the file in the widget.

 Make sure to call this implementation, i.e.
 -[KFileView insertItem]( i );

     
*/
- insertFileItem: (KFileItem*)i;

/** 
 pure virtual function, that should be implemented to clear
 the view. At this moment the list is already empty

*/
- clearView;

/** 
 pure virtual function, that should be implemented to make item i
 visible, i.e. by scrolling the view appropriately.
     
*/
- ensureItemVisible: (KFileItem*)i;

/** 
 Clears any selection, unhighlights everything. Must be implemented by
 the view.
     
*/
- clearSelection;

/** 
 Selects all items. You may want to override this, if you can implement
 it more efficiently than calling -setSelected with every item.
 This works only in Multiselection mode of course.
     
*/
- selectAll;

/** 
 Inverts the current selection, i.e. selects all items, that were up to
 now not selected and deselects the other.
     
*/
- invertSelection;

/** 
 Tells the view that it should highlight the item.
 This function must be implemented by the view.

*/
- setSelected: (KFileItem*)arg1 enable: (BOOL)enable;

/** 

*/
- (BOOL) isSelected: (KFileItem*)arg1;

/** 

*/
- (NSArray *) selectedItems;

/** 

*/
- (NSArray *) items;
- (KFileItem*) firstFileItem;
- (KFileItem*) nextItem: (KFileItem*)arg1;
- (KFileItem*) prevItem: (KFileItem*)arg1;

/** 
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 Every view has to decide when to call select( item ) when a file was
 single-clicked, based on @ref -onlyDoubleClickSelectsFiles.
     
*/
- setOnlyDoubleClickSelectsFiles: (BOOL)enable;

/** 

*/
- (BOOL) onlyDoubleClickSelectsFiles;

/** 
 increases the number of dirs and files.

*/
- (BOOL) updateNumbers: (KFileItem*)i;

/** 

*/
- (KActionCollection*) actionCollection;
- (KFileViewSignaler*) signaler;
- readConfig: (KConfig*)arg1 group: (NSString *)group;
- readConfig: (KConfig*)arg1 ;
- writeConfig: (KConfig*)arg1 group: (NSString *)group;
- writeConfig: (KConfig*)arg1 ;
+ (NSString *) sortingKey: (NSString *)value isDir: (BOOL)isDir sortSpec: (int)sortSpec;
+ (NSString *) sortingKeyId: (unsigned long)value isDir: (BOOL)isDir sortSpec: (int)sortSpec;
@end

@class KActionCollection; 
@class KConfig; 
@class KFileItem; 
@class KFileView; 
@class KFileViewSignaler; 
@class QWidget; 

@interface KFileView : NSObject <QtSupport,KFileViewInterface>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/**  Destructor
*/
- (void) dealloc;


+ (int) Files;
+ (int) Directories;
+ (int) All;
@end

#endif
