/***************************************************************************
                            KDataToolAction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDATATOOLACTION_H
#define KDATATOOLACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KAction.h>

/**

 This class helps applications implement support for KDataTool.
 The steps to follow are simple:
 1) query for the available tools using -[KDataToolInfo query]2) pass the result to -[KDataToolAction dataToolActionList](with a slot)
 3) plug the resulting actions, either using -[KXMLGUIClient plugActionList], or by hand.

 The slot defined for step 2 is called when the action is activated, and
 that's where the tool should be created and run.
 
 @short 
 This class helps applications implement support for KDataTool.
*/
@class KDataToolInfo; 

@interface KDataToolAction : KAction 
- initWithText: (NSString *)text info: (KDataToolInfo*)info command: (NSString *)command parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text info: (KDataToolInfo*)info command: (NSString *)command ;
- slotActivated;
@end

/** Override these methods in subclasses of KDataToolAction to customise event handling behaviour */
@protocol KDataToolActionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
