/***************************************************************************
                            KConfigBackEnd.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONFIGBACKEND_H
#define KCONFIGBACKEND_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Abstract base class for KDE configuration file loading/saving.

 This class forms the base for all classes that implement some
 manner of loading/saving to configuration files.  It is an
 abstract base class, meaning that you cannot directly instantiate
 objects of this class. As of right now, the only back end available
 is one to read/write to INI-style files, but in the future, other
 formats may be available, such as XML or a database.

 @author Preston Brown <pbrown@kde.org>, 
         Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KConfigBackEnd.h,v 1.3 2002/03/15 02:12:19 rdale Exp $

 @short KDE Configuration file loading/saving abstract base class.
*/
@interface  KConfigBackEnd : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Destructs the configuration backend.
   
*/
- (void) dealloc;

/** 
 Parses all configuration files for a configuration object.  This
 method must be reimplemented by the derived classes.

*/
- (BOOL) parseConfigFiles;

/** 
 Writes configuration data to file(s).  This method must be
 reimplemented by the derived classes.

*/
- sync: (BOOL)bMerge;
- sync;

/** 
 Changes the filenames associated with this back end.  You should
 probably reparse your config info after doing this.

*/
- changeFileName: (NSString *)_fileName _resType: (NSString *)_resType _useKDEGlobals: (BOOL)_useKDEGlobals;

/** 
 Returns the state of the app-config object.

*/
- (int) getConfigState;

/** 

*/
- (NSString *) fileName;

/** 

*/
- (NSString *) resource;
- setLocaleString: (NSString *)_localeString;
@end

#endif
