/***************************************************************************
                            NetAccess.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Net Transparency, formerly provided by kfmlib, but now
 done with {@link KIO#Job}.

 This class isn't meant to be used as a class but only as a simple
  namespace for static functions, though an instance of the class
  is built for internal purposes.  Whereas a {@link KIO#Job} is
  asynchronous, meaning that the developer has to connect slots
  for it, KIO.NetAccess provides synchronous downloads and
  uploads, as well as temporary file creation and removal.

  Port to kio done by David Faure, faure@kde.org

 @short Provides a synchronous interface to io jobs.
   
*/
public class NetAccess extends QObject  {
	protected NetAccess(Class dummy){super((Class) null);}


/** 
 Downloads a file from an arbitrary URL (<code>src</code>) to a
 temporary file on the local filesystem (<code>target</code>).

 If the argument
 for <code>target</code> is an empty string, download will generate a
 unique temporary filename in /tmp. Since <code>target</code> is a reference
 to {@link String} you can access this filename easily. Download will
 return true if the download was successful, otherwise false.

 Special case:
 If the URL is of kind file:, then no downloading is
 processed but the full filename is returned in <code>target.</code>
 That means you <em>have</em> to take care about the <code>target</code> argument.
 (This is very easy to do, please see the example below.)

 Download is synchronous. That means you can use it like
 this, (assuming <code>u</code> is a string which represents a URL and your
 application has a {@link #loadFile} function):

 <pre>
 StringBuffer tmpFile = new StringBuffer();
 if( NetAccess.download( u, tmpFile ) )
 {
   loadFile( tmpFile.toString() );
   NetAccess.removeTempFile( tmpFile.toString() );
   }
 </pre>

 Of course, your user interface will still process exposure/repaint
 events during the download.

*/
	public static native boolean download( KURL src, StringBuffer target);

/** 
 Removes the specified file if and only if it was created
 by KIO.NetAccess as a temporary file for a former download.

 Note: This means that if you created your temporary with {@link KTempFile},
 use {@link KTempFile#unlink} or {@link KTempFile#setAutoDelete} to have
 it removed.

*/
	public static native void removeTempFile( String name);

/** 
 Uploads file <code>src</code> to URL <code>target.</code>

 Both must be specified, unlike {@link #download.}
 Note that this is assumed to be used for saving a file over
 the network, so overwriting is set to true. This is not the
 case with {@link #copy.}

*/
	public static native boolean upload( String src, KURL target);

/** 
 Alternative method for copying over the network.
 Overwrite is false, so this will fail if <code>target</code> exists.

 This one takes two URLs and is a direct equivalent
 of {@link KIO#file_copy}.
     
*/
	public static native boolean copy( KURL src, KURL target);

/** 
 Alternative method for copying over the network.
 Overwrite is false, so this will fail if <code>target</code> exists.

 This one takes two URLs and is a direct equivalent
 of {@link KIO#copy}!.
     
*/
	public static native boolean dircopy( KURL src, KURL target);

/** 
 Tests whether a URL exists.

 This is a convenience function for {@link KIO#stat}.

*/
	public static native boolean exists( KURL url);

/** 
 Overloaded version of exists
 A stat() can have two meanings. Either we want to read from this URL,
 or to check if we can write to it. First case is "source", second is "dest".
 It is necessary to know what the StatJob is for, to tune the kioslave's behaviour
 (e.g. with FTP)
 Tests whether a URL exists.

*/
	public static native boolean exists( KURL url, boolean source);

/** 
 Tests whether a URL exists and return information on it.

 This is a convenience function for {@link KIO#stat}.

*/
//	public static native boolean stat( KURL url, UDSEntry entry);

/** 
 Deletes a file or a directory in an synchronous way.

 This is a convenience function for {@link KIO#del}.

*/
	public static native boolean del( KURL url);

/** 
 Creates a directory in a synchronous way.

 This is a convenience function for <code>KIO.mkdir</code>
 (it saves creating a slot and testing for the job result).

*/
	public static native boolean mkdir( KURL url, int permissions);
	public static native boolean mkdir( KURL url);

/** 
 Determines the mimetype of a given URL.

 This is a convenience function for {@link KIO#mimetype}.  You
 should call this only when really necessary.  {@link KMimeType#findByURL} can determine extension a lot faster, but
 less reliably for remote files. Only when {@link #findByURL} returns
 unknown (application/octet-stream) then this one should be
 used.

*/
//	public static native String mimetype( KURL url);

/** 
 Returns the error string for the last job, in case it failed.
     
*/
	public static native String lastErrorString();
}
