/***************************************************************************
                            KStdAccel.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Convenient methods for access to the common accelerator keys in
 the key configuration. These are the standard keybindings that should
 be used in all KDE applications. They will be configurable,
 so do not hardcode the default behavior.

 If you want real configurable keybindings in your applications,
 please checkout the class {@link KAccel} in kaccel.h

 @short *
 Convenient methods for access to the common accelerator keys in
 the key configuration.
*/
public class  KStdAccel implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KStdAccel(Class dummy){}


/** 
 Returns the keybinding for <code>accel.</code>

*/
	public native KShortcut shortcut( int identifier);

/** 
 Returns a unique name for the given accel.

*/
	public native String name( int identifier);

/** 
 Returns a localized label for user-visible display.

*/
	public native String label( int identifier);

/** 
 Returns an extended WhatsThis description for the given accelerator.

*/
	public native String whatsThis( int identifier);

/** 
 Return the StdAccel id of the standard accel action which
 uses this key sequence, or AccelNone if none of them do.
 This is used by class KKeyChooser.

*/
	public native int findStdAccel( KKeySequence keySeq);

/** 
 Returns the hardcoded default shortcut for <code>id.</code>
 This does not take into account the user's configuration.

*/
	public native KShortcut shortcutDefault( int identifier);

/** 
 Returns the hardcoded default 3 modifier shortcut for <code>id.</code>
 This does not take into account the user's configuration.

*/
	public native KShortcut shortcutDefault3( int identifier);

/** 
 Returns the hardcoded default 4 modifier shortcut for <code>id.</code>
 This does not take into account the user's configuration.

*/
	public native KShortcut shortcutDefault4( int identifier);

/** 
 Open file. Default: Ctrl-o

*/
	public native KShortcut open();

/** 
 Create a new document (or whatever). Default: Ctrl-n

*/
	public native KShortcut openNew();

/** 
 Close current document. Default: Ctrl-w

*/
	public native KShortcut close();

/** 
 Save current document. Default: Ctrl-s

*/
	public native KShortcut save();

/** 
 Print current document. Default: Ctrl-p

*/
	public native KShortcut print();

/** 
 Quit the program. Default: Ctrl-q

*/
	public native KShortcut quit();

/** 
 Undo last operation. Default: Ctrl-z

*/
	public native KShortcut undo();

/** 
 Redo. Default: Shift-Ctrl-z

*/
	public native KShortcut redo();

/** 
 Cut selected area and store it in the clipboard. Default: Ctrl-x

*/
	public native KShortcut cut();

/** 
 Copy selected area into the clipboard. Default: Ctrl-c

*/
	public native KShortcut copy();

/** 
 Paste contents of clipboard at mouse/cursor position. Default: Ctrl-v

*/
	public native KShortcut paste();

/** 
 Reload. Default: Ctrl-A

*/
	public native KShortcut selectAll();

/** 
 Delete a word back from mouse/cursor position. Default: Ctrl-Backspace

*/
	public native KShortcut deleteWordBack();

/** 
 Delete a word forward from mouse/cursor position. Default: Ctrl-Delete

*/
	public native KShortcut deleteWordForward();

/** 
 Find, search. Default: Ctrl-f

*/
	public native KShortcut find();

/** 
 Find/search next. Default: F3

*/
	public native KShortcut findNext();

/** 
 Find/search previous. Default: Shift-F3

*/
	public native KShortcut findPrev();

/** 
 Find and replace matches. Default: Ctrl-r

*/
	public native KShortcut replace();

/** 
 Zoom in. Default: Ctrl-Plus

*/
	public native KShortcut zoomIn();

/** 
 Zoom out. Default: Ctrl-Minus

*/
	public native KShortcut zoomOut();

/** 
 Toggle insert/overwrite (with visual feedback, e.g. in the statusbar). Default: Insert

*/
	public native KShortcut insert();

/** 
 Goto beginning of current line. Default: Home

*/
	public native KShortcut home();

/** 
 Goto end of current line. Default: End

*/
	public native KShortcut end();

/** 
 Scroll up one page. Default: Prior

*/
	public native KShortcut prior();

/** 
 Scroll down one page. Default: Next

*/
	public native KShortcut next();

/** 
 Go to line. Default: Ctrl+G

*/
	public native KShortcut gotoLine();

/** 
 Add current page to bookmarks. Default: Ctrl+B

*/
	public native KShortcut addBookmark();

/** 
 Help the user in the current situation. Default: F1

*/
	public native KShortcut help();

/** 
 Complete text in input widgets. Default Ctrl+E

*/
	public native KShortcut completion();

/** 
 Iterate through a list when completion returns
 mutiple items. Default: Ctrl+Up

*/
	public native KShortcut prevCompletion();

/** 
 Iterate through a list when completion returns
 mutiple items. Default: Ctrl+Down

*/
	public native KShortcut nextCompletion();

/** 
 Find a string within another string or list of strings.
 Default: Ctrl-T

*/
	public native KShortcut substringCompletion();

/** 
 Help users iterate through a list of entries. Default: Up

*/
	public native KShortcut rotateUp();

/** 
 Help users iterate through a list of entries. Default: Down

*/
	public native KShortcut rotateDown();

/** 
 popup a context menu. Default: Menu

*/
	public native KShortcut popupMenuContext();

/** 
 What's This button. Default: Shift+F1

*/
	public native KShortcut whatsThis();

/** 
 Reload. Default: F5

*/
	public native KShortcut reload();

/** 
 Up. Default: Alt+Up

*/
	public native KShortcut up();

/** 
 Back. Default: Alt+Left

*/
	public native KShortcut back();

/** 
 Forward. Default: ALT+Right

*/
	public native KShortcut forward();

/** 
 Show Menu Bar.  Default: Ctrl-M

*/
	public native KShortcut showMenubar();

/** 

 Obsolete.  Use name().  Returns a string representation for <code>accel.</code>
   
*/
	public native String action( int identifier);

/** 

 Obsolete.  Use desc().  Returns a localized description of <code>accel.</code>
   
*/
	public native String description( int identifier);

/** 

 Obsolete.  Use shortcut().  Returns the keybinding for <code>accel.</code>
   
*/
	public native int key( int arg1);

/** 

 Obsolete.  Use shortcutDefault().
   
*/
	public native int defaultKey( int accel);

/** 

 Compare the keys generated by the key event with
 the value of the integer.

 If a modifier (Shift, Alt, Ctrl) key is present in
 {@link QKeyEvent}, its sum with the actual key value
 is used for comparing it with the integer parameter.

*/
	public static native boolean isEqual( QKeyEvent pEvent, int keyQt);
	public static final int AccelNone = 0;
	public static final int Open = 1;
	public static final int New = 2;
	public static final int Close = 3;
	public static final int Save = 4;
	public static final int Print = 5;
	public static final int Quit = 6;
	public static final int Undo = 7;
	public static final int Redo = 8;
	public static final int Cut = 9;
	public static final int Copy = 10;
	public static final int Paste = 11;
	public static final int SelectAll = 12;
	public static final int Deselect = 13;
	public static final int DeleteWordBack = 14;
	public static final int DeleteWordForward = 15;
	public static final int Find = 16;
	public static final int FindNext = 17;
	public static final int FindPrev = 18;
	public static final int Replace = 19;
	public static final int Home = 20;
	public static final int End = 21;
	public static final int Prior = 22;
	public static final int Next = 23;
	public static final int GotoLine = 24;
	public static final int AddBookmark = 25;
	public static final int ZoomIn = 26;
	public static final int ZoomOut = 27;
	public static final int Up = 28;
	public static final int Back = 29;
	public static final int Forward = 30;
	public static final int Reload = 31;
	public static final int PopupMenuContext = 32;
	public static final int ShowMenubar = 33;
	public static final int Help = 34;
	public static final int WhatsThis = 35;
	public static final int TextCompletion = 36;
	public static final int PrevCompletion = 37;
	public static final int NextCompletion = 38;
	public static final int SubstringCompletion = 39;
	public static final int RotateUp = 40;
	public static final int RotateDown = 41;
	public static final int WhatThis = WhatsThis;
}
