/***************************************************************************
                            KPixmapSplitter.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 If you have a pixmap containing several items (icons), you can use this
 class to get the coordinates of each item.

 For example, if you have a pixmap with 25 items and you want to get the
 4th item as a pixmap (every item being 20x10 pixels):
 <pre>
 KPixmapSplitter splitter;
 splitter.setPixmap( somePixmap );
 splitter.setItemSize( QSize( 20, 10 ));

 QPixmap item( 20, 10 );
 item.fill( Qt.white );
 QRect rect = splitter.coordinates( 4 );
 if ( !rect.isEmpty() )
     bitBlt( &item, QPoint(0,0), &somePixmap, rect, CopyROP );
 </pre>

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A class to split a pixmap into several items.

*/
public class  KPixmapSplitter implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KPixmapSplitter(Class dummy){}

	private native void newKPixmapSplitter();

/** 
 Constructor, does nothing but initializing some default-values.
     
*/
	public KPixmapSplitter() {
		newKPixmapSplitter();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets the pixmap to be splitted.
     
*/
	public native void setPixmap( QPixmap pixmap);

/** 

*/
	public native QPixmap pixmap();

/** 
 Sets the size of the items you want to get out of the given pixmap.
 The QRect of #coordinates(int) will have the width and height of exactly
 this <code>size.</code>
     
*/
	public native void setItemSize( QSize size);

/** 

*/
	public native QSize itemSize();

/** 
 If there is space between rows in the given pixmap, you have to specify
 how many pixels there are.
     
*/
	public native void setVSpacing( int spacing);

/** 
 If there is space between columns in the given pixmap, you have to
 specify how many pixels there are.
     
*/
	public native void setHSpacing( int spacing);

/** 

*/
	public native QRect coordinates( int pos);

/** 
 Overloaded for convenience. Returns the item at the position of the
 given character (when using a latin1 font-pixmap)
     
*/
	public native QRect coordinates( char ch);
}
