/***************************************************************************
                            KKeyDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The KKeyDialog class is used for configuring dictionaries of key/action
 associations for KActionCollection, KAccel, and KGlobalAccel. It uses the KKeyChooser widget
 and offers buttons to set all keys to defaults and invoke on-line help.

 Three static methods are supplied which provide the most convienient interface
 to the dialog. The most common and most encouraged use is with KActionCollection.

 <pre>
 KKeyDialog.configure( actionCollection() );
 </pre>

 See {@link KKeyDialogSignals} for signals emitted by KKeyDialog.

 

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyDialog.java,v 1.11 2002/11/26 04:17:33 rdale Exp $

 @short Dialog for configuration of @ref KActionCollection, @ref KAccel, and @ref KGlobalAccel.

*/
public class KKeyDialog extends KDialogBase  {
	protected KKeyDialog(Class dummy){super((Class) null);}

	private native void newKKeyDialog( boolean bAllowLetterShortcuts, QWidget parent, String name);

/** 
 Constructs a KKeyDialog called <code>name</code> as a child of <code>parent.</code>
 Set <code>bAllowLetterShortcuts</code> to false if unmodified alphanumeric
 keys ('A', '1', etc.) are not permissible shortcuts.
	 
*/
	public KKeyDialog( boolean bAllowLetterShortcuts, QWidget parent, String name) {
		super((Class) null);
		newKKeyDialog( bAllowLetterShortcuts, parent, name);
	}
	private native void newKKeyDialog();
	public KKeyDialog() {
		super((Class) null);
		newKKeyDialog();
	}

/** 
 Destructor. Deletes all resources used by a KKeyDialog object.
	 
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Insert an action collection, i.e. add all its actions to the ones
 displayed by the dialog.
 This method can be useful in applications following the document/view
 design, with actions in both the document and the view.
 Simply call insert with the action collections of each one in turn.

*/
	public native boolean insert( KActionCollection arg1);

/** 
 Insert an action collection, i.e. add all its actions to the ones
 displayed by the dialog.
 This method can be useful in applications following the document/view
 design, with actions in both the document and the view.
 Simply call insert with the action collections of each one in turn.

*/
	public native boolean insert( KActionCollection arg1, String title);
	public native boolean configure( boolean bSaveSettings);
	public native boolean configure();

/** 
 Commit key setting changes so that changed settings actually become active.
 This method is implicitly called from #configure if
 <code>bSaveSettings</code> is true.
	 
*/
	public native void commitChanges();

/** 
 Pops up a modal dialog for configuring key settings. The new
 shortcut settings will be active if the user presses OK.  If
 <code>bSaveSettings</code> is true, the settings will also be saved back to
 the uirc file which they were intially read from.

*/
	public static native int configure( KActionCollection coll, QWidget parent, boolean bSaveSettings);
	public static native int configure( KActionCollection coll);

/** 
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function, except that settings
 are saved to a .rc file using KConfig.
	 
*/
	public static native int configure( KAccel keys, QWidget parent, boolean bSaveSettings);
	public static native int configure( KAccel keys);

/** 
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.
	 
*/
	public static native int configure( KGlobalAccel keys, QWidget parent, boolean bSaveSettings);
	public static native int configure( KGlobalAccel keys);

/** 
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.

*/
	public static native int configure( KActionCollection coll, boolean bAllowLetterShortcuts, QWidget parent, boolean bSaveSettings);
	public static native int configure( KActionCollection coll, boolean bAllowLetterShortcuts);

/** 
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.

*/
	public static native int configure( KAccel keys, boolean bAllowLetterShortcuts, QWidget parent, boolean bSaveSettings);
	public static native int configure( KAccel keys, boolean bAllowLetterShortcuts);

/** 
 This is an overloaded member function, provided for convenience.
 It behaves essentially like the above function.

*/
	public static native int configure( KGlobalAccel keys, boolean bAllowLetterShortcuts, QWidget parent, boolean bSaveSettings);
	public static native int configure( KGlobalAccel keys, boolean bAllowLetterShortcuts);

/** 

 Please use {@link KKeyDialog#configure} instead
	 
*/
	public static native int configureKeys( KAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KAccel keys);

/** 

 Please use {@link KKeyDialog#configure} instead
	 
*/
	public static native int configureKeys( KGlobalAccel keys, boolean save_settings, QWidget parent);
	public static native int configureKeys( KGlobalAccel keys);

/** 

 Please use {@link KKeyDialog#configure} instead
	 
*/
	public static native int configureKeys( KActionCollection coll, String arg1, boolean save_settings, QWidget parent);
	public static native int configureKeys( KActionCollection coll, String arg1);
	protected native void virtual_hook( int identifier, int data);
}
