#include <qcolor.h>

static PyQt_Enum pyqt_qcolor_Spec[] = {
    { (int)QColor::Rgb, "Rgb" },
    { (int)QColor::Hsv, "Hsv" },
    { 0, 0 }
};


static void pyqt_qcolor_free( void* ptr )
{
    delete (QColor*)ptr;
}

static QColor* pyqt_qcolor_toCpp( PyObject* obj )
{
    return (QColor*)getPointer( obj, Color );
}

static PyObject* pyqt_qcolor_toPython( const QColor& ptr )
{
    return qobjectToPython( new QColor( ptr ), Color );
}

static PyObject* pyqt_qcolor_maxColors( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", QColor::maxColors() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_red( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", ((QColor*)ptr)->red() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_pixel( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return PyLong_FromUnsignedLong( ((QColor*)ptr)->pixel() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_green( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", ((QColor*)ptr)->green() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_rgb( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	int a, b, c;
	((QColor*)ptr)->rgb( &a, &b, &c );
	PyObject* l = PyList_New( 3 );
	PyList_SetItem( l, 0, PyInt_FromLong( a ) );
	PyList_SetItem( l, 1, PyInt_FromLong( b ) );
	PyList_SetItem( l, 2, PyInt_FromLong( c ) );
	return l;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_setHsv( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    int _2param;
    if ( PyArg_ParseTuple( arg_tuple, "iii", &_0param, &_1param, &_2param )  )
    {
         ((QColor*)ptr)->setHsv(_0param, _1param, _2param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_blue( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", ((QColor*)ptr)->blue() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_enterAllocContext( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", QColor::enterAllocContext() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_light( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param= 150;
    if ( PyArg_ParseTuple( arg_tuple, "|i", &_0param )  )
    {
         return pyqt_qcolor_toPython( ((QColor*)ptr)->light(_0param) );
    }
    return NULL;
}
#if 0
static PyObject* pyqt_qcolor_lazyAlloc( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)QColor::lazyAlloc() );
    }
    return NULL;
}
#endif
static PyObject* pyqt_qcolor_name( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("s", ((QColor*)ptr)->name().latin1() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_alloc( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", ((QColor*)ptr)->alloc() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_constructor( void* /* ptr */, PyObject* obj, PyObject* arg_tuple )
{
    if ( !obj )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         void* ptr = new QColor;
        mapObject( obj, ptr, pyqt_qcolor_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    int _0param;
    int _1param;
    int _2param;
    if ( PyArg_ParseTuple( arg_tuple, "iii", &_0param, &_1param, &_2param )  )
    {
         PyErr_Clear();
        void* ptr = new QColor( _0param, _1param, _2param );
        mapObject( obj, ptr, pyqt_qcolor_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    int _3param;
    int _4param;
    int _5param;
    char* _6enum = 0;
    int   _6param;
    if ( PyArg_ParseTuple( arg_tuple, "iiis", &_3param, &_4param, &_5param, &_6enum )  && ( !_6enum || enumToCpp( pyqt_qcolor_Spec, _6enum, &_6param ) ) )
    {
         PyErr_Clear();
        void* ptr = new QColor( _3param, _4param, _5param, (QColor::Spec)_6param );
        mapObject( obj, ptr, pyqt_qcolor_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    char* _7param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "s", &_7param )  )
    {
         PyErr_Clear();
        void* ptr = new QColor( _7param );
        mapObject( obj, ptr, pyqt_qcolor_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    PyObject* _8param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_8param )  && inherits( _8param, Color ) )
    {
         PyErr_Clear();
        void* ptr = new QColor( *pyqt_qcolor_toCpp( _8param ) );
        mapObject( obj, ptr, pyqt_qcolor_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_leaveAllocContext( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         QColor::leaveAllocContext();
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_setRgb( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    int _2param;
    if ( PyArg_ParseTuple( arg_tuple, "iii", &_0param, &_1param, &_2param )  )
    {
         ((QColor*)ptr)->setRgb(_0param, _1param, _2param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_setNamedColor( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    char* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "s", &_0param )  )
    {
         ((QColor*)ptr)->setNamedColor(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_hsv( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	int a, b, c;
	((QColor*)ptr)->hsv( &a, &b, &c );
	PyObject* l = PyList_New( 3 );
	PyList_SetItem( l, 0, PyInt_FromLong( a ) );
	PyList_SetItem( l, 1, PyInt_FromLong( b ) );
	PyList_SetItem( l, 2, PyInt_FromLong( c ) );
	return l;
    }
    return NULL;
}

static PyObject* pyqt_qcolor_dark( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param= 200;
    if ( PyArg_ParseTuple( arg_tuple, "|i", &_0param )  )
    {
         return pyqt_qcolor_toPython( ((QColor*)ptr)->dark(_0param) );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_isDirty( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)((QColor*)ptr)->isDirty() );
    }
    return NULL;
}
#if 0
static PyObject* pyqt_qcolor_setLazyAlloc( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    bool _0param;
    if ( PyArg_ParseTuple( arg_tuple, "b", &_0param )  )
    {
         QColor::setLazyAlloc(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}
#endif

static PyObject* pyqt_qcolor_numBitPlanes( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", QColor::numBitPlanes() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_isValid( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("b", (char)((QColor*)ptr)->isValid() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_currentAllocContext( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return Py_BuildValue("i", QColor::currentAllocContext() );
    }
    return NULL;
}

static PyObject* pyqt_qcolor_destroyAllocContext( void* /* ptr */, PyObject* /* obj */, PyObject* arg_tuple )
{
    int _0param;
    if ( PyArg_ParseTuple( arg_tuple, "i", &_0param )  )
    {
         QColor::destroyAllocContext(_0param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyQt_Method pyqt_qcolor_methods[] = {
    pyqt_qcolor_maxColors,
    pyqt_qcolor_red,
    pyqt_qcolor_pixel,
    pyqt_qcolor_green,
    pyqt_qcolor_rgb,
    pyqt_qcolor_setHsv,
    pyqt_qcolor_blue,
    pyqt_qcolor_enterAllocContext,
    pyqt_qcolor_light,
    /*pyqt_qcolor_lazyAlloc,*/
    pyqt_qcolor_name,
    pyqt_qcolor_alloc,
    pyqt_qcolor_constructor,
    pyqt_qcolor_leaveAllocContext,
    pyqt_qcolor_setRgb,
    pyqt_qcolor_setNamedColor,
    pyqt_qcolor_hsv,
    pyqt_qcolor_dark,
    pyqt_qcolor_isDirty,
    /*pyqt_qcolor_setLazyAlloc,*/
    pyqt_qcolor_numBitPlanes,
    pyqt_qcolor_isValid,
    pyqt_qcolor_currentAllocContext,
    pyqt_qcolor_destroyAllocContext,
    0
};

static void pyqt_qcolor_init()
{
    if ( pyqt_qcolor_class )
        return;

    pyqt_qcolor_class = new PyQt_ClassInfo;
    pyqt_qcolor_class->freeQt = pyqt_qcolor_free;
    pyqt_qcolor_class->methods = pyqt_qcolor_methods;
    pyqt_qcolor_class->methodCount = methodCount( pyqt_qcolor_methods );
    pyqt_qcolor_class->next = 0;
    pyqt_qcolor_class->classid = Color;
    pyqt_qcolor_class->classObject = PyDict_GetItemString( pyqt_qt_dict, "QColor" );
    pyqt_qcolor_class->className = "QColor";
    ASSERT( pyqt_qcolor_class->classObject );
}

