#ifndef __mousepageimpl_h__
#define __mousepageimpl_h__

#include "mousepage.h"

#include "kxpage.h"
#include "kxdata.h"

class MousePage : public MousePageBase, public KXPage
{
    Q_OBJECT
    Q_PROPERTY( QString quickHelp READ quickHelp )
public:
    MousePage( QWidget *parent, const char *name = 0 );
    virtual ~MousePage();

    QString quickHelp() const;

    // reimplemented from KXPage
    virtual void load();
    virtual void save();

signals:
    void enableForward( bool );
    void changed();

private slots:
    void slotMouseTypeChanged( int type );
    void slotMouseModelChanged( int model );

private:
    void loadModels( KXPointerClass klass );

    KXPointerClass typeToClass( int type );

    KXPointerModel m_currentModel;
};

#endif
