/*****************************************************************************\
  models.h : Models types

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#ifndef APDK_MODELS_H
#define APDK_MODELS_H

#include "config.h"

APDK_BEGIN_NAMESPACE

// list of the basic equivalence classes
typedef enum PRINTER_TYPE               // typedef'ed for C interface
{
    UNSUPPORTED=-1,
    eDJ400,
    eDJ540,
    eDJ600,
    eDJ6xx,
    eDJ6xxPhoto,
    eDJ8xx,
    eDJ850,
    eDJ890,
    eDJ9xx,
    eDJ9xxVIP,
    eDJ630,
    eAP2xxx,
    eAP21xx,
    eAP2560,
    eDJ350,
    eDJ8x5,
    ePSP100,
    eDJ3320,
    eDJGenericVIP,
	eLJMono,
	eLJColor,
	ePScript,
    MAX_PRINTER_TYPE
} PRINTER_TYPE;

// strings used in Version function and for test harness
const char ModelName[MAX_PRINTER_TYPE][11] =
{
    "DJ400",
    "DJ540",
    "DJ600",
    "DJ6xx",
    "DJ6xxPhoto",
    "DJ8xx",
    "DJ850",
    "DJ890",
    "DJ9xx",
    "DJ9xxVIP",
    "DJ630",
    "AP2xxx",
    "AP21xx",
    "AP2560",
    "DJ350",
    "DJ8x5",
    "PS100",
    "DJ3320",
    "GenericVIP",
	"Mono Laser",
	"ColorLaser",
	"PostScript"
};


// list of firmware id string indices used in parsing;
// strings themselves are kept in char ModelString[MAX_ID_STRING] in models.cpp
// real purpose of this list is for automated maintenance of MAX_ID_STRING
enum DevIdIndex
{
    DEVID_MODEL_400,
    DEVID_MODEL_540,
    DEVID_MODEL_600,
    DEVID_MODEL_61X,
    DEVID_MODEL_63X,
    DEVID_MODEL_64X,
    DEVID_MODEL_65X,    // HP Bolt - DJ656
    DEVID_MODEL_69X,
    DEVID_MODEL_66X,
    DEVID_MODEL_67X,
    DEVID_MODEL_68X,
    DEVID_MODEL_6XX,
    DEVID_MODEL_81X,
    DEVID_MODEL_825,
    DEVID_MODEL_83X,
    DEVID_MODEL_845,
    DEVID_MODEL_84X,
    DEVID_MODEL_850,
    DEVID_MODEL_870,
    DEVID_MODEL_88X,
    DEVID_MODEL_890,
    DEVID_MODEL_895,
    DEVID_MODEL_91X,
    DEVID_MODEL_92X,
    DEVID_MODEL_93X,
    DEVID_MODEL_94X,
    DEVID_MODEL_95X,
    DEVID_MODEL_96X,
    DEVID_MODEL_97X,
    DEVID_MODEL_98X,
    DEVID_MODEL_99X,
    DEVID_MODEL_3320,           // DJ 3320 - Crossbow
    DEVID_MODEL_3420,           // DJ 3420 - Crossbow
    DEVID_MODEL_3810,           // DJ 3810 - Subway
    DEVID_MODEL_3816,           // DJ 3816 - Subway
    DEVID_MODEL_3820,           // DJ 3820 - Subway
    DEVID_MODEL_3822,           // DJ 3822 - Subway
    DEVID_MODEL_6122,           // DJ 6122 - Churchill
    DEVID_MODEL_6127,           // DJ 6127 - FDR
    DEVID_MODEL_E20,
    DEVID_MODEL_APOLLO_P22XX,
    DEVID_MODEL_APOLLO_P21XX,
    DEVID_MODEL_APOLLO_P2X00,    // Apollo 2500/2600
    DEVID_MODEL_350,
    DEVID_MODEL_450,
    DEVID_MODEL_PS_P1000,
    DEVID_MODEL_PS_P1100,
    DEVID_MODEL_PS_P1215,
    DEVID_MODEL_PS_P1218,
    DEVID_MODEL_PS_P1115,
    DEVID_MODEL_PS_P1315,
    DEVID_MODEL_PS_P100,         // AtomAnt
    DEVID_MODEL_PS_P130,         // Underdog (AtomAnt follow-on)
    DEVID_MODEL_PS_230,
    DEVID_MODEL_PS_7150,         // Twister
    DEVID_MODEL_PS_7350,         // Dorothy
    DEVID_MODEL_PS_7550,
    DEVID_MODEL_1120,
    DEVID_MODEL_1125,
    DEVID_MODEL_1220,
    DEVID_MODEL_2250,
    DEVID_MODEL_CP_1160,         // CP 1160 - Jupiter Pro
    DEVID_MODEL_CP_1700,         // CP 1700 - Euler
    DEVID_MODEL_5550,            // DJ 5550 - Newport
    DEVID_MODEL_5551,            // DJ 5551 - Hayakuna
	DEVID_MODEL_LJMONO,
	DEVID_MODEL_LJCOLOR,
    MAX_ID_STRING
};

APDK_END_NAMESPACE

#endif  //APDK_MODELS_H
