/*****************************************************************************\
  dj8x5.h : Interface for the DJ8x5 class

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#ifndef APDK_DJ8X5_H
#define APDK_DJ8X5_H

APDK_BEGIN_NAMESPACE

/*!
\internal
*/
class DJ8x5 : public DJ8xx
{
public:
    DJ8x5 (SystemServices* pSS,int numfonts=0, BOOL proto=FALSE);

    virtual DRIVER_ERROR VerifyPenInfo();
    virtual PEN_TYPE DefaultPenSet();

protected:

}; //DJ8x5


class PhobosMode1 : public PrintMode
{
public:
    PhobosMode1();
}; //PhobosMode1


class PhobosMode2 : public PrintMode
{
public:
    PhobosMode2();
}; //PhobosMode2


class PhobosMode3 : public PrintMode
{
public:
    PhobosMode3();
}; //PhobosMode3

/*
class PhobosMode4 : public PrintMode
{
    public:
        PhobosMode4 ();
}; //PhobosMode4
*/

/*
class PhobosMode5 : public PrintMode
{
    public:
        PhobosMode5 ();
};
*/

#ifdef APDK_PROTO
extern PEN_TYPE ProtoPenType;
/*!
\internal
*/
class ProtoDJ8x5 : public DJ8x5
{
public:
    ProtoDJ8x5 (ProtoServices* pSS);

    DRIVER_ERROR ParsePenInfo(PEN_TYPE& ePen) { ePen=ProtoPenType; return NO_ERROR; }

}; //ProtoDJ8x5


#endif //APDK_PROTO

APDK_END_NAMESPACE

#endif //APDK_DJ8X5_H
