/***************************************************************************
	kjbutton.cpp
	--------------------------------------
	Handles all ordinary Buttons like stop, play, pause, etc.
	--------------------------------------
	Maintainer: Stefan Gehn <sgehn@gmx.net>

 ***************************************************************************/

#include "kjbutton.h"
#include "kjloader.h"

//#include "kjvis.h"
#include <noatun/player.h>

#include <kdebug.h>
#include <klocale.h>
#include <kpixmap.h>
#include <kpixmapeffect.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <khelpmenu.h>

/*******************************************
 * KJButton
 *******************************************/

KJButton::KJButton(const QStringList &i, KJLoader *parent)
	: KJWidget(parent), mTitle(i[0]), mShowPressed(false)
{
//	kdDebug(66666) << "new button: " << i[0].latin1() << endl;
	mPushedPixmap = (i.count() >= 7);

	// get the rectangle
	int x, y, xs, ys;
	x=i[1].toInt();
	y=i[2].toInt();
	xs=i[3].toInt()-x; // width
	ys=i[4].toInt()-y; // height
	setRect ( x, y, xs, ys );

	QStringList temp = i;

	// search for selected button-type
	// can be either BMPx where x is a number representing one
	// of the background-images
	// or darken which means just darken the button on click
	for ( QStringList::Iterator it = temp.begin(); it != temp.end(); ++it )
	{
		if( (*it).contains("bmp") )
		{
//			kdDebug(66666) << "key: " << (*it).latin1() << endl;
			mPressed = parent->pixmap( backgroundPressed((*it)) );
		}
		else if( (*it) == "darken" )
		{
			// take background and darken the buttons rectangle
			// FIXME: what KPixmapEffect causes the desired effect?
			//        intensity is the wrong one
			KPixmap temp = parent->pixmap(parser()["backgroundimage"][1]);
			mPressed = (QPixmap)KPixmapEffect::intensity ( temp, 1.2f );
		}
	}

	// playlistbutton has to show if playlistwindow is open
	// right after the button appears on screen
	if ( mTitle == "playlistbutton" )
	{
	if ( napp->playlist()->listVisible() )
		mShowPressed = true;
	}
}

QString KJButton::tip()
{
	QString str;
	if (mTitle=="closebutton")
		str=i18n("Close");
	else if (mTitle=="minimizebutton")
		str=i18n("Minimize");
	else if (mTitle=="aboutbutton")
		str=i18n("About");
	else if (mTitle=="stopbutton")
		str=i18n("Stop");
	else if (mTitle=="playbutton")
		str=i18n("Play");
	else if (mTitle=="pausebutton")
		str=i18n("Pause");
	else if (mTitle=="openfilebutton")
		str=i18n("Open");
	else if (mTitle=="playlistbutton")
		str=i18n("Playlist");
	else if (mTitle=="repeatbutton")
		str=i18n("Loop");
	else if (mTitle=="equalizerbutton")
		str="";
	else if (mTitle=="nextsongbutton")
		str=i18n("Next");
	else if (mTitle=="previoussongbutton")
		str=i18n("Previous");
	else if (mTitle=="forwardbutton")
		str=i18n("Forward");
	else if (mTitle=="rewindbutton")
		str=i18n("Rewind");
	else if (mTitle=="preferencesbutton")
		str=i18n("Preferences");
	else if (mTitle=="dockmodebutton")
		str=i18n("Switch to dockmode");
	else if (mTitle=="undockmodebutton")
		str=i18n("Return from dockmode");

	return str;
}

void KJButton::paint(QPainter *, const QRect &)
{
	if (mShowPressed)
		bitBlt(parent(), rect().topLeft(), &mPressed, rect(), Qt::CopyROP);
}

bool KJButton::mousePress(const QPoint &)
{
	bitBlt(parent(), rect().topLeft(), &mPressed, rect(), Qt::CopyROP);
	return true;
}

void KJButton::showPressed(bool b)
{
	mShowPressed = b;
	if ( mShowPressed )
		repaint(true); // repaint with selected image
	else
		repaint(false); // repaint with default image (player-background)
}

void KJButton::playlistShown(void)
{
//	kdDebug(66666) << "KJButton::playlistShown()" << endl;
	if (mTitle=="playlistbutton")
		showPressed(true);
}

void KJButton::playlistHidden(void)
{
//	kdDebug(66666) << "KJButton::playlistHidden()" << endl;
	if (mTitle=="playlistbutton")
		showPressed(false);
}

void KJButton::mouseRelease(const QPoint &, bool in)
{
	// repaint with default image (player-background)
	repaint(false);

	if (!in) // only do something if users is still inside the button
		return;

	// now, find what widget I am and do the proper action
	if (mTitle=="closebutton")
		parent()->close();
	else if (mTitle=="minimizebutton")
		parent()->minimize();
	else if (mTitle=="aboutbutton")
		parent()->helpMenu()->aboutApplication();
	else if (mTitle=="stopbutton")
		napp->player()->stop();
	else if (mTitle=="playbutton")
		napp->player()->play();
	else if (mTitle=="pausebutton")
		napp->player()->playpause();
	else if (mTitle=="openfilebutton")
	{
		KURL file(KFileDialog::getOpenURL(0, napp->mimeTypes(), parent(),
		                                  i18n("Select File to Play")));
		if (!file.isMalformed())
			napp->player()->openFile(file);
	}
	else if (mTitle=="playlistbutton")
		napp->player()->toggleListView();
	else if (mTitle=="repeatbutton")
	{
		if ( napp->player()->loopStyle() == 1)
		{
//			kdDebug(66666) << "loop song is OFF" << endl;

// bah, xlib.h already defined None
#undef None
			napp->player()->loop( Player::None );
			showPressed( false );
		}
		else
		{
//			kdDebug(66666) << "loop song is ON" << endl;
			napp->player()->loop( Player::Song );
			showPressed ( true );
		}
	}
	else if (mTitle=="equalizerbutton")
		;
	else if (mTitle=="nextsongbutton")
		napp->player()->forward();
	else if (mTitle=="previoussongbutton")
		napp->player()->back();
	else if (mTitle=="forwardbutton")
		napp->player()->skipTo(napp->player()->getTime()+10000); // TODO: make +- 10 secs configurable
	else if (mTitle=="rewindbutton")
		napp->player()->skipTo(napp->player()->getTime()-10000);
	else if (mTitle=="preferencesbutton")
		napp->preferences();
	else if (mTitle=="dockmodebutton")
		parent()->switchToDockmode();
	else if (mTitle=="undockmodebutton")
		parent()->returnFromDockmode();
	else
		kdDebug(66666) << "unknown buttontype: " << mTitle.latin1() << endl;
}
