// Copyright (C) 2002 Neil Stevens <neil@qualityassistant.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef MEGAMIWINDOW_H
#define MEGAMIWINDOW_H

#include <kmainwindow.h>
#include <qcanvas.h>
#include <qintdict.h>
#include <qptrlist.h>

#include "megamiconfig.h"
#include "dealer.h"

class KPushButton;
class QSpinBox;

class MegamiWindow : public KMainWindow
{
Q_OBJECT

public:
	MegamiWindow(QWidget * = 0, const char * = 0);
	virtual ~MegamiWindow();

protected:
	virtual void closeEvent(QCloseEvent *);
	virtual void resizeEvent(QResizeEvent *);

protected slots:
	void gameNew(void);
	void gameDeal(void);
	void gameQuit(void);
	void gameBet(void);
	void gameHit(void);
	void gameStand(void);
	void settingsCarddecks(void);
	void settingsPreferences(void);
	void settingsKeys(void);

	void applyPreferences(const MegamiConfig::Data &);

	void dealerAcceptingBets(void);
	void dealerBet(int, unsigned);
	void dealerDealt(int, bool, int);
	void dealerPlay(int);
	void dealerBust(int);
	void dealerPush(int);
	void dealerMegami(int);
	void dealerWin(int);
	void dealerLose(int);
	void dealerDone(void);

private:
	Megami::Dealer dealer;
	QPtrList< Megami::Connection > connection;

	void setCards(QString, QString);
	QIntDict<QPixmap> card;

	void refresh(void);
	void drawHand(int);
	void drawCash(int);
	void drawResult(int, const QString &);
	QCanvas canvas;
	QCanvasView *view;
	QCanvasPixmapArray *cardArray;
	// sprites for a player
	// sprites[i][0]     - text
	// sprites[i][1...n] - cards
	QPtrList< QPtrList<QCanvasItem> > sprites;
	QPtrList< QCanvasText > labels;
	QPtrList< QCanvasText > results;

	void computerTurn(int p);

	KPushButton *dealButton, *hitButton, *standButton, *betButton;
	QSpinBox *betBox;
	KAction *gameNewAction, *gameDealAction, *gameHitAction, *gameStandAction, *gameBetAction;
	
	static const unsigned numberOfPlayers;
};

#endif
