#include <klocale.h>

#include "htmlexport.h"

extern "C"
{
	Plugin *create_plugin()
	{
		return new HTMLExport();
	}
}


HTMLExport::HTMLExport(): QObject(0, "HTMLExport"), Plugin()
{
	NOATUNPLUGINC(HTMLExport);

	menuID = napp->pluginMenuAdd(i18n("&Export Playlist"), this, SLOT(slotExport()));
	(void) NoatunPrefAdd(this, Prefs, i18n("Playlist Export"), i18n("Colors and settings for HTML Export"));
	config = KGlobal::config();
}

HTMLExport::~HTMLExport()
{
	napp->pluginMenuRemove(menuID);
}

void HTMLExport::slotExport()
{

	// init readConfig
	config->setGroup("HTMLExport");

	// get output target
	KURL url = KFileDialog::getSaveURL(QString::null,
	                                   i18n("*.html"),
	                                   0,
	                                   i18n("Export Playlist"));

	// write into tempfile
	KTempFile temp;
	temp.setAutoDelete(true);
	QFile file(temp.name());
	file.open(IO_WriteOnly);
	QTextStream str(&file);

	str << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"" << endl;
	str << "					  \"http://www.w3.org/TR/REC-html40/loose.dtd\">" << endl;
	str << "<html>" << endl;
	str << "<head>" << endl;
	str << "\t<title>Noatun Playlist</title>" << endl;

	if ( config->readBoolEntry( "useCSS" ) == true )
	{
		str << "\t<style type=\"text/css\">" << endl;
		str << "\t<!--" << endl;
		str << "\tp,body,th,td { color:#"<< getColorByEntry("txtColor")<<" }" << endl;
		str << "\ta { color:#"<< getColorByEntry("lnkColor")<<" }" << endl;

		if ( config->readBoolEntry( "useHover" ) == true )
			str << "\ta:hover { color:#"<< getColorByEntry("hoverColor")<<" }"<< endl;

		str << "\t-->" << endl;
		str << "\t</style>" << endl;
	}

	str << "</head>" << endl;
	str << "<body bgcolor=\"" << getColorByEntry( "bgColor" )
		<< "\" background=\"" << config->readEntry( "bgImgPath" )
		<<"\">" << endl;
	str << "\t<h1 align=\"center\">Noatun Playlist</h1>" << endl;
	str << "\t<h2 align=\"center\">Experimental</h2>" << endl;
	str << "\t<table align=\"center\">" << endl;
	str << "\t\t<tr><th>Title</th></tr><tr><td><ol>" << endl;

	for (PlayListItem *item = napp->playList()->getFirst();
		item;
		item = napp->playList()->getAfter(item))
		str << "\t\t<li><a href=\"" << item->file() << "\">" << item->title() << "</a>" << endl;

	str << "\t</ol></td></tr></table>" << endl;
	str << "</body>" << endl;
	str << "</html>" << endl;

	file.close();
	// tempfile -> userdefined file
	KIO::NetAccess::upload(temp.name(), url);
}

QString HTMLExport::getColorByEntry(QString s)
{
   QString res;
   QString tmp;
   QColor c;

   // init readConfig

   config->setGroup("HTMLExport");

   c = config->readColorEntry( s );
   tmp = QString::number( c.red(), 16);
   if (tmp.length()==1) tmp="0"+tmp;
   res = tmp;

   tmp = QString::number( c.green(), 16);
   if (tmp.length()==1) tmp="0"+tmp;
   res += tmp;

   tmp = QString::number( c.blue(), 16);
   if (tmp.length()==1) tmp="0"+tmp;
   res += tmp;

   return res;

}
//////////////////////////////////// Settings ////////////////////////////////////

Prefs::Prefs(QWidget *parent, char *name)
	: CModule(parent, name)
{

	// Init Config
	KConfig *config = KGlobal::config();
	config->setGroup("HTMLExport");

	// Set default values
	if ( !config->hasKey( "lnkColor" ) )
	config->writeEntry( "lnkColor", QColor( blue ) ) ;

	if ( !config->hasKey( "hoverColor" ) )
	config->writeEntry( "hoverColor", QColor( red ) );

	if ( !config->hasKey( "bgColor" ) )
	config->writeEntry( "bgColor", QColor( white ) ) ;

	if ( !config->hasKey( "txtColor" ) )
	config->writeEntry( "txtColor", QColor( black ) );

	config->sync();

	// Draw Stuff and insert Settings
	(new QVBoxLayout(this))->setAutoAdd(true);

	colorBox = new QGroupBox( this, "colorBox" );
	colorBox->setGeometry( QRect( 20, 10, 210, 140 ) );
	colorBox->setTitle( i18n( "HTML Color Settings"  ) );
	colorBox->setFrameShape( QGroupBox::Box );

	QWidget* privateLayoutWidget = new QWidget( colorBox, "bgColorLabel" );
	privateLayoutWidget->setGeometry( QRect( 10, 20, 400, 140 ) );
	bgcolorLabel = new QGridLayout( privateLayoutWidget );
	bgcolorLabel->setSpacing( 6 );
	bgcolorLabel->setMargin( 0 );

	lnkColorSelect = new KColorButton( privateLayoutWidget, "lnkColorSelect" );
	lnkColorSelect->setColor(config->readColorEntry( "lnkColor" ) );

	hoverColorSelect = new KColorButton( privateLayoutWidget, "hoverColorSelect" );
	hoverColorSelect->setColor( config->readColorEntry( "hoverColor" ) );

	bgColorSelect = new KColorButton( privateLayoutWidget, "bgColorSelect" );
	bgColorSelect->setColor( config->readColorEntry( "bgColor" ) );

	txtColorSelect = new KColorButton( privateLayoutWidget, "txtColorSelect" );
	txtColorSelect->setColor( config->readColorEntry( "txtColor" ) );

	txtColorLabel = new QLabel( privateLayoutWidget, "txtColorLabel" );
	txtColorLabel->setText( i18n( "Text Color:"  ) );
	txtColorLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

	bgColorLabel = new QLabel( privateLayoutWidget, "bgColorLabel" );
	bgColorLabel->setText( i18n( "Background:"  ) );
	bgColorLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

	lnkColorLabel = new QLabel( privateLayoutWidget, "lnkColorLabel" );
	lnkColorLabel->setText( i18n( "Link Color:"  ) );
	lnkColorLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

	hoverColorLabel = new QLabel( privateLayoutWidget, "hoverColorLabel" );
	hoverColorLabel->setText( i18n( "Link Hover Color:" ) );
	hoverColorLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

	bgcolorLabel->addWidget( txtColorLabel, 0, 0 );
	bgcolorLabel->addWidget( txtColorSelect, 0, 1 );
	bgcolorLabel->addWidget( lnkColorLabel, 1, 0 );
	bgcolorLabel->addWidget( lnkColorSelect, 1, 1 );
	bgcolorLabel->addWidget( bgColorLabel, 2, 0 );
	bgcolorLabel->addWidget( bgColorSelect, 2, 1 );
	bgcolorLabel->addWidget( hoverColorLabel, 0, 2 );
	bgcolorLabel->addWidget( hoverColorSelect, 0, 3 );

	bgPicBox = new QGroupBox( this, "bgPicBox" );
	bgPicBox->setGeometry( QRect( 20, 160, 340, 60 ) );
	bgPicBox->setTitle( i18n( "Background Image"  ) );

	QWidget* pathLayoutWidget = new QWidget( bgPicBox, "bgPathEdit" );
	pathLayoutWidget->setGeometry( QRect( 10, 20, 610, 28 ) );
	bgPathEdit = new QHBoxLayout( pathLayoutWidget );
	bgPathEdit->setSpacing( 6 );
	bgPathEdit->setMargin( 0 );

	bgPicPath = new QLineEdit( pathLayoutWidget, "bgPicPath" );
	bgPicPath->setText( config->readEntry( "bgImgPath" ) );
	bgPathEdit->addWidget( bgPicPath );

	selectBtn = new QPushButton( pathLayoutWidget, "selectBtn" );
	selectBtn->setText( i18n( "&Select"  ) );
	bgPathEdit->addWidget( selectBtn );

	useCSS = new QCheckBox( this, "useCSS" );
	useCSS->setText( i18n( "&Use CSS 1"  ) );
	useCSS->setChecked( config->readBoolEntry( "useCSS" ) );
	useCSS->setTristate( false );
	useCSS->hide(); // we will _always_ do CSS atm
	QWhatsThis::add( useCSS, i18n( "Use <b>CSS Level 1</b> description for color and style data rather then the depreciated <i>&lt;font&gt;</i> tag in HTML output." ) );

	useHover = new QCheckBox( this, "useCSS" );
	useHover->setText( i18n( "&Enable Hover"  ) );
	useHover->setChecked( config->readBoolEntry( "useHover" ) );
	useHover->setTristate( false );
	QWhatsThis::add( useCSS, i18n( "This color will appear if you move your mouse over a link in a CSS enabled browser." ) );

	connect( selectBtn, SIGNAL( clicked() ), SLOT( slotInsertPath() ) );
	connect( useCSS, SIGNAL( toggled(bool t1) ), useHover, SLOT ( setDisabled(t1) ) );
	connect( useCSS, SIGNAL( toggled(bool t2) ), hoverColorSelect, SLOT ( setDisabled(t2) ) );
	connect( useHover, SIGNAL( toggled(bool t3) ), hoverColorSelect, SLOT ( setDisabled(t3) ) );
}


void Prefs::slotInsertPath()
{
	KURL url = KFileDialog::getOpenFileName( QString::null, "*.gif *.jpg *.png", 0, i18n( "Select Background Image" ) );
	bgPicPath->setText(url.url());
}

void Prefs::save()
{

	KConfig *config = KGlobal::config();
	config->setGroup( "HTMLExport" );
	config->writeEntry( "bgColor", bgColorSelect->color() );
	config->writeEntry( "txtColor", txtColorSelect->color() );
	config->writeEntry( "lnkColor", lnkColorSelect->color() );
	config->writeEntry( "bgImgPath", bgPicPath->text() );
	config->writeEntry( "useCSS", useCSS->isChecked() );
	config->writeEntry( "useHover", useHover->isChecked() );
	config->sync();
}

#include "htmlexport.moc"

