#ifndef PLAYLISTSAVER_H
#define PLAYLISTSAVER_H

#include <ksimpleconfig.h>

class PlayListSaver : public KSimpleConfig
{
public:
	PlayListSaver(const QString &file);
	~PlayListSaver();
	
	QString title();
	void setTitle(const QString &title);
	QDateTime date();
	QString location();
	
	static bool isPlayList(const QString &file);
	
	QStringList fileList() const;
	
	QString file() const;
	void setFile(const QString &file);
	
	
	
	
private:
	void setGroup(const QString &s) {KSimpleConfig::setGroup(s);}
	QString group() const { return KSimpleConfig::group(); }
	QStringList groupList() const {return KSimpleConfig::groupList();}
	
	static QString &stripFilePre(QString &);
	
	
};

#endif
