/*
* viewer.h -- Declaration of class KImageViewer.
* Generated by newclass on Wed Oct 15 11:37:16 EST 1997.
*/
#ifndef SSK_VIEWER_H
#define SSK_VIEWER_H

#include <kmainwindow.h>
#include <kaccel.h>
#include <qwmatrix.h>
#include <kurl.h>

class QMenuData;
class QPopupMenu;
class QMouseEvent;
class QString;
class QTimer;
class QAccel;

class KAccel;
class KDNDDropZone;
class KFiltMenuFactory;
class KConfigGroup;
class KImageCanvas;
class KImageFilter;
class KLocale;
class KMenuBar;
class KStatusBar;
class KIOJob;
class QDropEvent;
class KRecentFilesAction;
class KAction;
class KToggleAction;
class KActionMenu;
class KFilterAction;
class KFilterList;

class ImageListDialog;
class KAccelMenuWatch;


/**
* Top-level window
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: viewer.h,v 1.29 2001/02/04 18:28:06 coolo Exp $
*/
class KImageViewer : public KMainWindow
{
  Q_OBJECT
public:
  /**
  * KImageViewer Constructor
  */
  KImageViewer( KFilterList* );

  /**
  * KImageViewer Destructor
  */
  virtual ~KImageViewer();

  /**
  * Release the current cut buffer, if any.
  */
  void freeCutBuffer();

  /**
  * create a new tempfile where we can put this image
  */
  void addImage( const QImage& );

signals:
  void wantHelp( const QString & tag );

  /**
  * User has requested a new viewer object.
  */
  void wantNewViewer();

  /**
  * Viewer has lost the will to live.
  */
  void wantToDie( KImageViewer * );
  
  /**
  * A new image has been placed in the clipboard.
  */
  void newCutBuffer( QPixmap *buffer );

public slots:
  // File operations
  /** */
  void load();
  /** */
  void openRecent( const KURL& );
  /** */
  void file_close();

  /** */
  void quitApp();

  // Size
  /** */
  void zoomIn10();
  /** */
  void zoomOut10();
  /** */
  void zoomIn200();
  /** */
  void zoomOut50();
  /** */
  void zoomCustom();

  // Desktop
  void tile();
  void max();
  void maxpect();

  // Transformation
  /** */
  void rotateClock();
  /** */
  void rotateAntiClock();
  /** */
  void flipVertical();
  /** */
  void flipHorizontal();

  void reset();

  /** */
  void prefs();

  /**
   * Opens the Keys Configuration Dialog
   */
  void slotConfAccels();

  /**
  * Queues into the view list.
  */
  void appendURL( const KURL &url, bool show = false );

  /**
  * Toggle full screen mode.
  */
  void fullScreen();

  /**
  * Ask for print settings and print the image.
  */
  void printImage();

  void cut();
  void copy();
  void paste();

  void contextPress( const QPoint& );


  void toggleMenuBar();
  void toggleToolBar();
  void toggleStatusBar();

  void firstImage();

protected slots:
  void newViewer();
  void closeViewer();
  void slotEditToolbars();
  void slotSaveOptions();
  /** 
   * Save the current image on disk 
   */
  void slotSave();
  /**
   * Ask for a filename and save on disk
   */
  void saveAs();

private slots:
  void invokeFilter( KImageFilter *filter );

  void setStatus( const QString & status );
  void message( const QString & message );
  void setProgress( int pct );

  void toggleImageList();

  void loadFile( const QString & file, const KURL &url = KURL() );

protected:

  /**
  * This should be called _before_ show!
  */
  void connectFilters( KFilterList* );

  /** save the image to a file */
  bool saveFile( const QString&, QString, const KURL& );
  /** uses KAction - this function does the setup */
  void setupActions( KFilterList* );  
  /** enables/disables some menu entries */
  void menuEntriesEnabled( bool );

  virtual void closeEvent( QCloseEvent * );

  virtual void saveProperties( KConfig* );
  virtual void readProperties( KConfig* );

  virtual void saveOptions();
  virtual void restoreOptions();

  virtual void dragEnterEvent(QDragEnterEvent* event);
  virtual void dropEvent(QDropEvent *e);

private:
  /** image canvas */
  KImageCanvas  *_canvas;
  bool    _imageLoaded;
    
  uint m_bFullScreen:1;

  KRecentFilesAction *m_recent;
  KAction *m_fileSave;
  KAction *m_fileSaveAs;
  KAction *m_fileClose;
  KAction *m_filePrint;
  KAction *m_editFullScreen;
  KAction *m_editCrop;
  KAction *m_editReset;
  KActionMenu *m_viewMenu;
  KAction *m_viewZoom;
  KAction *m_viewZoomIn;
  KAction *m_viewZoomOut;
  KAction *m_viewDouble;
  KAction *m_viewHalf;
  KAction *m_viewMax;
  KAction *m_viewMaxpect;
  KActionMenu *m_transMenu;
  KAction *m_transRotateClock;
  KAction *m_transRotateAnti;
  KAction *m_transFlipV;
  KAction *m_transFlipH;
  KActionMenu *m_deskMenu;
  KAction *m_deskTile;
  KAction *m_deskMax;
  KAction *m_deskMaxpect;
  KAction *m_imageList;
  KAction *m_imagePrev;
  KAction *m_imageNext;
  KAction *m_imageSlide;
  KFilterAction *m_filterMenu;
  KToggleAction *m_settingsShowMenuBar;
  KToggleAction *m_settingsShowToolBar;
  KToggleAction *m_settingsShowStatusBar;

  // Net transfer stuff
  //enum TransferDir {
    //Get,
    //Put
  //};
  QString m_filename;
  QString m_format;
  KURL m_url;

  //KIOJob    *_iojob;
  //QString    _transSrc;
  //QString    _transDest;
  //TransferDir  _transDir;

  //KFiltMenuFactory *m_menuFact;

  QString   *_pctBuffer;
  int    _lastPct;

  QTimer    *_msgTimer;

  ImageListDialog  *_imageList;

  QPoint    _posSave;
  QSize    _sizeSave;
  QWMatrix  _mat;

  int    _zoomFactor;

  enum LoadMode { ResizeWindow, ResizeImage, ResizeNone };
  LoadMode  _loadMode;
  KAccel *m_accel;

private:
  /**
  * Resize the window to fit the image.
  */
  void rzWinToImg();


};

#endif // SSK_VIEWER_H
