/**
 * This is essentially the KGhostview widget stripped down and without all the
 * KTMainWindow dependencies (there were quite a bit with menus, toolbars,
 * etc.. accessed all over the place). It would probably make sense to make
 * that use this in the future (mosfet@kde.org).
 */
 
#ifndef __KGV_MINIWIDGET_H
#define __KGV_MINIWIDGET_H

#include <qsize.h>
#include <qvaluelist.h>

// #include "kdsc.h"
#include "kpswidget.h"
#include "marklist.h"

#include <stdlib.h>
#include <math.h>

#include <signal.h>
#ifdef SIGNALRETURNSINT
#define SIGVAL int
#else
#define SIGVAL void
#endif

#include <qwidget.h>
#include <qlabel.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qpushbutton.h>

#include <kurl.h>

#include "kgv_view.h"

class GotoDialog;
class InfoDialog;
class ScrollBox;

class KGVMiniWidget : public QWidget
{
    Q_OBJECT

public:
    KGVMiniWidget( KPSWidget* psWidget, KGVPart* parent=0, 
		   const char* name=0 );
    ~KGVMiniWidget();

    /**
     * Is a file currently open?
     **/
    bool isFileOpen() {return psfile!=0;}

    /**
     * Open the @em local file @p filename.
     **/
    bool openFile(QString filename);

    /**
     * Tell what was the original URL requested by the user.
     **/
    void setOriginalURL (const KURL &url);

    /**
     * Enable/disable fancy, document-supplied page labels.
     **/
    void enableFancyPageLabels( bool e = true );
    bool areFancyPageLabelsEnabled () { return _useFancyPageLabels; }
    /**
     * Write settings to application config file.
     **/
    void writeSettings();

    /**
     * A list of page media (sizes).
     **/
    const QStringList &sizeList () {return medialist;}

    /**
     * 1 - Portrait, 2 - Upside Down, 3 - Landscape, 4 - Seascape
     **/
    void setAutoOrientation();
    void setManualOrientation( int orientation );
    int	orientation( int pageNo ) const;

    /**
     * The argument is an index into mediaList()
     **/
    void setAutoPageMedia();
    void setManualPageMedia( int pageMedia );
    int pageMedia( int pageNo ) const;
    // int getSize() { return current_pagemedia; }

public slots:
    /**
     * Save the current document as the @em local file @p filename
     **/
      void saveAs ();

    void prevPage();
    void nextPage();
    void firstPage();
    void lastPage();
    void goToPage();
    void goToPage( int page );
    void print();
    void zoomIn();
    void zoomOut();
    //    void zoom( float zoom_factor );
    void markPage();
    /**
     * Redisplay the page if the file has changed on disk.
     **/
    void redisplay();
    void info();
    void fileChanged( const QString& );    
    void configureGhostscript();

signals:
    /**
     * Page changed.
     **/
    void newPageShown( int page );

    void setStatusBarText( const QString& );

    /**
     * Emitted if a fileChanged() call fails.
     **/
    void fileChangeFailed();

protected:
    bool setup();
    void buildTOC();
    void show_page(int pagenumber);

    void paletteChange( const QPalette & );
    
    /**
     * Build the page media list
     * The page media list has two parts:
     *  - the document defined page medias
     *  - the standard page media defined fram Adobe's PPD
     */ 
    void build_pagemedia_list();
    
    int guessOrientation( int pagenumber ) const;
    KDSC::BoundingBox computeBoundingBox( int pageMedia );
    
    void setMagstep( unsigned int magstep );
    void magnify( float& dpi, unsigned int magstep );
    void new_file(int number);

    void readSettings();

    KPSWidget* page;

    QValueList<int> generatePageList( int mode, bool reverseOrder,
				      int pgStart, int pgEnd,
				      unsigned int copies );

    QString printToFile( const QValueList<int>& pagelist, 
			 const QString& saveURL );
    QString printToPrinter( const QValueList<int>& pagelist, bool allMode );

    void psCopyDoc( FILE *fp, const QValueList<int>& pagelist );


    FILE		*psfile;
    int			current_page;
    KDSC::Document*	_doc;
    struct 		document *doc;

private:
    bool convertFromPDF();
    
    QString printerName;
    unsigned int shrink_magsteps, expand_magsteps;
    unsigned int _magstep;
    int	base_papersize;
    bool toc_text;
    int	toc_length;
    int	toc_entry_length;
    QString page_total_label;
    QString page_string;
    QString page_label_text;
    QString position_label;
    float _defaultXdpi, _defaultYdpi;
    int hintwidth;
    bool _useFancyPageLabels;

    KURL origurl;
    QString _fileName;
    
    MarkList* _marklist;

    InfoDialog *mInfoDialog;
    GotoDialog *mGotoDialog;

    enum DocFormat {PS, PDF};
    DocFormat format;
    QString tmpfile1, tmppdf;
    QStringList medialist;

    bool    _useManualOrientation;
    int	    _manualOrientation;
    
    bool    _useManualPageMedia;
    int	    _manualPageMedia;
    int	    _defaultPageMedia;

    QString _interpreterPath;
};

#endif
