#ifndef _KDSC_H_
#define _KDSC_H_

#include <qcstring.h>
#include <qfile.h>
#include <qstring.h>
#include <qvector.h>

extern "C" {
#include "ps.h"
}

namespace KDSC {

class Page;
    
class Offset
{
public:
    Offset()
	{ _begin = 0; _end = 0; _length = 0; }
    Offset( long begin, long end, unsigned int length )
	{ _begin = begin; _end = end; _length = length; }
    
    long begin() const		{ return _begin; }
    long end() const		{ return _end; }
    unsigned int length() const { return _length; }
    
private:
    long _begin, _end;
    unsigned int _length;
};

struct DocumentMedia
{
public:
    DocumentMedia()
	{ _name = QString::null, _width = 0; _height = 0; }
    DocumentMedia( const QString& name, int width, int height )
	{ _name = name, _width = width; _height = height; }
    
private:
    QString _name;
    int _width;
    int _height;
};

class BoundingBox
{
public:
    BoundingBox()
	{ _llx = 0; _lly = 0; _urx = 0; _ury = 0; }
    BoundingBox( const BoundingBox& b )
	{ _llx = b._llx; _lly = b._lly; _urx = b._urx; _ury = b._ury; }
    BoundingBox( int llx, int lly, int urx, int ury )
	{ _llx = llx; _lly = lly; _urx = urx; _ury = ury; }
    BoundingBox( int bbox[4] )
	{ _llx = bbox[0]; _lly = bbox[1]; _urx = bbox[2]; _ury = bbox[3]; }

    BoundingBox& operator = ( const BoundingBox& b )
	{ _llx = b._llx; _lly = b._lly; _urx = b._urx; _ury = b._ury;
	  return *this; }
    
    bool operator == ( const BoundingBox& b )
	{ return ( _llx == b._llx && _lly == b._lly 
		&& _urx == b._urx && _ury == b._ury ); }
    bool operator != ( const BoundingBox& b ) 
	{ return !( *this == b ); }
    
    int llx() const { return _llx; }
    int lly() const { return _lly; }
    int urx() const { return _urx; }
    int ury() const { return _ury; }

    int width() const  { return _urx - _llx; }
    int height() const { return _ury - _lly; }

private:
    int _llx, _lly, _urx, _ury;
};

enum Orientation { NONE, PORTRAIT, LANDSCAPE };

class Document
{
public:
    Document( const QString& fileName );
    ~Document();

    bool scan( FILE** PSFile );
    bool isScanned() const { return _isScanned; }
   
    bool isEPSF() const { return _isEPSF; }
    
    QString title() const   { return _title; }
    QString date() const    { return _date; }

    Offset headerOffset() const	    { return _headerOffset; }
    Offset previewOffset() const    { return _previewOffset; }
    Offset defaultsOffset() const   { return _defaultsOffset; }
    Offset prologOffset() const	    { return _prologOffset; }
    Offset setupOffset() const	    { return _setupOffset; }
    Offset trailerOffset() const    { return _trailerOffset; }
    
    BoundingBox boundingBox() const { return _boundingBox; } 
    BoundingBox defaultPageBoundingBox() const 
	{ return _defaultPageBoundingBox; }

    int orientation() const { return _orientation; }
    int defaultPageOrientation() const 
	{ return _defaultPageOrientation; }
    
    unsigned int numberOfPages() const { return _numberOfPages; }

    Page* page( int number ) { return _pages.at( number ); }

    struct document* _doc;

private:
    bool _isScanned;
    QString _fileName;
    
    bool _isEPSF;
    QString _title;
    QString _date;
    // PageOrder

    Offset _headerOffset;
    Offset _previewOffset;
    Offset _defaultsOffset;
    Offset _prologOffset;
    Offset _setupOffset;
    Offset _trailerOffset;

    BoundingBox _boundingBox;
    BoundingBox _defaultPageBoundingBox;
   
    int _orientation;
    int _defaultPageOrientation;
/*
    Orientation _orientation;
    Orientation _defaultPageOrientation;

    DocumentMedia _media;
    DocumentMedia _defaultPageMedia;
*/
    unsigned int _numberOfPages;

    QVector<Page> _pages;
};

class Page
{
public:
    friend class Document;
    
    Page() { ; }
    
    unsigned int number() const	    { return _number; }
    QString label() const	    { return _label; }
    BoundingBox boundingBox() const { return _boundingBox; }
    // Orientation orientation() const { return _orientation; }
    int orientation() const { return _orientation; }
    Offset offset() const	    { return _offset; }

private:
    unsigned int _number;
    QString _label;
    BoundingBox _boundingBox;
    int _orientation;
    // Orientation _orientation;
    Offset _offset;
};

}

#endif
