/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kfiledialog.h>
#include <qpushbutton.h>
#include <qwhatsthis.h>
#include <klineedit.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "preferenceswidget.h"
#include "pwidget.h"

PreferencesWidget::PreferencesWidget(QWidget *parent, const char* name)
		: PrefWidget(parent,name)
		, changed(false)
{
	QVBoxLayout *layout = new QVBoxLayout(this);
		
	prefWidget = new PWidget(this);
	layout->addWidget(prefWidget);

	connect(prefWidget->caseBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	connect(prefWidget->equalBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	connect(prefWidget->isContainedBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	connect(prefWidget->containsBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	connect(prefWidget->fuzzyBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	connect(prefWidget->hasWordBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	connect(prefWidget->wholeBtn, SIGNAL(toggled(bool))
					, this, SLOT(setChanged()));
	
	connect(prefWidget->urlInput->lineEdit(),SIGNAL(textChanged(const QString&))
					, this, SLOT(setChanged()));

	connect(prefWidget->equalBtn, SIGNAL(toggled(bool))
					, this, SLOT(equalBtnToggled(bool)));
	connect(prefWidget->isContainedBtn, SIGNAL(toggled(bool))
					, this, SLOT(isContainedBtnToggled(bool)));
	connect(prefWidget->containsBtn, SIGNAL(toggled(bool))
					, this, SLOT(containsBtnToggled(bool)));
	connect(prefWidget->hasWordBtn, SIGNAL(toggled(bool))
					, this, SLOT(hasWordBtnToggled(bool)));


	QString whatsthis=i18n("<qt><p><b>Parameters</b></p>"
		"<p>Here you can finetune the searching in the po file."
		"For example if you want to search case sensitive or if "
        "fuzzy messages should be ignored.</p></qt>" );
	QWhatsThis::add(prefWidget->caseBtn,whatsthis);
	QWhatsThis::add(prefWidget->fuzzyBtn,whatsthis);
	QWhatsThis::add(prefWidget->wholeBtn,whatsthis);

	whatsthis = i18n("<qt><p><b>Comparison Options</b></p>"
		"<p>Choose here what messages you want to have treated as a matching "
		"message.</p></qt>");
	QWhatsThis::add(prefWidget->equalBtn,whatsthis);
	QWhatsThis::add(prefWidget->containsBtn,whatsthis);
	QWhatsThis::add(prefWidget->isContainedBtn,whatsthis);
	QWhatsThis::add(prefWidget->hasWordBtn,whatsthis);

	whatsthis = i18n("<qt><p><b>Location</b></p>"
					"<p>Configure here what file has to be used for searching."
					"</p></qt>");
	QWhatsThis::add(prefWidget->urlInput,whatsthis);
}

PreferencesWidget::~PreferencesWidget()
{
}


void PreferencesWidget::apply()
{
	emit applySettings();
}

void PreferencesWidget::cancel()
{
	emit restoreSettings();
}

void PreferencesWidget::standard()
{
	prefWidget->urlInput->setURL("http://i18n.kde.org/po_overview/@LANG@.messages");
	prefWidget->caseBtn->setChecked(false);
	prefWidget->equalBtn->setChecked(true);
	prefWidget->isContainedBtn->setChecked(false);
	prefWidget->containsBtn->setChecked(false);
	prefWidget->wholeBtn->setChecked(true);
	prefWidget->hasWordBtn->setChecked(true);

	prefWidget->fuzzyBtn->setChecked(true);
	
	changed=true;
}

void PreferencesWidget::setURL(const QString url)
{
	prefWidget->urlInput->setURL(url);
	changed=false;
}

void PreferencesWidget::setCaseSensitive(bool on)
{
	prefWidget->caseBtn->setChecked(on);
	changed=false;
}

void PreferencesWidget::setMatchEqual(bool on)
{
	prefWidget->equalBtn->setChecked(on);
	changed=false;
}

void PreferencesWidget::setMatchIsContained(bool on)
{
	prefWidget->isContainedBtn->setChecked(on);
	changed=false;
}

void PreferencesWidget::setMatchContains(bool on)
{
	prefWidget->containsBtn->setChecked(on);
	changed=false;
}

void PreferencesWidget::setIgnoreFuzzy(bool on)
{
	prefWidget->fuzzyBtn->setChecked(on);
	changed=false;
}

void PreferencesWidget::setWholeWords(bool on)
{
	prefWidget->wholeBtn->setChecked(on);
	changed=false;
}


void PreferencesWidget::setMatchWords(bool on)
{
	prefWidget->hasWordBtn->setChecked(on);
	changed=false;
}



QString PreferencesWidget::url()
{
	changed=false;
	return prefWidget->urlInput->url();
}

bool PreferencesWidget::caseSensitive()
{
	changed=false;

	return prefWidget->caseBtn->isChecked();
}

bool PreferencesWidget::matchEqual()
{
	changed=false;

	return prefWidget->equalBtn->isChecked();
}

bool PreferencesWidget::matchIsContained()
{
	changed=false;

	return prefWidget->isContainedBtn->isChecked();
}

bool PreferencesWidget::matchContains()
{
	changed=false;

	return prefWidget->containsBtn->isChecked();
}

bool PreferencesWidget::ignoreFuzzy()
{
	changed=false;

	return prefWidget->fuzzyBtn->isChecked();
}


bool PreferencesWidget::wholeWords()
{
	changed=false;

	return prefWidget->wholeBtn->isChecked();
}


bool PreferencesWidget::matchWords()
{
	changed=false;

	return prefWidget->hasWordBtn->isChecked();
}



bool PreferencesWidget::settingsChanged() const
{
	return changed;
}

void PreferencesWidget::setChanged()
{
	changed=true;
}


void PreferencesWidget::equalBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
						&& !prefWidget->containsBtn->isChecked()
						&& !prefWidget->hasWordBtn->isChecked())
		{
			prefWidget->equalBtn->setChecked(true);
		}
	}
}

void PreferencesWidget::isContainedBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->equalBtn->isChecked() 
						&& !prefWidget->containsBtn->isChecked()
						&& !prefWidget->hasWordBtn->isChecked())
		{
			prefWidget->isContainedBtn->setChecked(true);
		}
	}
}

void PreferencesWidget::containsBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
						&& !prefWidget->equalBtn->isChecked()
						&& !prefWidget->hasWordBtn->isChecked())
		{
			prefWidget->containsBtn->setChecked(true);
		}
	}
}

void PreferencesWidget::hasWordBtnToggled(bool on)
{
	if(!on)
	{
		if(!prefWidget->isContainedBtn->isChecked() 
						&& !prefWidget->equalBtn->isChecked()
                        && !prefWidget->containsBtn->isChecked())
		{
			prefWidget->hasWordBtn->setChecked(true);
		}
	}
}

