#include <kwin.h>
#include <kglobal.h>
#include <kiconloader.h>

#include "kasitem.h"

const int MAX_FRAMES = 50;

KasItem::KasItem( WId w )
{
    setStarted( w );
}

KasItem::KasItem()
{
    starting = true;
    dying = false;
    desk = 1;
    sticky = false;
    aniFrame = 0;
}

KasItem::~KasItem()
{
    ;
}

void KasItem::refresh()
{
    if ( !starting ) {
        KWin::Info info = KWin::info( win );
        winStr = info.name; // ###
        desk = info.desktop;
        sticky = info.onAllDesktops;
        mappingState = info.mappingState;
        state = info.state;
    }
}

void KasItem::refreshIcon()
{
    if ( !starting ) {
        //
        // Try 34x34 first for KDE 2.1 icons with shadows, if we don't
        // get one then try 32x32.
        //
        pixmap = KWin::icon( win, 34, 34, false  );

        if ( ( pixmap.width() != 34 ) || ( pixmap.height() != 34 ) ) {
            if ( ( pixmap.width() != 32 ) || ( pixmap.height() != 32 ) )
                pixmap = KWin::icon( win, 32, 32, true  );
        }

        if( pixmap.isNull() )
            pixmap = KGlobal::iconLoader()->loadIcon( "go",
                                                      KIcon::NoGroup,
                                                      KIcon::SizeMedium );
    }
}

int KasItem::desktop() const
{
    if ( sticky )
        return -1;
    else
        return desk;
}

void KasItem::setStarted( WId w )
{
    win = w;
    starting = false;
    refresh();
    refreshIcon();

}

void KasItem::nextFrame()
{
    aniFrame = ( ++aniFrame ) % MAX_FRAMES;
}
