/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.internal.awt;

import com.apple.mrj.internal.awt.GraphicsHost;
import com.apple.mrj.internal.awt.PortManager;
import com.apple.mrj.internal.awt.QDGraphics;
import com.apple.mrj.internal.awt.QDPipeline;
import com.apple.mrj.internal.awt.QDRectStruct;
import com.apple.mrj.internal.awt.RGBColorValue;
import com.apple.mrj.internal.awt.VAWTDirect;
import com.apple.mrj.internal.awt.VToolkit;
import com.apple.mrj.macos.generated.QuickdrawFunctions;
import com.apple.mrj.macos.generated.RectStruct;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class PrintingPort
implements GraphicsHost {
    private int mPrintingPort;
    private int mOriginX;
    private int mOriginY;
    private PortManager mPortManager;
    private QDPipeline mPipeline;
    private Rectangle mClipping;
    private static final short MAXSHORT = Short.MAX_VALUE;
    private static final short MINSHORT = Short.MIN_VALUE;

    public PrintingPort(int printingPort, int originX, int originY) {
        this.mPrintingPort = printingPort;
        this.mOriginX = originX;
        this.mOriginY = originY;
        this.mPortManager = new PortManager(printingPort, 0, 0, 3, 0);
        this.mPipeline = new QDPipeline();
        this.mPortManager.setPipeline(this.mPipeline);
    }

    public void dispose() {
        if (this.mPortManager != null) {
            this.mPortManager.dispose();
            this.mPortManager = null;
        }
        if (this.mPipeline != null) {
            this.mPipeline.dispose();
            this.mPipeline = null;
        }
    }

    static short pinToShort(int value) {
        if (value > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        if (value < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)value;
    }

    public Graphics getGraphics(Component component) {
        this.mClipping = component.getBounds();
        this.mClipping.x = this.mOriginX;
        this.mClipping.y = this.mOriginY;
        PrintingGraphics graphics = new PrintingGraphics();
        graphics.initialize(this.mPrintingPort, this, this.mPortManager, this.mOriginX, this.mOriginY, this.mClipping, component.getForeground(), component.getFont());
        return graphics;
    }

    public void graphicsCreated(QDGraphics g) throws OutOfMemoryError {
    }

    public void graphicsDisposed(QDGraphics g) {
    }

    public RGBColorValue getBackgroundRGB() {
        return new RGBColorValue(Color.white);
    }

    public void repaint(RectStruct r) {
    }

    public boolean markInUse() {
        return this.mPortManager != null;
    }

    public void doneUsingIt() {
    }

    final class PrintingGraphics
    extends QDGraphics {
        public synchronized Graphics create() {
            QDGraphics qDGraphics;
            if (!this.internalMarkHostInUse()) {
                throw new AWTError("Using invalid Graphics object");
            }
            try {
                qDGraphics = new PrintingGraphics().initialize(this, this.fXoff, this.fYoff, this.fClip);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.internalDoneUsingHost();
                throw throwable;
            }
            this.internalDoneUsingHost();
            return qDGraphics;
        }

        public synchronized Graphics create(int x, int y, int width, int height) {
            QDGraphics qDGraphics;
            if (!this.internalMarkHostInUse()) {
                throw new AWTError("Using invalid Graphics object");
            }
            try {
                VToolkit.intersect((Rectangle)QDGraphics.sRectangle, (Rectangle)this.fClip, (int)(this.fXoff + x), (int)(this.fYoff + y), (int)width, (int)height);
                qDGraphics = new PrintingGraphics().initialize(this, this.fXoff + x, this.fYoff + y, QDGraphics.sRectangle);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.internalDoneUsingHost();
                throw throwable;
            }
            this.internalDoneUsingHost();
            return qDGraphics;
        }

        void restore() {
            super.restore();
            int port = VAWTDirect.FastGetThePort();
            if (port != PrintingPort.this.mPrintingPort) {
                QuickdrawFunctions.SetPort((int)PrintingPort.this.mPrintingPort);
            }
            QuickdrawFunctions.SetOrigin((short)0, (short)0);
            QDRectStruct clipRect = new QDRectStruct();
            clipRect.Set(PrintingPort.pinToShort(((PrintingPort)PrintingPort.this).mClipping.x), PrintingPort.pinToShort(((PrintingPort)PrintingPort.this).mClipping.y), PrintingPort.pinToShort(((PrintingPort)PrintingPort.this).mClipping.x + ((PrintingPort)PrintingPort.this).mClipping.width), PrintingPort.pinToShort(((PrintingPort)PrintingPort.this).mClipping.y + ((PrintingPort)PrintingPort.this).mClipping.width));
            QuickdrawFunctions.ClipRect((RectStruct)clipRect);
            if (port != PrintingPort.this.mPrintingPort) {
                QuickdrawFunctions.SetPort((int)port);
            }
        }
    }
}

