/*
 *  Copyright (C) 1999-2001 Bruno Pires Marinho
 *  Copyright (C) 2000-2001 Matthew Tuck
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _DIALOG_COMMON_ELEMENTS_H
#define _DIALOG_COMMON_ELEMENTS_H

#include <gnome.h>
#include "file-data.h"

typedef struct
{
    GtkWidget *download_dir;     /* Entry */
    GtkWidget *use_proxy;    /* Toggle button */
    GtkWidget *use_auto_dl;  /* Check button */
} DlPolicyWidgets;

typedef struct
{
    gchar    *download_dir;
    gboolean use_proxy;
    gboolean use_auto_dl;
} DlPolicyData;

void add_download_policy_widget (GtkWidget *dlg, DlPolicyWidgets *widgets,
			         gchar *initial_download_dir,
                                 GtkSignalFunc match_handler, void *data);

void get_dl_policy_data (DlPolicyData *data, DlPolicyWidgets *widgets);

FileData *dl_policy_file_data_create (gchar *url, DlPolicyData *data);

gchar *download_dir_canonical_dup (gchar *download_dir);

void change_default_download_dir (gchar *download_dir);

gchar *get_filename (gchar *url);

GtkTargetEntry *target_table (void);

gint target_table_count (void);

void configure_ok_cancel_dialog (GnomeDialog *dlg, 
                                 GtkSignalFunc ok_callback,
                                 GtkSignalFunc cancel_callback,
                                 gpointer data);

void dir_suggested_check (gchar *dir, DlPolicyWidgets *dl_policy,
                          GtkWidget *dlg);

gboolean download_not_dir_check (gchar *url, GtkWidget *dlg);

#endif /* _DIALOG_COMMON_ELEMENTS_H */



