/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

void mime_add(gchar *name, gchar *program, gchar *extensions,
	      MimeAction action);
void mime_delete(MimeItem *m);
void mime_update(MimeItem *m, gchar *name, gchar *program, 
		 gchar *extensions, MimeAction action);
void mime_get_entry(gchar **name, gchar **program, gchar **extensions,
		    MimeAction *action);
MimeAction mime_get_action (const gchar *mime_type);
void mime_set_action (const gchar *mime_type, MimeAction action);
MimeItem *mime_item_clone (MimeItem *m);
void mime_item_free (MimeItem *m);

#ifdef __cplusplus
}
#endif
